<?php
namespace App;
//use AmrShawky\LaravelCurrency\Facade\Currency;
use Twilio\Rest\Client;
use DB;
class Helpers
{    
    static function send_otp($receiverNumber){
        try{
            $date = date('Y-m-d');
            $isExist = DB::table('fraud_detection')->whereDate('otp_sent_at',$date)->where('mobile_no',$receiverNumber)->orderBy('id','desc')->first();
            if($isExist){
                $minutes = round(abs(time() - strtotime($isExist->otp_sent_at))/60);
                if($minutes < env('OTP_WAIT_MINUTE')){
                    return response()->json([
                        'status' => false,
                        'error' => 'Wait for '.env('OTP_WAIT_MINUTE').' minute...',
                    ], 422);
                }
            }
            // send entry in fraud detection table
            DB::table('fraud_detection')->insert([
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'mobile_no' => $receiverNumber,
                'otp_sent_at' => date('Y-m-d H:i:s')
            ]);
            
            $account_sid = env("TWILIO_SID");
            $auth_token = env("TWILIO_TOKEN");
            $verify_sid = env("TWILIO_VERIFY_SID");
            $twilio = new Client($account_sid, $auth_token);
            $verification = $twilio->verify->v2->services($verify_sid)->verifications->create($receiverNumber, "sms");
            return response()->json([
                'status' => true,
                'message' => 'Check you mobile SMS for your one time code.',
            ], 200);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    static function verify_otp($receiverNumber,$otp){
        try{
            $account_sid = env("TWILIO_SID");
            $auth_token = env("TWILIO_TOKEN");
            $verify_sid = env("TWILIO_VERIFY_SID");
            $twilio = new Client($account_sid, $auth_token);
            
            $verification = $twilio->verify->v2->services($verify_sid)->verificationChecks
                        ->create(['code'=>$otp, 'to' => $receiverNumber]);
            
            if ($verification->valid) {
                return true;
            }else{
                return false;
            }
        }catch(\Exception $e){
            return false;
        }
    }

    static function __send_email($email, $template_data, $templateId = null){
        try
        {
            $apiKey = env('SENDGRID_API_KEY');
            $sender = env('MAIL_FROM_ADDRESS');
            if(is_null($templateId)){
                $templateId = env('SENDGRID_TEMPLATE_ID');
            }
            $dynamic_data = [];
            $dynamic_data["template_id"] = $templateId;
            $dynamic_data["from"] = ['email'=>$sender];
            $dynamic_data["personalizations"][] = ['to' => [['email'=>$email]], 'dynamic_template_data' => $template_data];
            $dynamicContent = json_encode($dynamic_data);
            
            $sendgridurl = 'https://api.sendgrid.com/v3/mail/send';
            
            $sendmail = curl_init();
            curl_setopt($sendmail, CURLOPT_POST, 1);
            curl_setopt($sendmail, CURLOPT_POSTFIELDS, $dynamicContent);
            curl_setopt($sendmail, CURLOPT_URL,  $sendgridurl);
            curl_setopt($sendmail, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($sendmail, CURLOPT_HTTPHEADER, array("Authorization: Bearer $apiKey", "Content-Type: application/json;charset=UTF-8"));
            curl_setopt($sendmail, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            $createResult = curl_exec($sendmail);
            curl_close($sendmail);
            $result = json_decode($createResult,true);
            //dd($result);
            if(isset($result['errors'][0]['message'])){
                return response()->json([
                    'status' => false,
                    'error' => $result['errors'][0]['message'],
                ], 422); 
            }else{
                return response()->json([
                    'status' => true
                ], 200);
            }
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    static function clean_string($string){
        $string = str_replace(' ', '-', strtolower($string));
        return preg_replace('/[^A-Za-z0-9.\-]/', '', $string);
    }

    static function generatePassword($length = 8, $strength = 1) {
        $alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789@#$%";
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < $length; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass);
    }

    static function convertCurrencyToUSD($amount){
        $user_currency = session()->get('user_currency');
        if($user_currency=='USD'){ return $amount; }
        if(session()->has('currency') && isset(session()->get('currency')[$user_currency])){
            $conversion_rate = session()->get('currency')[$user_currency];
            $converted_amount = number_format(($amount/$conversion_rate), 2);
            return $converted_amount;
        }
        return $amount;
    }

    static function convertCurrencyFromUSD($amount){
        $user_currency = session()->get('user_currency');
        if($user_currency=='USD'){ return $amount; }
        if(session()->has('currency') && isset(session()->get('currency')[$user_currency])){
            $conversion_rate = session()->get('currency')[$user_currency];
            $converted_amount = round($amount*$conversion_rate);
            return $converted_amount;
        }
        return $amount;
    }

    static function create_thumbnail($storage_path, $imageName, $thumb_width, $thumb_height){
        $image_ext = pathinfo($imageName, PATHINFO_EXTENSION);
        $uploaded_image = $storage_path.'/'.$imageName;
        $thumbnail = $storage_path.'thumb_'.$imageName;
        list($width,$height) = getimagesize($uploaded_image);
        $thumb_create = imagecreatetruecolor($thumb_width,$thumb_height);
        switch($image_ext){
            case 'jpg':
                $source = imagecreatefromjpeg($uploaded_image);
                break;
            case 'jpeg':
                $source = imagecreatefromjpeg($uploaded_image);
                break;

            case 'png':
                $source = imagecreatefrompng($uploaded_image);
                break;
            case 'gif':
                $source = imagecreatefromgif($uploaded_image);
                break;
            default:
                $source = imagecreatefromjpeg($uploaded_image);
        }

        imagecopyresized($thumb_create,$source,0,0,0,0,$thumb_width,$thumb_height,$width,$height);
        switch($image_ext){
            case 'jpg' || 'jpeg':
                imagejpeg($thumb_create,$thumbnail,100);
                break;
            case 'png':
                imagepng($thumb_create,$thumbnail,100);
                break;
            case 'gif':
                imagegif($thumb_create,$thumbnail,100);
                break;
            default:
                imagejpeg($thumb_create,$thumbnail,100);
        }
        return true;
    }

}