<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Location, App\Models\Event, App\Models\News;
use App\Models\Studio, App\Models\Equipment, App\Models\User; 
use App\Models\Schedule, App\Models\Booking, App\Models\BookingDetail;
use App\Models\LandingPage, App\Models\Notification;
use Carbon\Carbon;
use Validator, Session, DB;

class BookingController extends Controller
{
    public function index(Request $request)
    {
        $booking_form = [];
        //$booking_form['type'] = 'flow';
        $booking_form['location'] = $request->txt_location;
        $booking_form['start_date'] = $request->txt_start_date;
        //$booking_form['start_time'] = $request->txt_start_time;
        $booking_form['end_date'] = $request->txt_end_date;
        //$booking_form['end_time'] = $request->txt_end_time;
        $start_time_arr = explode(':',$request->txt_start_time);
        $end_time_arr = explode(':',$request->txt_end_time);
        $booking_form['start_time'] = $start_time_arr[0].':'.$start_time_arr[1].':00';
        $booking_form['end_time']   = $end_time_arr[0].':'.$end_time_arr[1].':00';
        session()->put('booking-form',$booking_form);

        $redirect = '/choose-your-preference/studio';
        
        if(isset($redirect)){
            return response()->json([
                'status' => true,
                'redirect' => $redirect,
            ], 200);
        }else{
            return response()->json([
                'status' => false,
                'redirect' => 'Invalid form data received.',
            ], 422);
        }
    }

    public function choose_your_preference($type){
        if(session()->has('booking-form')){
            $dates = [];
            $booking_form = session()->get('booking-form');
            $from = Carbon::parse($booking_form['start_date']);
            $to = Carbon::parse($booking_form['end_date']);
            for($d = $from; $d->lte($to); $d->addDay()) {
                $dates[] = $d->format('Y-m-d');
            }
        }else{
            $nowTime = Carbon::now();
            $endTime = Carbon::now()->addHours(2);
            $booking_form = [];
            $booking_form['location']   = '';
            $booking_form['start_date'] = $nowTime->format('Y-m-d');
            $booking_form['start_time'] = $nowTime->format('H:i:00');
            $booking_form['end_date']   = $nowTime->format('Y-m-d');
            $booking_form['end_time']   = $endTime->format('H:i:00');
            session()->put('booking-form',$booking_form);
            $dates[] = $nowTime->format('Y-m-d');
        }
        $locations = Location::pluck('location','id');
        $points = [];
        $first_date = $dates[0];
        $last_date  = $dates[count($dates)-1];
        $total_days = count($dates);
        $start_time = $booking_form['start_time'];
        $end_time   = $booking_form['end_time'];
        //dd($start_time);
        $point_per_usd = session()->get('siteconfig.points_per_usd');
        
        if(session()->has('temp-booking-points')){
            $points = session()->get('temp-booking-points');
        }
        //dd($dates);
        if($type=='studio'){
            if(isset($points['studio'])){
                unset($points['studio']);
            }
            // get studios only with schedules and bookings if available
            $query = Studio::with('landingPage:id,banner_picture,studios')
            ->whereHas('schedules', function($w) use($dates, $booking_form){
                $w->where('location_id',$booking_form['location']);
                $w->whereIn('start_date',$dates);
                $w->where('start_time','<=', $booking_form['start_time']);
                $w->where('end_time','>=', $booking_form['end_time']);
            }, '>=', count($dates))
            ->with(['schedules' => function($w) use($dates){
                $w->whereIn('start_date',$dates);
            }])->with(['bookings' => function($w) use($dates){
                $w->whereIn('start_date',$dates);
            }]);
            $studios = $query->paginate(10);
            //dd($studios);
            if($studios->count() > 0){
                $loop = 0;
                foreach($studios as $studio){
                    $studio_points = 0;
                    $available = true;
                    $booking_days = 0;
                    $booking_hours = 0;
                    foreach($studio->schedules as $sch){
                        //price calculation
                        if($total_days==1){
                            if($sch->start_time==$start_time && $sch->end_time==$end_time){
                                $studio_points = $sch->daily_rate*$point_per_usd;
                                $points[$type][$studio->id]['daily'][] = $studio_points;
                                $booking_days++;
                            }else{
                                $hours = $this->getHours($start_time, $end_time);
                                $booking_hours += $hours;
                                $studio_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $points[$type][$studio->id]['hourly'][] = "{$hours}|{$studio_points}";
                            }
                        }else if($sch->start_date==$first_date){
                            if($sch->start_time==$start_time){
                                $studio_points += $sch->daily_rate*$point_per_usd;
                                $points[$type][$studio->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                                $booking_days++;
                                //dump($studio_points);
                            }else{
                                $hours = $this->getHours($start_time, $sch->end_time);
                                $calc_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $studio_points += $calc_points;
                                $points[$type][$studio->id]['hourly'][] = "{$hours}|{$calc_points}";
                                $booking_hours += $hours;
                                //dump($studio_points);
                            }
                        }else if($sch->start_date==$last_date){
                            if($sch->end_time==$end_time){
                                $studio_points += $sch->daily_rate*$point_per_usd;
                                $points[$type][$studio->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                                $booking_days++;
                                //dump($studio_points);
                            }else{
                                $hours = $this->getHours($sch->start_time, $end_time);
                                $calc_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $studio_points += $calc_points;
                                $points[$type][$studio->id]['hourly'][] = "{$hours}|{$calc_points}";
                                $booking_hours += $hours;
                                //dump($studio_points);
                            }
                        }else{
                            $studio_points += $sch->daily_rate*$point_per_usd;
                            $points[$type][$studio->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                            $booking_days++;
                            //dump($studio_points);
                        }
                        //check availability
                        if($studio->bookings){
                            $sch_start_date = $sch->start_date;
                            $bookings = $studio->bookings;
                            $bookings_of_the_day = $bookings->filter(function($item) use($sch_start_date){
                                return $item->start_date==$sch_start_date;
                            });
                            if($total_days==1){
                                $is_booked = $bookings_of_the_day->filter(function($item) use($start_time, $end_time){
                                    return (($item->start_time <= $start_time && $item->end_time >= $start_time) || ($item->start_time <= $end_time && $item->end_time >= $end_time) || ($start_time <= $item->start_time && $end_time >= $item->end_time));
                                });
                                if($is_booked->count()>0){
                                    $available = false;
                                    break;
                                }
                            }else{
                                if($sch->start_date==$first_date){
                                    $is_booked = $bookings_of_the_day->filter(function($item) use($start_time){
                                        return $item->end_time > $start_time;
                                    });
                                    if($is_booked->count()>0){
                                        $available = false;
                                        break;
                                    }
                                }else if($sch->start_date==$last_date){
                                    $is_booked = $bookings_of_the_day->filter(function($item) use($end_time){
                                        return $item->end_time < $end_time;
                                    });
                                    if($is_booked->count()>0){
                                        $available = false;
                                        break;
                                    }
                                }else if($bookings_of_the_day->count()>0){
                                    $available = false;
                                    break;
                                }
                            }
                        }
                    }
                    $studios[$loop]->available = $available;
                    $studios[$loop]->booking_days = $booking_days;
                    $studios[$loop]->booking_hours = $booking_hours;
                    $studios[$loop]->studio_points = (int)$studio_points;
                    $loop++;
                }
            }
            //dump($points);
            //dump($studios);
            session()->put('temp-booking-points',$points);
            $redirect = url('choose-your-preference/equipment');
            return view("frontend.booking.{$type}")->with(['type'=>$type, 'locations'=>$locations, 'studios'=>$studios, 'redirect'=>$redirect]);
        }else if($type=='equipment'){
            if(isset($points['equipment'])){
                unset($points['equipment']);
            }
            // get equipment only with schedules and bookings if available
            $query = Equipment::with('resourceTypes:id,name')
            ->whereHas('schedules', function($w) use($dates, $booking_form){
                $w->where('location_id',$booking_form['location']);
                $w->whereIn('start_date',$dates);
                $w->where('start_time','<=', $booking_form['start_time']);
                $w->where('end_time','>=', $booking_form['end_time']);
            }, '>=', count($dates))
            ->with(['schedules' => function($w) use($dates){
                $w->whereIn('start_date',$dates);
            }])->with(['bookings' => function($w) use($dates){
                $w->where('start_date',$dates);
            }])->where('studios_id',0);
            $equipments = $query->paginate(10);
            //dump($equipments);
            if($equipments->count() > 0){
                $loop = 0;
                foreach($equipments as $equipment){
                    $equipment_points = 0;
                    $available = true;
                    $booking_days = 0;
                    $booking_hours = 0;
                    foreach($equipment->schedules as $sch){
                        //price calculation
                        if($total_days==1){
                            if($sch->start_time==$start_time && $sch->end_time==$end_time){
                                $equipment_points = $sch->daily_rate*$point_per_usd;
                                $points[$type][$equipment->id]['daily'][] = $equipment_points;
                                $booking_days++;
                            }else{
                                $hours = $this->getHours($start_time, $end_time);
                                $booking_hours += $hours;
                                $equipment_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $points[$type][$equipment->id]['hourly'][] = "{$hours}|{$equipment_points}";
                            }
                        }else if($sch->start_date==$first_date){
                            if($sch->start_time==$start_time){
                                $equipment_points += $sch->daily_rate*$point_per_usd;
                                $points[$type][$equipment->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                                $booking_days++;
                                //dump($studio_points);
                            }else{
                                $hours = $this->getHours($start_time, $sch->end_time);
                                $calc_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $equipment_points += $calc_points;
                                $points[$type][$equipment->id]['hourly'][] = "{$hours}|{$calc_points}";
                                $booking_hours += $hours;
                                //dump($studio_points);
                            }
                        }else if($sch->start_date==$last_date){
                            if($sch->end_time==$end_time){
                                $equipment_points += $sch->daily_rate*$point_per_usd;
                                $points[$type][$equipment->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                                $booking_days++;
                                //dump($studio_points);
                            }else{
                                $hours = $this->getHours($sch->start_time, $end_time);
                                $calc_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $equipment_points += $calc_points;
                                $points[$type][$equipment->id]['hourly'][] = "{$hours}|{$calc_points}";
                                $booking_hours += $hours;
                                //dump($studio_points);
                            }
                        }else{
                            $equipment_points += $sch->daily_rate*$point_per_usd;
                            $points[$type][$equipment->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                            $booking_days++;
                            //dump($studio_points);
                        }
                        //check availability
                        if($equipment->bookings){
                            $sch_start_date = $sch->start_date;
                            $bookings = $equipment->bookings;
                            $bookings_of_the_day = $bookings->filter(function($item) use($sch_start_date){
                                return $item->start_date==$sch_start_date;
                            });
                            if($total_days==1){
                                $is_booked = $bookings_of_the_day->filter(function($item) use($start_time, $end_time){
                                    return (($item->start_time <= $start_time && $item->end_time >= $start_time) || ($item->start_time <= $end_time && $item->end_time >= $end_time) || ($start_time <= $item->start_time && $end_time >= $item->end_time));
                                });
                                if($is_booked->count()>0){
                                    $available = false;
                                    break;
                                }
                            }else{
                                if($sch->start_date==$first_date){
                                    $is_booked = $bookings_of_the_day->filter(function($item) use($start_time){
                                        return $item->end_time > $start_time;
                                    });
                                    if($is_booked->count()>0){
                                        $available = false;
                                        break;
                                    }
                                }else if($sch->start_date==$last_date){
                                    $is_booked = $bookings_of_the_day->filter(function($item) use($end_time){
                                        return $item->end_time < $end_time;
                                    });
                                    if($is_booked->count()>0){
                                        $available = false;
                                        break;
                                    }
                                }else if($bookings_of_the_day->count()>0){
                                    $available = false;
                                    break;
                                }
                            }
                        }
                    }
                    $equipments[$loop]->available = $available;
                    $equipments[$loop]->booking_days = $booking_days;
                    $equipments[$loop]->booking_hours = $booking_hours;
                    $equipments[$loop]->equipment_points = (int)$equipment_points;
                    $loop++;
                }
            }
            // dump($points);
            // dump($equipments);
            session()->put('temp-booking-points',$points);
            $redirect = url('choose-your-preference/resource');
            return view("frontend.booking.{$type}")->with(['type'=>$type, 'locations'=>$locations, 'equipments'=>$equipments, 'redirect'=>$redirect]);
        }else if($type=='resource'){
            if(isset($points['resource'])){
                unset($points['resource']);
            }
            // get resource only with schedules and bookings if available
            $query = User::with('resourceName')
            ->whereHas('schedules', function($w) use($dates, $booking_form){
                $w->where('location_id',$booking_form['location']);
                $w->whereIn('start_date',$dates);
                $w->where('start_time','<=', $booking_form['start_time']);
                $w->where('end_time','>=', $booking_form['end_time']);
            }, '>=', count($dates))
            ->with(['schedules' => function($w) use($dates){
                $w->whereIn('start_date',$dates);
            }])->with(['bookings' => function($w) use($dates){
                $w->where('start_date',$dates);
            }]);
            $resources = $query->paginate(10);
            //dump($resources);
            if($resources->count() > 0){
                $loop = 0;
                foreach($resources as $resource){
                    $resource_points = 0;
                    $available = true;
                    $booking_days = 0;
                    $booking_hours = 0;
                    foreach($resource->schedules as $sch){
                        //price calculation
                        if($total_days==1){
                            if($sch->start_time==$start_time && $sch->end_time==$end_time){
                                $resource_points = $sch->daily_rate*$point_per_usd;
                                $points[$type][$resource->id]['daily'][] = $resource_points;
                                $booking_days++;
                            }else{
                                $hours = $this->getHours($start_time, $end_time);
                                $booking_hours += $hours;
                                $resource_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                //dd($resource_points);
                                $points[$type][$resource->id]['hourly'][] = "{$hours}|{$resource_points}";
                            }
                        }else if($sch->start_date==$first_date){
                            if($sch->start_time==$start_time){
                                $resource_points += $sch->daily_rate*$point_per_usd;
                                $points[$type][$resource->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                                $booking_days++;
                                //dump($studio_points);
                            }else{
                                $hours = $this->getHours($start_time, $sch->end_time);
                                $calc_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $resource_points += $calc_points;
                                $points[$type][$resource->id]['hourly'][] = "{$hours}|{$calc_points}";
                                $booking_hours += $hours;
                                //dump($studio_points);
                            }
                        }else if($sch->start_date==$last_date){
                            if($sch->end_time==$end_time){
                                $resource_points += $sch->daily_rate*$point_per_usd;
                                $points[$type][$resource->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                                $booking_days++;
                                //dump($studio_points);
                            }else{
                                $hours = $this->getHours($sch->start_time, $end_time);
                                $calc_points = ($hours*$sch->hourly_rate)*$point_per_usd;
                                $resource_points += $calc_points;
                                $points[$type][$resource->id]['hourly'][] = "{$hours}|{$calc_points}";
                                $booking_hours += $hours;
                                //dump($studio_points);
                            }
                        }else{
                            $resource_points += $sch->daily_rate*$point_per_usd;
                            $points[$type][$resource->id]['daily'][] = $sch->daily_rate*$point_per_usd;
                            $booking_days++;
                            //dump($studio_points);
                        }
                        //check availability
                        if($resource->bookings){
                            $sch_start_date = $sch->start_date;
                            $bookings = $resource->bookings;
                            $bookings_of_the_day = $bookings->filter(function($item) use($sch_start_date){
                                return $item->start_date==$sch_start_date;
                            });
                            if($total_days==1){
                                $is_booked = $bookings_of_the_day->filter(function($item) use($start_time, $end_time){
                                    return (($item->start_time <= $start_time && $item->end_time >= $start_time) || ($item->start_time <= $end_time && $item->end_time >= $end_time) || ($start_time <= $item->start_time && $end_time >= $item->end_time));
                                });
                                if($is_booked->count()>0){
                                    $available = false;
                                    break;
                                }
                            }else{
                                if($sch->start_date==$first_date){
                                    $is_booked = $bookings_of_the_day->filter(function($item) use($start_time){
                                        return $item->end_time > $start_time;
                                    });
                                    if($is_booked->count()>0){
                                        $available = false;
                                        break;
                                    }
                                }else if($sch->start_date==$last_date){
                                    $is_booked = $bookings_of_the_day->filter(function($item) use($end_time){
                                        return $item->end_time < $end_time;
                                    });
                                    if($is_booked->count()>0){
                                        $available = false;
                                        break;
                                    }
                                }else if($bookings_of_the_day->count()>0){
                                    $available = false;
                                    break;
                                }
                            }
                        }
                    }
                    $resources[$loop]->available = $available;
                    $resources[$loop]->booking_days = $booking_days;
                    $resources[$loop]->booking_hours = $booking_hours;
                    $resources[$loop]->resource_points = (int)$resource_points;
                    $loop++;
                }
            }
            // dump($points);
            // dump($resources);
            session()->put('temp-booking-points',$points);
            $redirect = url('booking-process');
            return view("frontend.booking.{$type}")->with(['type'=>$type, 'locations'=>$locations, 'resources'=>$resources, 'redirect'=>$redirect]);
        }
    }

    public function make_selection(Request $request){
        if($request->type=='studio'){
            session()->put('temp-booking-studio-selection',$request->id);
        }else if($request->type=='equipment'){
            session()->put('temp-booking-equipment-selection',$request->id);
        }else if($request->type=='resource'){
            session()->put('temp-booking-resource-selection',$request->id);
        }

        $content = view("frontend.booking.price-box")->render();
        return response()->json([
            'status' => true,
            'content' => $content,
        ], 200);       
    }

    public function check_availability(Request $request){
        $validator = Validator::make($request->all(),[ 
            'selection' => 'required',
            'selection_type' => 'required',
        ],[
            'selection.required' => 'Selection is required.',
            'selection_type.required' => 'Selection type is required.',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            $id = $request->selection;
            $type = $request->selection_type;
            $booking_form = session()->get('booking-form');
            
            $start_time = $booking_form['start_time'].':00';
            $end_time   = $booking_form['end_time'].':00';
            
            if($request->year!="" && $request->month!=""){
                $start_date = $request->year.'-'.$request->month.'-01';
                $end_date = date($request->year.'-'.$request->month.'-t');
            }else{
                $nowTime = Carbon::now();
                $start_date = $nowTime->format('Y-m-d');
                $newTime = Carbon::now()->addMonths(6);
                $end_date = $newTime->format('Y-m-d');
            }
            //dump($start_date);dd($end_date);

            $available_dates = [];
            if($type=='studio'){
                // get studios only with schedules and bookings if available
                $query = Studio::with(['schedules' => function($w) use($start_date, $end_date, $start_time, $end_time, $booking_form){
                    $w->where('location_id', $booking_form['location']);
                    $w->where('start_date','>=',$start_date)->where('end_date','<=',$end_date);
                    $w->where('start_time','<=', $start_time)->where('end_time','>=', $end_time);
                }])->with(['bookings' => function($w) use($start_date, $end_date, $start_time, $end_time){
                    $w->where('start_date','>=',$start_date)->where('end_date','<=',$end_date);
                }]);
                $studio = $query->where('id',$id)->first();
                //dd($studio);
                foreach($studio->schedules as $sch){
                    $available = true;
                    $sch_start_date = $sch->start_date;
                    //check availability
                    if($studio->bookings){
                        $bookings = $studio->bookings;
                        $bookings_of_the_day = $bookings->filter(function($item) use($sch_start_date){
                            return $item->start_date==$sch_start_date;
                        });
                        
                        $is_booked = $bookings_of_the_day->filter(function($item) use($start_time, $end_time){
                            return (($item->start_time <= $start_time && $item->end_time >= $start_time) || ($item->start_time <= $end_time && $item->end_time >= $end_time) || ($start_time <= $item->start_time && $end_time >= $item->end_time));
                        });
                        if($is_booked->count()>0){
                            $available = false;
                            break;
                        }
                    }
                    
                    if($available){
                        $available_dates[] = $sch_start_date;
                    } 
                }
            }else if($type=='equipment'){
                // get studios only with schedules and bookings if available
                $query = Equipment::with(['schedules' => function($w) use($start_date, $end_date, $start_time, $end_time, $booking_form){
                    $w->where('location_id',$booking_form['location']);
                    $w->where('start_date','>=',$start_date)->where('end_date','<=',$end_date);
                    $w->where('start_time','<=', $start_time)->where('end_time','>=', $end_time);
                }])->with(['bookings' => function($w) use($start_date, $end_date, $start_time, $end_time){
                    $w->where('start_date','>=',$start_date)->where('end_date','<=',$end_date);
                }]);
                $equipment = $query->where('id',$id)->first();
                //dd($equipment);
                foreach($equipment->schedules as $sch){
                    $available = true;
                    $sch_start_date = $sch->start_date;
                    //check availability
                    if($equipment->bookings){
                        $bookings = $equipment->bookings;
                        $bookings_of_the_day = $bookings->filter(function($item) use($sch_start_date){
                            return $item->start_date==$sch_start_date;
                        });
                        
                        $is_booked = $bookings_of_the_day->filter(function($item) use($start_time, $end_time){
                            return (($item->start_time <= $start_time && $item->end_time >= $start_time) || ($item->start_time <= $end_time && $item->end_time >= $end_time) || ($start_time <= $item->start_time && $end_time >= $item->end_time));
                        });
                        if($is_booked->count()>0){
                            $available = false;
                            break;
                        }
                    }
                    
                    if($available){
                        $available_dates[] = $sch_start_date;
                    } 
                }
            }else if($type=='resource'){
                // get studios only with schedules and bookings if available
                $query = User::with(['schedules' => function($w) use($start_date, $end_date, $start_time, $end_time, $booking_form){
                    $w->where('location_id',$booking_form['location']);
                    $w->where('start_date','>=',$start_date)->where('end_date','<=',$end_date);
                    $w->where('start_time','<=', $start_time)->where('end_time','>=', $end_time);
                }])->with(['bookings' => function($w) use($start_date, $end_date, $start_time, $end_time){
                    $w->where('start_date','>=',$start_date)->where('end_date','<=',$end_date);
                }]);
                $resource = $query->where('id',$id)->first();
                //dd($resource);
                foreach($resource->schedules as $sch){
                    $available = true;
                    $sch_start_date = $sch->start_date;
                    //check availability
                    if($resource->bookings){
                        $bookings = $resource->bookings;
                        $bookings_of_the_day = $bookings->filter(function($item) use($sch_start_date){
                            return $item->start_date==$sch_start_date;
                        });
                        
                        $is_booked = $bookings_of_the_day->filter(function($item) use($start_time, $end_time){
                            return (($item->start_time <= $start_time && $item->end_time >= $start_time) || ($item->start_time <= $end_time && $item->end_time >= $end_time) || ($start_time <= $item->start_time && $end_time >= $item->end_time));
                        });
                        if($is_booked->count()>0){
                            $available = false;
                            break;
                        }
                    }
                    
                    if($available){
                        $available_dates[] = $sch_start_date;
                    } 
                }
            }

            return response()->json([
                'status' => true,
                'available_dates' => $available_dates,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function booking_process(Request $request){
        try{
            $total_points = 0;
            $booking_id = time();
            $studio_data = [];
            $resource_data = [];
            $equipment_data = [];
            $booking_form = session()->get('booking-form');
            // get selected studio points
            if(isset(session()->get('temp-booking-points')['studio'][session()->get('temp-booking-studio-selection')])){
                $studio_points = 0;
                $studio = session()->get('temp-booking-points')['studio'][session()->get('temp-booking-studio-selection')];
                if(isset($studio['daily'])){
                    foreach($studio['daily'] as $daily){
                        $studio_points += $daily;
                    }
                }
                if(isset($studio['hourly'])){
                    foreach($studio['hourly'] as $hr){
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        $studio_points += $hourly_data[1];
                    }
                }
                $total_points += $studio_points;    
                $studio_data = [
                    'booking_id'    => $booking_id,
                    'location_id'   => $booking_form['location'],
                    'type'          => 'studio',
                    'studio_id'     => session()->get('temp-booking-studio-selection'),
                    'start_date'    => $booking_form['start_date'],
                    'end_date'      => $booking_form['end_date'],
                    'start_time'    => $booking_form['start_time'],
                    'end_time'      => $booking_form['end_time'],
                    'points'        => $studio_points,
                    'data'          => json_encode($studio),
                    'status'        => 0,
                    'created_by'    => auth()->user()->id,
                    'created_at'    => date('Y-m-d H:i:s')
                ];
            }
            // get selected equipment points
            if(isset(session()->get('temp-booking-points')['equipment'][session()->get('temp-booking-equipment-selection')])){
                $equipment_points = 0;
                $equipment = session()->get('temp-booking-points')['equipment'][session()->get('temp-booking-equipment-selection')];
                if(isset($equipment['daily'])){
                    foreach($equipment['daily'] as $daily){
                        $equipment_points += $daily;
                    }
                }
                if(isset($equipment['hourly'])){
                    foreach($equipment['hourly'] as $hr){
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        $equipment_points += $hourly_data[1];
                    }
                }
                $total_points += $equipment_points;
                $equipment_data = [
                    'booking_id'    => $booking_id,
                    'location_id'   => $booking_form['location'],
                    'type'          => 'rental',
                    'equipment_id'  => session()->get('temp-booking-equipment-selection'),
                    'start_date'    => $booking_form['start_date'],
                    'end_date'      => $booking_form['end_date'],
                    'start_time'    => $booking_form['start_time'],
                    'end_time'      => $booking_form['end_time'],
                    'points'        => $equipment_points,
                    'data'          => json_encode($equipment),
                    'status'        => 0,
                    'created_by'    => auth()->user()->id,
                    'created_at'    => date('Y-m-d H:i:s')
                ];
            }
            // get selected resources points
            if(isset(session()->get('temp-booking-points')['resource'][session()->get('temp-booking-resource-selection')])){
                $resource_points = 0;
                $resource = session()->get('temp-booking-points')['resource'][session()->get('temp-booking-resource-selection')];
                if(isset($resource['daily'])){
                    foreach($resource['daily'] as $daily){
                        $resource_points += $daily;
                    }
                }
                if(isset($resource['hourly'])){
                    foreach($resource['hourly'] as $hr){
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        $resource_points += $hourly_data[1];
                    }
                }
                $total_points += $resource_points;
                $resource_data = [
                    'booking_id'    => $booking_id,
                    'location_id'   => $booking_form['location'],
                    'type'          => 'resource',
                    'resource_id'   => session()->get('temp-booking-resource-selection'),
                    'start_date'    => $booking_form['start_date'],
                    'end_date'      => $booking_form['end_date'],
                    'start_time'    => $booking_form['start_time'],
                    'end_time'      => $booking_form['end_time'],
                    'points'        => $resource_points,
                    'data'          => json_encode($resource),
                    'status'        => 0,
                    'created_by'    => auth()->user()->id,
                    'created_at'    => date('Y-m-d H:i:s')
                ];
            }
            //dd($total_points);
            if($total_points<=0){
                session()->flash('error','Please make selection to proceed further.');
            }else if(session()->get('point_balance') >= $total_points){
                DB::transaction(function () use($booking_id, $total_points, $booking_form, $studio_data, $resource_data, $equipment_data){
                    // save data in master table
                    $bmaster = new Booking;
                    $bmaster->uuid          = auth()->user()->uuid;
                    $bmaster->booking_id    = $booking_id;
                    $bmaster->location_id   = $booking_form['location'];
                    $bmaster->start_date    = $booking_form['start_date'];
                    $bmaster->end_date      = $booking_form['end_date'];
                    $bmaster->start_time    = $booking_form['start_time'];
                    $bmaster->end_time      = $booking_form['end_time'];
                    $bmaster->status        = 0;
                    $bmaster->total_points  = (int)$total_points;
                    $bmaster->created_by    = auth()->user()->id;
                    $bmaster->save();
                    // save data in child table
                    if(count($studio_data) > 0){
                        BookingDetail::insert($studio_data);
                    }
                    if(count($equipment_data) > 0){
                        BookingDetail::insert($equipment_data);
                    }
                    if(count($resource_data) > 0){
                        BookingDetail::insert($resource_data);
                    }
                });

                // notifications
                Notification::insert(['user'=>auth()->user()->uuid, 'type'=>'booking', 'action'=>'confirmed', 'content'=>'Your booking has been confirmed.','reference_id'=>$booking_id]);
                // emails
                if(auth()->user()->email){
                    $edata = array();
                    $edata['email'] = auth()->user()->email;
                    $edata['name']  = auth()->user()->fname.' '.auth()->user()->lname;
                    $edata['booking_id']    = $booking_id;
                    $edata['heading'] = 'Booking Confirmed';
                    $edata['content'] = 'Your booking <b>'.$booking_form['start_date'].' '.$booking_form['start_time'].'</b> to <b>'.$booking_form['end_date'].' '.$booking_form['end_time'].'</b> has been confirmed.';
                    \Mail::send('emails.booking', $edata, function($message) use($edata) {
                        $message->to($edata['email']);
                        $message->subject('Your booking is confirmed!');
                    });
                }
                // clear booking session
                session()->forget('temp-booking-points');
                session()->forget('temp-booking-studio-selection');
                session()->forget('temp-booking-equipment-selection');
                session()->forget('temp-booking-resource-selection');
                
                return redirect('booking-confirmed/'.$booking_id);
            }else{
                session()->flash('error','Your booking is not confirmed! Please buy more points to proceed further.');
            }
        } catch (\PDOException $pde) {
            session()->flash('error',$pde->getMessage());
        } catch (\Exception $e) {
            session()->flash('error',$e->getMessage());
        }
        return redirect()->back();
    }

    public function booking_confirmed($bookingId) {
        $data = [];
        $data['bookingId'] = $bookingId;
        $bookings = BookingDetail::select('studio_id','equipment_id','resource_id','type','points','data','status')
        ->where('booking_id',$bookingId)->where('created_by',auth()->user()->id)->get();
        
        $booking = Booking::Join('landing_pages as lp', function($join){
            $join->on('lp.location_id','booking_master.location_id');
            $join->where('lp.type','location');
        })->join('location','location.id','lp.location_id')
        ->select('status','start_date','end_date','start_time','end_time','total_points','location','banner_picture')
        ->where('booking_id',$bookingId)->first();
        $data['booking'] = $booking;
        //dd($bookings);
        if($bookings->count() >0){
            $data['bookings'] = $bookings;
            foreach($bookings as $booking){
                if($booking->type=='studio'){
                    $studio = Studio::with('landingPage:id,banner_picture,studios,description')->where('studios.id',$booking->studio_id)->select('studios.id','studios.name')->first();
                    $data['studio'] = $studio;
                }
                if($booking->type=='rental'){
                    $equipment = Equipment::where('id',$booking->equipment_id)->select('name','photo','description')->first();
                    $data['equipment'] = $equipment;
                }
                if($booking->type=='resource'){
                    $resource = User::with('resourceName')->where('users.id',$booking->resource_id)->select('users.id','fname','lname','profile_pic','description')->first();
                    $data['resource'] = $resource;
                }
            }
            //dump($data);
            return view('frontend.booking.booking-confirmed')->with($data);
        }else{
            abort(403);  
        }
    }

    public function booking_cancelled(Request $request){
        if($request->has('booking') && $request->booking!=""){
            $book = Booking::where('booking_id',$request->booking)->first();
            Booking::where('booking_id',$request->booking)->update(['status'=>2]);
            BookingDetail::where('booking_id',$request->booking)->update(['status'=>2]);

            // notifications
            Notification::insert(['user'=>auth()->user()->uuid, 'type'=>'booking', 'action'=>'cancelled', 'content'=>'Your booking has been cancelled.','reference_id'=>$book->booking_id]);
            // emails
            if(auth()->user()->email){
                $edata = array();
                $edata['email'] = auth()->user()->email;
                $edata['name']  = auth()->user()->fname.' '.auth()->user()->lname;
                $edata['booking_id']    = $book->booking_id;
                $edata['heading'] = 'Booking Cancelled';
                $edata['content'] = 'Your booking <b>'.$book->start_date.' '.$book->start_time.'</b> to <b>'.$book->end_date.' '.$book->end_time.'</b> has been cancelled.';
                \Mail::send('emails.booking', $edata, function($message) use($edata) {
                    $message->to($edata['email']);
                    $message->subject('Booking cancelled!');
                });
            }

            return response()->json([
                'status' => true,
                'message' => 'Booking cancelled.',
            ], 200);
        }
        return response()->json([
            'status' => false,
            'error' => 'Invalid form data received.',
        ], 422);
    }

    public function booking_list (Request $request){
        // bookings
        $bookings = Booking::with('loc','locLanding')->leftJoin('booking_details as studio', function($join){
            $join->on('booking_master.booking_id','studio.booking_id')->whereNotNull('studio.studio_id');
        })->leftJoin('booking_details as equip', function($join){
            $join->on('booking_master.booking_id','equip.booking_id')->whereNotNull('equip.equipment_id');
        })->leftJoin('booking_details as resource', function($join){
            $join->on('booking_master.booking_id','resource.booking_id')->whereNotNull('resource.resource_id');
        })->select('booking_master.*','studio.studio_id as studioNum','equip.equipment_id as equipNum','resource.resource_id as resourceNum')->where('uuid',auth()->user()->uuid)->paginate(10);

        return view("frontend.booking.booking-list")->with(['bookings'=>$bookings]);

    }

    public function getHours($time1, $time2){
        $timestamp1 = strtotime(date('Y-m-d').' '.$time1);
        $timestamp2 = strtotime(date('Y-m-d').' '.$time2);
        $hours = (int)(round(($timestamp2-$timestamp1)/3600));
        return $hours;
    }
}
