<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Location;
use App\Models\LandingPage;
use App\Models\Gallery;
use App\Models\Role;
use App\Models\Equipment;
use App\Models\ResourceTypes;
use App\Models\StudioTypes;
use App\Models\News;
use App\Models\Event;
use App\Models\Studio;
use App\Helpers;
use Carbon\Carbon, Validator, Session;

class ContentEditingController extends Controller
{
    private $paginate = 20;

    public function location_landing_page(Request $request, $locationId=null)
    {
        $studios = StudioTypes::where('status',1)->get();
        $resources = ResourceTypes::where('status',1)->get();
        $location = Location::Select('id','location')->where('id',$locationId)->first();
        $page = LandingPage::where('type','location')->where('location_id',$locationId)->first();
        return view("content-editing.location-landing-page")->with(['location'=>$location, 'page'=>$page, 'resources'=>$resources, 'studios'=>$studios]);
    }

    public function location_landing_page_save(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'lpid' => 'required',
            'phone' => 'required|min:12',
            'email' => 'required|email',
            'address' => 'required',
            'opening_hours' => 'required',
            //'studios' => 'required',
            //'our_crew' => 'required',
            //'description' => 'required',
            'how_to_get_there' => 'required',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        if(!isset($request->type) && !isset($request->studios)){
            return response()->json([
                'status' => false,
                'error'=> 'Studios types are required field.'
            ], 422);
        }

        if(!isset($request->type) && !isset($request->our_crew)){
            return response()->json([
                'status' => false,
                'error'=> 'Crews are required field.'
            ], 422);
        }

        try{
            $llp = LandingPage::find($request->lpid);
            if(!isset($request->type)){
                $llp->studios = implode(',',$request->studios);
                $llp->our_crew = implode(',',$request->our_crew);
                $llp->description = $request->description;
            }
            $llp->address = $request->address;
            $llp->opening_hours = $request->opening_hours;
            $llp->phone = $request->phone;
            $llp->email = $request->email;
            $llp->how_to_get_there = $request->how_to_get_there;
            $llp->save();
            return response()->json([
            'status' => true,
            'message' => 'Location landing page setup successfully.',
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function studio_landing_page(Request $request, $locationId, $studioId=null)
    {
        $page = null;
        if($studioId){
            $page = LandingPage::where('id',$studioId)->where('type','studio')->where('location_id',$locationId)
            ->first();
        }

        $local_studios = Studio::where('location_id',$locationId)->pluck('name','id');
        
        $location = Location::Select('id','location')->where('id',$locationId)->first();

        $loc_page = LandingPage::where('type','location')->where('location_id',$locationId)->first();
        $resources = ResourceTypes::where('status',1)->whereIn('id',explode(',',$loc_page->our_crew))->get();
        
        $equipments = Equipment::all();
        
        return view("content-editing.studio-landing-page")->with(['page'=>$page, 'location'=>$location, 'resources'=>$resources, 'equipments'=>$equipments, 'local_studios'=>$local_studios]);
    }

    public function studio_landing_page_save(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'lpid' => 'required',
            'location_id' => 'required',
            'studio' => 'required',
            'our_crew' => 'required',
            'equipment' => 'required',
            'description' => 'required',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
               $llp = LandingPage::find($request->lpid);
               $llp->location_id = $request->location_id;
               $llp->studios = $request->studio;
               $llp->our_crew = implode(',',$request->our_crew);
               $llp->equipment_ids = implode(',',$request->equipment);
               $llp->description = $request->description;
               $llp->save();
               return response()->json([
                'status' => true,
                'message' => 'Studio landing page setup successfully.',
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function fileupload(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'type'  => 'required',
            'image_type' => 'required',
            'location_id' => 'required'
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }
        
        $image_type = $request->image_type;
        if($request->type=='location' || $request->type=='studio'){
            if(!$request->lpid){
                $lp = new LandingPage;
                $lp->location_id = $request->location_id;
                $lp->type = $request->type;
                $lp->save();
                $lpid = $lp->id;
            }else{
                $lpid = $request->lpid;
            }
        }
        
        if($request->type=='location'){
            $lp = LandingPage::find($lpid);
            $storage_path = storage_path('app/public/location/');
            $image = $request->file('file');
            $imageName = time().'.'.$image->extension();
            $image->move($storage_path, $imageName);
            if($image_type=='banner'){
                $lp->banner_picture = $imageName;
                $lp->save();
            }else{
                $gallery = new Gallery;
                $gallery->type = $request->type;
                $gallery->image_type = $image_type;
                $gallery->ref_id = $lp->id;
                $gallery->image_url = $imageName;
                if($image_type=='benefit'){
                    $gallery->description = $request->description;
                }
                $gallery->save();
            }
            return response()->json(['status'=>true,'lpid'=>$lpid,'imgurl'=>'storage/location/'.$imageName]);
        }else if($request->type=='studio'){
            $lp = LandingPage::find($lpid);
            $storage_path = storage_path('app/public/location/');
            $image = $request->file('file');
            $imageName = time().'.'.$image->extension();
            $image->move($storage_path, $imageName);
            if($image_type=='banner'){
                $lp->banner_picture = $imageName;
                $lp->save();
                // create thumbnail
                Helpers::create_thumbnail($storage_path, $imageName, 350, 350);
            }else{
                $gallery = new Gallery;
                $gallery->type = $request->type;
                $gallery->image_type = $image_type;
                $gallery->ref_id = $lp->id;
                $gallery->image_url = $imageName;
                $gallery->save();
            }
            return response()->json(['status'=>true,'lpid'=>$lpid,'imgurl'=>'storage/location/'.$imageName]);
        }else if($request->type=='news'){
            if($request->has('newsid') && $request->newsid!=""){
                $news = News::find($request->newsid);
                $news->updated_by = auth()->user()->id;
            }else{
                $news = new News;
                $news->created_by = auth()->user()->id;
            }
            $storage_path = storage_path('app/public/location/news/');
            $image = $request->file('file');
            $imageName = time().'.'.$image->extension();
            $image->move($storage_path, $imageName);
            if($image_type=='banner'){
                $news->banner = $imageName;
                // create thumbnail
                Helpers::create_thumbnail($storage_path, $imageName, 627, 418);
            }else if($image_type=='conclusion'){
                $news->conclusion_picture = $imageName;
            }
            $news->location_id = $request->location_id;
            $news->save();
            $newsId = $news->id;
            return response()->json(['status'=>true,'newsid'=>$newsId,'imgurl'=>'storage/location/news/'.$imageName]);
        }else if($request->type=='events'){
            if($request->has('eventsid') && $request->eventsid!=""){
                $event = Event::find($request->eventsid);
                $event->updated_by = auth()->user()->id;
            }else{
                $event = new Event;
                $event->user_uuid = auth()->user()->uuid;
                $event->created_by = auth()->user()->id;
            }
            $storage_path = storage_path('app/public/location/events/');
            $image = $request->file('file');
            $imageName = time().'.'.$image->extension();
            $image->move($storage_path, $imageName);
            if($image_type=='thumbnail'){
                $event->thumbnail = $imageName;
            }
            $event->location_id = $request->location_id;
            $event->save();
            $eventId = $event->event_id;
            // create thumbnail
            Helpers::create_thumbnail($storage_path, $imageName, 627, 418);
            return response()->json(['status'=>true,'eventsid'=>$eventId,'imgurl'=>'storage/location/events/'.$imageName]);
        }
        return response()->json(['status'=>false,'error'=>'Invalid form data received.']);
    }

    public function gallery_images(Request $request)
    {
        $gallery = Gallery::where('type',$request->location_type)->where('image_type',$request->image_type)
        ->where('ref_id',$request->refid)->get();
        $content = view('content-editing.gallery-images')->with(['gallery'=>$gallery,'type'=>$request->location_type])->render(); 
        return response()->json(['status'=>true,'content'=>$content]);
    }

    public function gallery_image_delete(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'id' => 'required',
            'lpid' => 'required',
            'type'  => 'required',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            Gallery::where('id',$request->id)->where('type',$request->type)
            ->where('ref_id',$request->lpid)->delete();
            
            return response()->json([
                'status' => true,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function local_studios(Request $request, $locationId)
    {
        $query = LandingPage::Join('studios','studios.id','landing_pages.studios')
        ->Join('studio_types as st','studios.studio_type','st.id')->select('landing_pages.id','studios.name','st.name as type','landing_pages.location_id')->where('landing_pages.type','studio')->where('landing_pages.location_id',$locationId);
        if($request->has('name') && $request->name!=""){
            $query->where('studios.name', 'like', "'.$request->name.'%");
        }
        $studios = $query->OrderBy('landing_pages.created_at', 'desc')->get();
        return view("content-editing.local-studios")->with(['data'=>$studios,'locId'=>$locationId]);
    }

    public function manage_news(Request $request, $locationId)
    {
        $query = News::with('createdBy','updatedBy')->where('location_id',$locationId);
        if($request->has('name') && $request->name!=""){
            $query->where('name', 'like', $request->name.'%');
        }
        $news = $query->OrderBy('created_at', 'desc')->paginate($this->paginate);
        
        return view("content-editing.manage-news")->with(['data'=>$news,'locId'=>$locationId]);
    }

    public function upsert_news(Request $request, $locationId, $newsId=null)
    {
        $news = [];
        if($newsId){
            $news = News::find($newsId);
        }
        return view("content-editing.news")->with(['locationId'=>$locationId,'news'=>$news]);
    }

    public function save_news(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'name' => 'required',
            'tags' => 'required',
            'heading_intro' => 'required',
            'para_intro' => 'required',
            'heading_elaboration' => 'required',
            'para_elaboration' => 'required',
            'heading_conclusion' => 'required',
            'para_conclusion' => 'required',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            if($request->newsid){
                $news = News::find($request->newsid);
                $news->updated_by = auth()->user()->id;
                $msg = 'News updated successfully.';
            }else{
                $news = new News;
                $news->created_by = auth()->user()->id;
                $msg = 'News created successfully.';
            }
            $news->location_id = $request->location_id;
            $news->name = $request->name;
            $news->tags = $request->tags;
            $news->heading_intro    = $request->heading_intro;
            $news->para_intro       = $request->para_intro;
            $news->heading_elaboration  = $request->heading_elaboration;
            $news->para_elaboration     = $request->para_elaboration;
            $news->heading_conclusion   = $request->heading_conclusion;
            $news->para_conclusion      = $request->para_conclusion;
            $news->save();
            if($request->newsid){
                $news_id = $request->newsid;
            }else{
                $news_id = $news->id;
            }
            Session::flash('success',$msg);
            return response()->json([
                'status' => true,
                '_id' => $news_id,
            ], 200); 
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function delete_news(Request $request, $locationId, $id)
    {
        try{
            News::where('id',$id)->where('location_id',$locationId)->delete();
            return redirect()->back()->with('success', 'News deleted successfully.'); 
        }catch(\PDOException $pde ) {
            return redirect()->back()->with('error', $pde->getMessage());
        }catch(\Exception $e){
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function manage_events(Request $request, $locationId)
    {
        $query = Event::with('createdBy','updatedBy')->where('location_id',$locationId);
        if($request->has('name') && $request->name!=""){
            $query->where('event_title', 'like', $request->name.'%');
        }
        $events = $query->OrderBy('created_at', 'desc')->paginate($this->paginate);
        
        return view("content-editing.manage-events")->with(['data'=>$events,'locId'=>$locationId]);
    }

    public function upsert_events(Request $request, $locationId, $eventsId=null)
    {
        $events = [];
        if($eventsId){
            $events = Event::find($eventsId);
        }
        return view("content-editing.events")->with(['locationId'=>$locationId,'events'=>$events]);
    }

    public function save_events(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'location_id' => 'required',
            'event_type' => 'required',
            'public_private' => 'required',
            //'stream_url' => 'required',
            'event_title' => 'required',
            'event_date' => 'required',
            'event_time' => 'required',
            'address' => 'required',
            'ticket_price' => 'required',
            //'ticket_url' => 'required',
            'description' => 'required',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            if($request->eventsid){
                $event = Event::find($request->eventsid);
                $msg = 'Events updated successfully.';
            }else{
                $event = new Event;
                $msg = 'Events created successfully.';
            }
            $event->location_id = $request->location_id;
            $event->user_uuid  = auth()->user()->uuid;
            $event->event_type = $request->event_type;
            $event->public_private = $request->public_private;
            $event->stream_url  = $request->stream_url;
            $event->event_title = $request->event_title;
            $event->event_date  = $request->event_date;
            $event->event_time  = $request->event_time;
            $event->address     = $request->address;
            $event->ticket_price= $request->ticket_price;
            $event->ticket_url  = $request->ticket_url;
            $event->description = $request->description;
            $event->save();
            if($request->eventsid){
                $event_id = $request->eventsid;
            }else{
                $event_id = $event->event_id;
            }
            Session::flash('success',$msg);
            return response()->json([
                'status' => true,
                '_id' => $event_id,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function delete_events(Request $request, $locationId, $id)
    {
        try{
            Event::where('event_id',$id)->where('location_id',$locationId)->delete();
            return redirect()->back()->with('success', 'Event deleted successfully.'); 
        }catch(\PDOException $pde ) {
            return redirect()->back()->with('error', $pde->getMessage());
        }catch(\Exception $e){
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    
}
