<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers, DB;

class CronJobController extends Controller
{
    public function iptracking(Request $request, $token)
    {
        if($token=='kndygry6gh45dfcaabfdqpd83s09vhdf'){
            $date = date('Y-m-d');
            $data = DB::table('fraud_detection')->select('ip_address','mobile_no', DB::raw('count(*) as count'))->whereDate('otp_sent_at',$date)->groupBy('ip_address','mobile_no')->get();
            $ips = [];
            foreach($data as $dt){
                if($dt->count > 3){
                    $ips[] = $dt->ip_address;
                }
            }

            if(count($ips) >0){
                $edata = array();
                $edata['email'] = env('SUPPORT_EMAIL');
                $edata['ips'] = $ips;
                \Mail::send('emails.iptracking', $edata, function($message) use($edata) {
                    $message->to($edata['email']);
                    $message->subject('Suspicious IPs found!');
                });
            }
            
            die('Job Executed');
        }else{
            abort(404);
        }
    }
    
    public function test_email(Request $request)
    {
        return view("emails.test");
    }
}
