<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\User,App\Models\StudioTypes;
use App\Models\Location;
use App\Models\Language;
use App\Models\Point;
use App\Models\Plan;
use App\Models\Studio;
use App\Models\Schedule;
use App\Models\Booking;
use App\Models\Equipment;
use App\Models\LandingPage;						   
use App\Helpers;
use Carbon\Carbon, Validator;
use Laravel\Cashier\Cashier;
use Session;			
class GlobalController extends Controller
{
    private $paginate = 20;
    public function applications(Request $request)
    {
        if(!in_array(auth()->user()->role,['super-admin', 'admin'])){
            abort(403);
        }
        $query = User::with('user_role')->with('user_location')->where('uuid','!=','06238d85-b98e-4ee2-8944-17cb88989117');
        if($request->has('name') && $request->name!=""){
            $query->whereRaw('concat(fname," ",lname) like "'.$request->name.'%"');
        }
        $data = $query->OrderBy('created_at', 'desc')->paginate($this->paginate);
        if ($request->is('backend/manage-users*')){
            return view("global.manage-users")->with(['data'=>$data]);
        }else{
            return view("global.applications")->with(['data'=>$data]);
        }
    }
	
	public function team(Request $request, $locationId)
{
    if (!in_array(auth()->user()->role, ['super-admin', 'admin'])) {
        abort(403);
    }

    $query = User::with('user_role')->with('user_location')
        ->whereHas('user_location', function ($query) use ($locationId) {
            $query->where('id', $locationId);
        })
        ->where('uuid', '!=', '06238d85-b98e-4ee2-8944-17cb88989117');

    if ($request->has('name') && $request->name != "") {
        $query->whereRaw('concat(fname, " ", lname) like "'.$request->name.'%"');
    }

    $data = $query->orderBy('created_at', 'desc')->paginate($this->paginate);

    return view("team.manage-team")->with(['data' => $data, 'locationId' => $locationId]);
}


    public function user_management(Request $request, $uuid)
    {
        if(!in_array(auth()->user()->role,['super-admin', 'admin'])){
            abort(403);
        }
        $current_balance = 0;
        $guests = config('app.guests');
        $points_action = config('app.points_action');
        $last_month_booking_cost = Point::where('receivedby_uuid',$uuid)->where('action','BOOK_EVENT')->whereBetween('created_at',[Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()])->sum('debit');
        $current_month_booking_cost = Point::where('receivedby_uuid',$uuid)->where('action','BOOK_EVENT')->whereBetween('created_at',[Carbon::now()->startOfMonth(), Carbon::now()->endOfMonth()])->sum('debit');
        $balance_data = Point::select('balance')->where('receivedby_uuid',$uuid)->orderBy('id','desc')->first();
        if($balance_data){
            $current_balance = $balance_data->balance;
        }
        $data = User::with('user_role')->with('user_plan')->where('uuid',$uuid)->first();
        $points = Point::with('sentby','plan')->where('receivedby_uuid',$uuid)->whereIn('action',['MEMBERSHIP_CREDIT', 'POINTS_PURCHASED', 'POINTS_RECEIVED', 'POINTS_SENT', 'BOOK_EVENT'])->get();
        $plan = Plan::where('slug',$data->membership)->first();
        
        $creator_interest = '';
        if($data->creator_interest){
            $studio_arr = [];
            $studios = StudioTypes::where('status',1)->whereIn('id',explode(',',$data->creator_interest))
            ->get();
            foreach($studios as $st){
                $studio_arr[] = $st->name;
            }
            $creator_interest = implode(',',$studio_arr);
        }
        
       return view("global.user-management")->with(['data'=>$data, 'points'=>$points,  'points_action' => $points_action, 'plan' => $plan, 'guests'=>$guests, 'last_month_booking_cost' => $last_month_booking_cost, 'current_month_booking_cost' => $current_month_booking_cost, 'current_balance' => $current_balance, 'creator_interest'=>$creator_interest]);
    }

    public function billing(Request $request)
    {
        if(!in_array(auth()->user()->role,['super-admin','admin'])){
            abort(403);
        }
        $points_action = config('app.points_action');
        $data = Point::with('receivedby','plan')->whereIn('action',['MEMBERSHIP_CREDIT', 'POINTS_PURCHASED'])->paginate($this->paginate);
        
        return view("global.billing")->with(['data'=>$data, 'points_action'=>$points_action]);
    }

    public function locations(Request $request)
    {
        if(!in_array(auth()->user()->role,['super-admin','admin'])){
            abort(403);
        }
        
        $query = Location::orderBy('location','asc');
        if($request->has('name') && $request->name!=""){
            $query->where('location', 'like', $request->name.'%');
        }
        $data = $query->paginate($this->paginate);
        return view("global.locations")->with(['data'=>$data]);
    }

    public function location_detail(Request $request)
    {
        if(!in_array(auth()->user()->role,['super-admin','admin'])){
            abort(403);
        }

        try{
            $data = null;
            if($request->has('lid') && $request->lid!=""){
                $data = Location::find($request->lid); 
            }
            $content = view("global.location-card")->with(['data'=>$data])->render();    
            return response()->json([
                'status' => true,
                'content' => $content,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function save_location(Request $request)
    {
        if(!in_array(auth()->user()->role,['super-admin','admin'])){
            abort(403);
        }
        $locationId = null;
        $fields['type'] = array('required');
        if($request->has("locationid") && $request->locationid != ""){
            $locationId = $request->locationid;
            $fields['location'] = array('required','unique:location,location,'.$locationId.',id');
        }else{
            $fields['location'] = array('required','unique:location,location,null,id');
        }
        $validator = Validator::make($request->all(),$fields);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            if($locationId){
                $data = Location::find($locationId);
                $msg = 'Location updated successfully.';
            }else{
                $data = new Location;
				$data->slug = Helpers::clean_string($request->location);														
                $msg = 'Location created successfully.';
            }
            $data->type = $request->type;
            $data->location = $request->location;
            $data->coming_soon = $request->has('coming_soon') ? 1 : 0;
            $data->save();
			if(!$locationId){
                $locationId = $data->id;
                $llp = new LandingPage;
                $llp->type = 'location';
                $llp->location_id = $locationId;
                $llp->save();
            }
            $locations = Location::with('Studio')->get();
            Session::put('user_locations',$locations);				 
            return response()->json([
                'status' => true,
                'message' => $msg,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function remove_action(Request $request)
    {
        if(!in_array(auth()->user()->role,['super-admin','admin'])){
            abort(403);
        }

        try{
            $isDeleted = false;
            if($request->type=='location' && $request->did!=''){
                $data = User::where('home_city',$request->did)->first();
                if($data){
                    return response()->json([
                        'status' => false,
                        'error' => "Location already used by some users, so you can't delete it.",
                    ], 422);
                }
                Location::where('location',$request->did)->delete();
                $isDeleted = true;
            }else if($request->type=='studio' && $request->did!=''){
                $data = Studio::where('id',$request->did)->first();
                if($data){
                    $data->delete();
                }
                $isDeleted = true;
            }else if($request->type=='rental' && $request->did!=''){
                $data = Equipment::where('id',$request->did)->first();
                if($data){
                    $data->delete();
                }
                $isDeleted = true;
            }
			
            if($isDeleted){
                return response()->json([
                    'status' => true,
                    'message' => 'Record deleted successfully.',
                ], 200);
            }

            return response()->json([
                'status' => false,
                'error' => 'Invalid form data received.',
            ], 422);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }
    
    public function save_profile(Request $request)
    {
        if(!in_array(auth()->user()->role,['super-admin','admin'])){
            abort(403);
        }

        $validator = Validator::make($request->all(),[ 
            'user_uuid' => 'required',
            'fname' => 'required',
            'lname' => 'required',
            'phone_number' => 'required',
            'description' => 'required'
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            $user = User::where('uuid',$request->user_uuid)->first();
            if($user){
                $user->fname = $request->fname;
                $user->lname = $request->lname;
                $user->phone_number = $request->phone_number;
                $user->description = $request->description;
                //$user->points = $request->points;
                $user->save();
                return response()->json([
                    'status' => true,
                    'message' => 'User updated successfully.',
                ], 200);
            }

            return response()->json([
                'status' => false,
                'error' => 'Invalid form data received.',
            ], 422);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function account_setting(Request $request)
    {
        $uuid = auth()->user()->uuid;
        $current_balance = 0;
        $guests = config('app.guests');
        $points_action = config('app.points_action');
        $last_month_booking_cost = Point::where('receivedby_uuid',$uuid)->where('action','BOOK_EVENT')->whereBetween('created_at',[Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()])->sum('debit');
        $current_month_booking_cost = Point::where('receivedby_uuid',$uuid)->where('action','BOOK_EVENT')->whereBetween('created_at',[Carbon::now()->startOfMonth(), Carbon::now()->endOfMonth()])->sum('debit');
        $balance_data = Point::select('balance')->where('receivedby_uuid',$uuid)->orderBy('id','desc')->first();
        //dd($balance_data);
        if($balance_data){
            $current_balance = $balance_data->balance;
        }
        $data = User::with('user_role')->with('user_plan')->where('uuid',$uuid)->first();
        $points = Point::with('sentby','plan')->where('receivedby_uuid',$uuid)->whereIn('action',['MEMBERSHIP_CREDIT', 'POINTS_PURCHASED', 'POINTS_RECEIVED', 'POINTS_SENT', 'BOOK_EVENT'])->get();
        //dd($points);
        $plan = Plan::where('slug',$data->membership)->first();
        
        $next_billing_date = '';
        $mysubscription = auth()->user()->subscriptions()->first();
        
        // if($mysubscription){
        //     $current_period_end_timestamp = auth()->user()->subscription($mysubscription->name)->asStripeSubscription()->current_period_end;
        //     $next_billing_date = date('d M Y',$current_period_end_timestamp);
        // }
        
        return view("user.account-setting")->with(['data'=>$data, 'points'=>$points,  'points_action' => $points_action, 'plan' => $plan, 'guests'=>$guests, 'last_month_booking_cost' => $last_month_booking_cost, 'current_month_booking_cost' => $current_month_booking_cost, 'current_balance' => $current_balance, 'next_billing_date'=>$next_billing_date]);
    }

    public function account_setting_save(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'fname' => 'required',
            'lname' => 'required',
            'description' => 'required'
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            $user = User::where('uuid',auth()->user()->uuid)->first();
            if($user){
                $user->fname = $request->fname;
                $user->lname = $request->lname;
                $user->description = $request->description;
                $user->daily_rate = Helpers::convertCurrencyToUSD($request->daily_rate);
                $user->hourly_rate = Helpers::convertCurrencyToUSD($request->hourly_rate);
                $user->save();
                return response()->json([
                    'status' => true,
                    'message' => 'Profile updated successfully.',
                ], 200);
            }

            return response()->json([
                'status' => false,
                'error' => 'Invalid form data received.',
            ], 422);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function calendar_sch_events(Request $request)
    {
        $events = [];
        $uuid = auth()->user()->uuid;
        $refrence_id = $request->refrence_id;
        $locationId = $request->schedule_location;
        //dd(Helpers::convertCurrencyFromUSD(9.49));
        if($request->type=='resource'){
            $schedules = Schedule::Where('location_id',$locationId)->where('type','resource')->where('refrence_id',$refrence_id)->get();
            foreach($schedules as $schedule){
                $events[] = ['id'=>$schedule->id, 'location_id'=>$schedule->location_id, 'title' => 'Schedule', 'start' => $schedule->start_date.'T'.$schedule->start_time, 'end' => $schedule->start_date.'T'.$schedule->end_time, 'type'=> $schedule->type, 'schedule_type'=> $schedule->schedule_type, 'daily_rate'=> Helpers::convertCurrencyFromUSD($schedule->daily_rate), 'hourly_rate'=> Helpers::convertCurrencyFromUSD($schedule->hourly_rate), 'start_date'=>$schedule->start_date, 'start_time'=>$schedule->start_time, 'end_time'=>$schedule->end_time, 'color'=>'#99CCFF', 'textColor'=> 'black', 'booking'=>false];
            }
            $bookings = Booking::where(['location_id' => $locationId])
            ->whereHas('resources', function ($query) use ($refrence_id) {
                $query->where('resource_id', $refrence_id);
            })->get();
            //dd($bookings);
            foreach($bookings as $booking) {
                $createdByPhone = $booking->booking_by->mobile_number;
                $createdByEmail = $booking->booking_by->email; 
                $createdByUser = $booking->booking_by->fname.' '.$booking->booking_by->lname;
                if($booking->resources){
                    foreach($booking->resources as $resource){
                        $events[] = [
                            'id' => $resource->detid,
                            'booking_id' => $booking->booking_id,
							'booking_detail_id' =>  $resource->detid,
							'booking_status' => $resource->detstatus,
                            'title' => $createdByUser.", ".$resource->name,
                            'start' => $booking->start_date.'T'.$booking->start_time,
                            'end' => $booking->end_date.'T'.$booking->end_time,
                            'start_date' => $booking->start_date,
                            'end_date' => $booking->end_date, 
                            'start_time' => $booking->start_time,
                            'end_time' => $booking->end_time,
                            'type' => 'resource',
                            'studio_type' => '',
                            'resource_name' => $resource->fname.' '.$resource->lname,
                            'resource_type' => $resource->name,
                            'equipments' => '',
                            'client_name' => $createdByUser,
                            'client_phone' => $createdByPhone,
                            'client_email' => $createdByEmail,
                            'total_points' => $booking->total_points,
                            'bgcolor' => "#5FBE82",
                            'color' => "#5FBE82",
                            'textColor' => 'black',
                            'booking'=>true
                        ];
                    }
                }
            }
        }else if($request->type=='studio'){
            $schedules = Schedule::Where('location_id',$locationId)->where('type','studio')->where('refrence_id',$refrence_id)->get();
            foreach($schedules as $schedule){
                $events[] = ['id'=>$schedule->id, 'location_id'=>$locationId, 'title' => 'Schedule', 'start' => $schedule->start_date.'T'.$schedule->start_time, 'end' => $schedule->start_date.'T'.$schedule->end_time, 'type'=> $schedule->type, 'schedule_type'=> $schedule->schedule_type, 'daily_rate'=> Helpers::convertCurrencyFromUSD($schedule->daily_rate), 'hourly_rate'=> Helpers::convertCurrencyFromUSD($schedule->hourly_rate), 'start_date'=>$schedule->start_date, 'start_time'=>$schedule->start_time, 'end_time'=>$schedule->end_time, 'color'=>'#99CCFF', 'textColor'=> 'black', 'booking'=>false];
            }
            $bookings = Booking::where(['location_id' => $locationId])
            ->whereHas('studios', function ($query) use ($refrence_id) {
                $query->where('studio_id', $refrence_id);
            })->get();
            //dd($bookings);
            foreach($bookings as $booking) {
                $createdByPhone = $booking->booking_by->mobile_number;
                $createdByEmail = $booking->booking_by->email; 
                $createdByUser = $booking->booking_by->fname.' '.$booking->booking_by->lname;
                if($booking->studios){
                    foreach($booking->studios as $studio){
                        $studio_title = $studio->name;
                        $studio_type = $studio->studioType;
                        $events[] = [
                            'id' => $studio->detid,
                            'booking_id' => $booking->booking_id,
							'booking_detail_id' =>  $studio->detid,
							'booking_status' => $studio->detstatus,
                            'title' => $createdByUser.", ".$studio_title,
                            'start' => $booking->start_date.'T'.$booking->start_time,
                            'end' => $booking->end_date.'T'.$booking->end_time,
                            'start_date' => $booking->start_date,
                            'end_date' => $booking->end_date, 
                            'start_time' => $booking->start_time,
                            'end_time' => $booking->end_time,
                            'type' => 'studio',
                            'studio_type' => $studio_type,
                            'studio_name' => $studio_title,
                            'resources' => '',
                            'equipments' => '',
                            'client_name' => $createdByUser,
                            'client_phone' => $createdByPhone,
                            'client_email' => $createdByEmail,
                            'total_points' => $booking->total_points,
                            'bgcolor' => "#0009ff",
                            'color' => "#0009ff",
                            'textColor' => 'black',
                            'booking'=>true
                        ];
                    }
                }
            }
        }else if($request->type=='rental'){
            $schedules = Schedule::Where('location_id',$locationId)->where('type','rental')->where('refrence_id',$refrence_id)->get();
            foreach($schedules as $schedule){
                $events[] = ['id'=>$schedule->id, 'location_id'=>$locationId, 'title' => 'Schedule', 'start' => $schedule->start_date.'T'.$schedule->start_time, 'end' => $schedule->start_date.'T'.$schedule->end_time, 'type'=> $schedule->type, 'schedule_type'=> $schedule->schedule_type, 'daily_rate'=> Helpers::convertCurrencyFromUSD($schedule->daily_rate), 'hourly_rate'=> Helpers::convertCurrencyFromUSD($schedule->hourly_rate), 'start_date'=>$schedule->start_date, 'start_time'=>$schedule->start_time, 'end_time'=>$schedule->end_time, 'color'=>'#99CCFF', 'textColor'=> 'black', 'booking'=>false];
            }
            $bookings = Booking::where(['location_id' => $locationId,])
            ->whereHas('rentals', function ($query) use ($locationId, $refrence_id) {
                $query->where('location_id', $locationId);
                $query->where('equipment_id', $refrence_id);
            })->get();
            //dd($bookings);
            foreach ($bookings as $booking) {
                $createdByPhone = $booking->booking_by->mobile_number;
                $createdByEmail = $booking->booking_by->email; 
                $createdByUser = $booking->booking_by->fname.' '.$booking->booking_by->lname;
                if($booking->rentals){
                    foreach($booking->rentals as $rental){
                        $events[] = [
                            'id' => $rental->detid,
                            'booking_id' => $booking->booking_id,
							'booking_detail_id' =>  $rental->detid,
							'booking_status' => $rental->detstatus,
                            'title' => $createdByUser.", ".$rental->name,
                            'start' => $booking->start_date.'T'.$booking->start_time,
                            'end' => $booking->end_date.'T'.$booking->end_time,
                            'start_date' => $booking->start_date,
                            'end_date' => $booking->end_date, 
                            'start_time' => $booking->start_time,
                            'end_time' => $booking->end_time,
                            'type' => 'rental',
                            'studio_type' => '',
                            'resources' => '',
                            'equipments' => $rental->name,
                            'client_name' => $createdByUser,
                            'client_phone' => $createdByPhone,
                            'client_email' => $createdByEmail,
                            'total_points' => $booking->total_points,
                            'bgcolor' => "#7600FF",
                            'color' => "#7600FF",
                            'textColor' => 'black',
                            'booking'=>true
                        ];
                    }
                }
            }
        }

        return response()->json($events, 200);
    }

    public function calendar_delete_sch_events(Request $request)
    {
        try{
            $sch = Schedule::where('id',$request->schedule_id)->first();
            if($sch){
                $sch->delete();
                if($request->recurring){
                    Schedule::where('refrence_id',$sch->refrence_id)->where('type',$sch->type)->where('start_date',$sch->start_date)->where('start_time',$sch->start_time)->where('end_time',$sch->end_time)->delete();
                }
            }
            return response()->json([
                'status' => true,
                'message' => 'Schedule(s) deleted successfully.',
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function account_setting_calendar(Request $request)
    {
        $refrence_id = auth()->user()->id;
        $locations = Location::orderBy('location','asc')->pluck('location','id');
        return view("user.account-setting-calendar")->with(['locations'=>$locations, 'refrence_id'=>$refrence_id]);
    }

    public function calendar_upsert_sch(Request $request)
    {
        //dd($request->all()); 
        try{
            $type = $request->type;
            $refrence_id = $request->refrence_id;
            $location_id = $request->schedule_location;
            
            if($request->schedule_id!=""){
                $data = [
                    'location_id'   => $location_id,
                    'start_date'    => $request->daily_start_date[0],
                    'end_date'      => $request->daily_start_date[0],
                    'start_time'    => $request->daily_start_time[0],
                    'end_time'      => $request->daily_end_time[0],
                    'daily_rate'    => Helpers::convertCurrencyToUSD($request->daily_daily_rate[0]),
                    'hourly_rate'   => Helpers::convertCurrencyToUSD($request->daily_hourly_rate[0]),
                    'updated_by'    => auth()->user()->id,
                    'updated_at'    => date('Y-m-d H:i:s')
                ];
                if($request->edit_schedule_type=="recurring"){
                    $data['schedule_type'] = 'recurring';
                }else{
                    $data['schedule_type'] = 'daily';
                }
                $sch = Schedule::where('id',$request->schedule_id)->first();
                Schedule::where('id',$request->schedule_id)->update($data);
                
                $msg = 'Schedule modified successfully.';
                if($request->edit_schedule_type=="recurring"){
                    Schedule::where('refrence_id',$refrence_id)->where('type',$type)->where('start_date',$sch->start_date)->where('start_time',$sch->start_time)->where('end_time',$sch->end_time)->update($data);
                    $msg = 'Schedules modified successfully.';
                }
                return response()->json([
                    'status' => true,
                    'message' => $msg,
                ], 200);
            }else{
                if($request->availability_type==0){
                    $dates = array_unique(array_values($request->daily_start_date));
                    $query = Schedule::where('refrence_id',$refrence_id)->where('type',$type);
                    foreach($dates as $date){
                        $query->where('start_date',$date);
                    }
                    $schedules = $query->get();

                    $data = [];
                    $daily_start_date = array_values($request->daily_start_date);
                    $daily_start_time = array_values($request->daily_start_time);
                    $daily_end_time = array_values($request->daily_end_time);
                    $daily_daily_rate = array_values($request->daily_daily_rate);
                    $daily_hourly_rate = array_values($request->daily_hourly_rate);
                    
                    for($i=0;$i<count($daily_start_date);$i++){
                        $startDate = strtotime($daily_start_date[$i].' '.$daily_start_time[$i]);
                        $endDate = strtotime($daily_start_date[$i].' '.$daily_end_time[$i]);
                        $exists = $schedules->filter(function($item, $key) use ($startDate,$endDate) {
                            $startDateItem = strtotime($item->start_date.' '.$item->start_time);
                            $endDateItem = strtotime($item->end_date.' '.$item->end_time);
                            return (($startDate <= $startDateItem && $startDateItem <= $endDate) || ($startDate <= $endDateItem && $endDateItem <= $endDate));
                        })->count();
                        //dd($exists);
                        if($exists>0){
                            return response()->json([
                                'status' => false,
                                'error' => 'Schedule already available for this date '.date('m/d/Y',$startDate).' and time '.date('h:i A',$startDate).' - '.date('h:i A',$endDate).'.',
                            ], 422);
                        }
                        $data[] = [
                            'location_id'   => $location_id,
                            'type'          => $type,
                            'refrence_id'   => $refrence_id,
                            'start_date'    => $daily_start_date[$i],
                            'end_date'      => $daily_start_date[$i],
                            'start_time'    => $daily_start_time[$i],
                            'end_time'      => $daily_end_time[$i],
                            'daily_rate'    => Helpers::convertCurrencyToUSD($daily_daily_rate[$i]),
                            'hourly_rate'   => Helpers::convertCurrencyToUSD($daily_hourly_rate[$i]),
                            'schedule_type' => 'daily',
                            'created_by'    => auth()->user()->id,
                            'created_at'    => date('Y-m-d H:i:s')
                        ];
                    }
                    if(count($data)>0){
                        Schedule::insert($data);
                        return response()->json([
                            'status' => true,
                            'message' => 'Schedule created successfully.',
                        ], 200);
                    }
                }else if($request->availability_type==1){
                    if($request->has('recurring_days')){
                        $weekdays = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
                        $startDate = Carbon::now()->timestamp;
                        $endDate = Carbon::now()->addMonth(env('RECURRING_SCHEDULE_MONTHS'))->timestamp;
                        $data = [];
                        $recurring_days = $request->recurring_days;
                        $recurring_start_time = $request->recurring_start_time;
                        $recurring_end_time = $request->recurring_end_time;
                        $recurring_daily_rate = $request->recurring_daily_rate;
                        $recurring_hourly_rate = $request->recurring_hourly_rate;
                        $data = [];
                        for($j=0;$j<count($recurring_days);$j++){
                            // get all recurring dates
                            for($i = strtotime($weekdays[$recurring_days[$j]], $startDate); $i <= $endDate; $i = strtotime('+1 week', $i)){
                                foreach($recurring_start_time[$recurring_days[$j]] as $key=> $starttime){
                                    //dump($key);dd($val);
                                    $data[] = [
                                        'location_id'   => $location_id,
                                        'type'          => $type,
                                        'refrence_id'   => $refrence_id,
                                        'start_date'    => date('Y-m-d', $i),
                                        'end_date'      => date('Y-m-d', $i),
                                        'start_time'    => $starttime,
                                        'end_time'      => $recurring_end_time[$recurring_days[$j]][$key],
                                        'daily_rate'    => Helpers::convertCurrencyToUSD($recurring_daily_rate[$recurring_days[$j]][$key]),
                                        'hourly_rate'   => Helpers::convertCurrencyToUSD($recurring_hourly_rate[$recurring_days[$j]][$key]),
                                        'schedule_type' => 'recurring',
                                        'created_by'    => auth()->user()->id,
                                        'created_at'    => date('Y-m-d H:i:s')
                                    ];
                                }
                            }
                        }
                        //dd($data);
                        if(count($data)>0){
                            Schedule::insert($data);
                            return response()->json([
                                'status' => true,
                                'message' => 'Schedule created successfully.',
                            ], 200);
                        }
                    }else{
                        return response()->json([
                            'status' => false,
                            'error' => 'Please select days to create schedules.',
                        ], 422);
                    }
                }
            }
            return response()->json([
                'status' => false,
                'error' => 'Unable to create schedule.',
            ], 422);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function otp_verification_profile(Request $request)
    {
        $id = auth()->user()->id;
        $validator = Validator::make($request->all(),[ 
            'email' => 'required|unique:users,email,'.$id.',id',
            'phone_number' => 'required|min:12|unique:users,mobile_number,'.$id.',id',
        ],[
            'email.required' => 'Email is required.',
            'email.unique' => 'Email already exist.',
            'phone_number.required' => 'Mobile number is required.',
            'phone_number.unique' => 'Mobile number already exist.',
            'phone_number.min' => 'Mobile number is not valid.',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            $cdata = [];
            $user = User::select('fname', 'lname','mobile_number','email')->where('id',$id)
                    ->first();
            if($user){
                if($user->email!=$request->email){
                    $token = random_int(100000, 999999);
                    User::where('id',auth()->user()->id)->update(['token'=>$token]);
                    $cdata['aemail'] = $request->email;
                    $cdata['email']  = substr($request->email, -8);
                    // send email by twillio
                    $new_token = [];
                    $token_array = str_split($token);
                    foreach($token_array as $tk){
                        $new_token[] = ['otp' => $tk];
                    }
                    $template_data['type'] = 1;
                    $template_data['token'] = $new_token;
                    $res = Helpers::__send_email($request->email, $template_data);
                }
                if($user->mobile_number!=$request->phone_number){
                    $cdata['amob'] = $request->phone_number;
                    $cdata['mobile'] = substr($request->phone_number, -4);
                    $res = Helpers::send_otp($request->phone_number);
                }
                $content = '';
                if(isset($cdata['mobile']) || isset($cdata['email'])){
                    $content = view('user.otp-verification-profile')->with($cdata)->render();
                }
                return response()->json([
                    'status' => true,
                    'content' => $content
                ], 200);
            }else{
                return response()->json([
                    'status' => false,
                    'error' => 'Invalid form data received.'
                ], 422);
            }
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }
    
    public function verify_otp_profile(Request $request)
    {
        try{
            $numOtp = 0;
            $otpValid = 0;
            $user = User::where('id',auth()->user()->id)->first();
            if(isset($request->eot1)){
                if($user->email != $request->email){
                    $numOtp++;
                }
                $otp_email = $request->eot1.$request->eot2.$request->eot3.$request->eot4.$request->eot5.$request->eot6;
                if($user->token == $otp_email){
                    User::where('id',auth()->user()->id)->update(['email'=>$request->email]);
                    auth()->user()->email = $request->email;
                    $otpValid++;
                }else{
                    return response()->json([
                        'status' => false,
                        'error'=>'Verification code is not valid for email.'
                    ], 422);
                }
            }
            if(isset($request->first)){
                if($user->mobile_number != $request->mobile){
                    $numOtp++;
                }
                $otp_number = $request->first.$request->second.$request->third.$request->fourth.$request->fifth.$request->sixth;
                $isVerified = Helpers::verify_otp($request->mobile, $otp_number);
                if ($isVerified) {
                    User::where('id',auth()->user()->id)->update(['mobile_number'=>$request->mobile]);
                    $otpValid++;
                }else{
                    return response()->json([
                        'status' => false,
                        'error'=>'Verification code is not valid for mobile.'
                    ], 422);
                }
            }
            if($otpValid==$numOtp){
                return response()->json([
                    'status' => true,
                    'message'=>'Changes has been verified successfully.'
                ], 200);
            }else{
                return response()->json([
                    'status' => false,
                    'error' => 'Verification code is not valid.',
                ], 422);
            }
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }    
    }

}
