<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Location;
use App\Models\UpcomingGuest;
use App\Helpers, Hash;
class GuestController extends Controller
{
    public function upcoming_guests(Request $request, $locationId, $guestId='')
    {
        $query = UpcomingGuest::select('upcoming_guests.*','users.fname','users.lname','users.email')
        ->Join('users','guest_uuid','users.uuid')->with('location','host')->where('location_id',$locationId);
        if($request->has('name') && $request->name!=""){
            $query->whereRaw('concat(fname," ",lname) like "'.$request->name.'%"');
        }
        $guests = $query->OrderBy('created_at', 'desc')->paginate(10);
        //dd($guests);
        return view("user.upcoming-guest")->with(['data'=>$guests,'guestId'=>$guestId]);
    }
	
    public function invite_action(Request $request)
    {
        try{
            if($request->status==3){
                $guestData = UpcomingGuest::select('invitation_date', 'invitation_time', 'uuid', 'users.fname', 'users.lname', 'users.email')->join('users', 'guest_uuid', '=', 'users.uuid')
                ->where('upcoming_guests.id',$request->upcoming_id)->first();
                $password = Helpers::generatePassword();
                User::where('uuid',$guestData->uuid)->update(['password'=>Hash::make($password)]);
                // invitation email
                $data = array();
                $data['email']  = $guestData->email;
                $data['name']   = $guestData->fname.' '.$guestData->lname;
                $data['password']   = $password;
                $data['invcontent'] = 'You are invited as a guest on '.$guestData->invitation_date.' '.$guestData->invitation_time;
                \Mail::send('emails.invitation', $data, function($message) use($data) {
                    $message->to($data['email']);
                    $message->subject('Resend Invitation');
                });
                return response()->json([
                    'status' => true,
                ], 200);
            }else{
                $mngstatus = UpcomingGuest::where('id',$request->upcoming_id)->update(['status'=>$request->status]);
                if($mngstatus){
                    if($request->status==1){
                        $msg = 'CheckedIn successfully.';
                    }else if($request->status==2){
                        $msg = 'Invitation cancelled successfully.';
                    }else{
                        $msg = 'Status updated successfully.';
                    }
                    return response()->json([
                        'status' => true,
                        'message' => $msg,
                    ], 200);
                }
            }
            return response()->json([
                'status' => false,
                'error' => 'Invalid form data received.',
            ], 422);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }
    
}
