<?php

namespace App\Http\Controllers;
  
use Illuminate\Http\Request;
use App\Models\Plan;
use App\Models\User;
Use App\Models\Point;
Use App\Models\SiteConfig;
use App\Models\Notification;
use Stripe\PaymentIntent;
use Session, DB, Log;
class PlanController extends Controller
{
    public function index(Request $request)
    {
        $plans = Plan::get();
        $guests = config('app.guests');
        return view("stripe.plans", compact("plans", "guests"));
    }  
  
    public function show(Plan $plan, Request $request)
    {
        Session::flash('success','Payment captured successfully');
        $intent = auth()->user()->createSetupIntent();
  
        return view("stripe.subscription", compact("plan", "intent"));
    }
    
    public function subscription(Request $request)
    {
        try{
            // if subscription exist then cancel
            if(auth()->user()->membership){
              auth()->user()->subscription(auth()->user()->membership)->cancel();
            }
            // create new subscription
            $plan = Plan::find($request->plan);
            $metadata = [
                'uuid' => auth()->user()->uuid,
            ];
            //dd($stripe_data);
            $subscription = $request->user()->newSubscription($plan->slug, $plan->stripe_plan)
                            ->create($request->token, ['email'=>auth()->user()->email],['metadata'=> $metadata]);
            
            User::where('id',auth()->user()->id)->update(['role'=>'member','membership'=>$plan->slug,'status'=>1]);
            Session::flash('success','Payment captured successfully');
            
            if($request->session()->has('signup_flow')){
              return  redirect()->route('additional-information');
            }else{
              return  redirect('account-setting');
            }
        }catch(\Stripe\Error\Card $e){
            $body = $e->getJsonBody();
            $err  = $body['error'];
            return redirect()->back()->with('error', $err);
        }
    }

    public function subscription_cancel(Request $request)
    {
      try{
        if(auth()->user()->membership){
          auth()->user()->subscription(auth()->user()->membership)->cancel();
          
          // notifications
          Notification::insert(['user'=>auth()->user()->id, 'type'=>'subscription', 'action'=>'cancelled', 'content'=>'Your subscription has been cancelled successfully.']);
          // emails
          if(auth()->user()->email){
            $edata = array();
            $edata['email'] = auth()->user()->email;
            $edata['name']  = auth()->user()->fname.' '.auth()->user()->lname;
            $edata['heading'] = 'Subscription Cancelled';
            $edata['content'] = 'Your subscription <b>'.auth()->user()->membership.'</b> had been cancelled.';
            \Mail::send('emails.general', $edata, function($message) use($edata) {
                $message->to($edata['email']);
                $message->subject('Subscription cancelled!');
            });
          }
          
          return response()->json([
            "status" => true,
            "message" => 'Subscription cancelled successfully.',
          ],200);
        }

        return response()->json([
          "status" => false,
          "error" => 'Invalid form data received.',
        ],422);

      } catch (\PDOException $pde) {
          return response()->json([
              "status" => false,
              "error" => $pde->getMessage(),
          ],422);
      } catch (\Exception $e) {
          return response()->json([
              "status" => false,
              "error" => $e->getMessage(),
          ],422);
      }
    }

    public function buy_more_points(Request $request)
    {
        try{
            $point = SiteConfig::where('key_name','points_per_usd')->first();
            $content = view("stripe.buy-more-points")->with(['points_per_usd'=>$point->key_value])->render(); 
            return response()->json([
                'status' => true,
                'content' => $content
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function purchase_points(Request $request, $points)
    {
      $pointVal = SiteConfig::where('key_name','points_per_usd')->first();
      $amount = $points/$pointVal->key_value;
      auth()->user()->createOrGetStripeCustomer();
      $intent = auth()->user()->createSetupIntent();
      return view("stripe.buy-points-subscription", compact("amount", "points", "intent"));
    }

    public function process_buy_more_points(Request $request)
    {
        try{
            $points = $request->points;
            $pointVal = SiteConfig::where('key_name','points_per_usd')->first();
            $amount = $points/$pointVal->key_value;
            auth()->user()->createOrGetStripeCustomer();
            auth()->user()->updateDefaultPaymentMethod($request->token);
            auth()->user()->charge($amount * 100, $request->token, ['metadata'=>['purchase_type'=>'POINTS_PURCHASED', 'purchase_points'=>$points]]);
            
            // $pt = new Point
            // $pt->action = 'POINTS_PURCHASED';
            // $pt->receivedby_uuid = auth()->user()->uuid;
            // $pt->receivedby_uuid

            Session::flash('success','Payment captured successfully');
            
            return  redirect('account-setting');
        }catch(\Stripe\Error\Card $e){
            $body = $e->getJsonBody();
            $err  = $body['error'];
            return redirect()->back()->with('error', $err);
        }
    }

    public function stripe_webhook(Request $request)
    {
        $payload = @file_get_contents('php://input');
        $event = null;
        //Log::debug($payload);
        //echo '<pre>';print_r($payload);exit;
        // $payload = '{"id": "evt_3O2IZhBfA6yrUxU00DC6Icv9",
        //               "object": "event",
        //               "api_version": "2023-08-16",
        //               "created": 1697569506,
        //               "data": {
        //                 "object": {
        //                   "id": "ch_3O2IZhBfA6yrUxU00sFZtTxA",
        //                   "object": "charge",
        //                   "amount": 300,
        //                   "amount_captured": 300,
        //                   "amount_refunded": 0,
        //                   "application": null,
        //                   "application_fee": null,
        //                   "application_fee_amount": null,
        //                   "balance_transaction": "txn_3O2IZhBfA6yrUxU00o9oFyCs",
        //                   "billing_details": {
        //                     "address": {
        //                       "city": null,
        //                       "country": null,
        //                       "line1": null,
        //                       "line2": null,
        //                       "postal_code": "20130",
        //                       "state": null
        //                     },
        //                     "email": null,
        //                     "name": "sudhir",
        //                     "phone": null
        //                   },
        //                   "calculated_statement_descriptor": "NOMADIC STUDIOS",
        //                   "captured": true,
        //                   "created": 1697569505,
        //                   "currency": "usd",
        //                   "customer": "cus_OoiacwFGDhaEma",
        //                   "description": null,
        //                   "destination": null,
        //                   "dispute": null,
        //                   "disputed": false,
        //                   "failure_balance_transaction": null,
        //                   "failure_code": null,
        //                   "failure_message": null,
        //                   "fraud_details": {
        //                   },
        //                   "invoice": null,
        //                   "livemode": false,
        //                   "metadata": {
        //                     "purchase_type": "POINTS_PURCHASED",
        //                     "purchase_points": "3"
        //                   },
        //                   "on_behalf_of": null,
        //                   "order": null,
        //                   "outcome": {
        //                     "network_status": "approved_by_network",
        //                     "reason": null,
        //                     "risk_level": "normal",
        //                     "risk_score": 39,
        //                     "seller_message": "Payment complete.",
        //                     "type": "authorized"
        //                   },
        //                   "paid": true,
        //                   "payment_intent": "pi_3O2IZhBfA6yrUxU00Ozj41p2",
        //                   "payment_method": "pm_1O2IZdBfA6yrUxU0riwsJsxq",
        //                   "payment_method_details": {
        //                     "card": {
        //                       "amount_authorized": 300,
        //                       "brand": "visa",
        //                       "checks": {
        //                         "address_line1_check": null,
        //                         "address_postal_code_check": "pass",
        //                         "cvc_check": "pass"
        //                       },
        //                       "country": "US",
        //                       "exp_month": 12,
        //                       "exp_year": 2024,
        //                       "extended_authorization": {
        //                         "status": "disabled"
        //                       },
        //                       "fingerprint": "d8mN7ZcAWwMIUOY4",
        //                       "funding": "credit",
        //                       "incremental_authorization": {
        //                         "status": "unavailable"
        //                       },
        //                       "installments": null,
        //                       "last4": "4242",
        //                       "mandate": null,
        //                       "multicapture": {
        //                         "status": "unavailable"
        //                       },
        //                       "network": "visa",
        //                       "network_token": {
        //                         "used": false
        //                       },
        //                       "overcapture": {
        //                         "maximum_amount_capturable": 300,
        //                         "status": "unavailable"
        //                       },
        //                       "three_d_secure": null,
        //                       "wallet": null
        //                     },
        //                     "type": "card"
        //                   },
        //                   "receipt_email": null,
        //                   "receipt_number": null,
        //                   "receipt_url": "https://pay.stripe.com/receipts/payment/CAcaFwoVYWNjdF8xTnB5aFdCZkE2eXJVeFUwKOK1u6kGMgYyBIOWjcE6LBYIPtHaDUIMa0ehTndSCnyc5cKRL886gXKILBjnE2PRnxCLJtkzLgdaDJa_",
        //                   "refunded": false,
        //                   "review": null,
        //                   "shipping": null,
        //                   "source": null,
        //                   "source_transfer": null,
        //                   "statement_descriptor": null,
        //                   "statement_descriptor_suffix": null,
        //                   "status": "succeeded",
        //                   "transfer_data": null,
        //                   "transfer_group": null
        //                 }
        //               },
        //               "livemode": false,
        //               "pending_webhooks": 1,
        //               "request": {
        //                 "id": "req_RF3QDZ2dMU9alZ",
        //                 "idempotency_key": "fb280a27-6d52-4ac3-9949-41680ff9578d"
        //               },
        //               "type": "charge.succeeded"
        //             }';
        try {
            $event = \Stripe\Event::constructFrom(
                json_decode($payload, true)
            );
            //dd($event);
        } catch(\UnexpectedValueException $e) {
            // Invalid payload
            http_response_code(400);
            exit();
        }
        // Handle the event
        switch ($event->type) {
            case 'charge.succeeded':
              $charge = $event->data->object;
              $customer_id = $charge->customer;
              $invoice_id = $charge->invoice;
              $amount =  $charge->amount/100;
              $user = User::where('stripe_id',$customer_id)->first();
              $balance_point = 0;
              $available_points = Point::select('balance')->where('receivedby_uuid',$user->uuid)->orderBy('id','desc')->first();
              if(isset($charge->metadata->purchase_type) && $charge->metadata->purchase_type=='POINTS_PURCHASED'){
                if($available_points){
                  $balance_point = $available_points->balance + $charge->metadata->purchase_points;
                }else{
                  $balance_point = $charge->metadata->purchase_points;
                }
                $point = new Point;
                $point->action = $charge->metadata->purchase_type;
                $point->receivedby_uuid = $user->uuid;
                $point->invoice_id = $invoice_id;
                $point->credit  = $charge->metadata->purchase_points;
                $point->balance = $balance_point;
                $point->amount = $amount;
                $point->save();
                $pointId = $point->id;
                // notifications
                Notification::insert(['user'=>$user->uuid, 'type'=>'point', 'action'=>'POINTS_PURCHASED', 'content'=>'Your purchased points ('.$charge->metadata->purchase_points.') has been credited to your wallet.','reference_id'=>$pointId]);
                // emails
                if($user->email){
                  $edata = array();
                  $edata['email'] = $user->email;
                  $edata['name']  = $user->fname.' '.$user->lname;
                  $edata['heading'] = 'Points purchased';
                  $edata['content'] = 'Your purchased points ('.$charge->metadata->purchase_points.') had been successfully credited to your wallet.';
                  \Mail::send('emails.general', $edata, function($message) use($edata) {
                      $message->to($edata['email']);
                      $message->subject('Points purchased!');
                  });
                }
              }else{
                $plan = Plan::where('price',$amount)->first();
                if($available_points){
                  $balance_point = $available_points->balance + $plan->points;
                }else{
                  $balance_point = $plan->points;
                }
                // add into points table
                $point = new Point;
                $point->action = 'MEMBERSHIP_CREDIT';
                $point->receivedby_uuid = $user->uuid;
                $point->invoice_id = $invoice_id;
                $point->plan_id = $plan->id;
                $point->credit  = $plan->points;
                $point->balance = $balance_point;
                $point->amount = $amount;
                $point->save();
                $pointId = $point->id;
                // notifications
                Notification::insert(['user'=>$user->uuid, 'type'=>'point', 'action'=>'MEMBERSHIP_CREDIT', 'content'=>'Your membership points ('.$plan->points.') has been credited successfully.','reference_id'=>$pointId]);
                // emails
                if($user->email){
                  $edata = array();
                  $edata['email'] = $user->email;
                  $edata['name']  = $user->fname.' '.$user->lname;
                  $edata['heading'] = 'Membership Credit';
                  $edata['content'] = 'Your membership points ('.$plan->points.') had been successfully credited to your wallet.';
                  \Mail::send('emails.general', $edata, function($message) use($edata) {
                      $message->to($edata['email']);
                      $message->subject('Membership credited!');
                  });
                }
              }
            case 'charge.failed':
              $charge = $event->data->object;
              $customer_id = $charge->customer;
              $user = User::where('stripe_id',$customer_id)->first();
              DB::table('subscriptions')->where('user_id',$user->id)->update(['status','inactive']);
            case 'payment_intent.succeeded':
                $paymentIntent = $event->data->object; // contains a \Stripe\PaymentIntent
                // Then define and call a method to handle the successful payment intent.
                // handlePaymentIntentSucceeded($paymentIntent);
                break;
            case 'payment_method.attached':
                $paymentMethod = $event->data->object; // contains a \Stripe\PaymentMethod
                // Then define and call a method to handle the successful attachment of a PaymentMethod.
                // handlePaymentMethodAttached($paymentMethod);
                break;
            // ... handle other event types
            default:
                echo 'Received unknown event type ' . $event->type;
        }

        http_response_code(200);
    }
}
