<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon, Auth, DB, Session, Validator, Hash;
use App\Models\Location, App\Models\Role, App\Models\RolePages;
use App\Models\Studio, App\Models\StudioTypes;
use App\Models\User, App\Models\UserPermission;
use App\Models\Booking;
use App\Models\Schedule;
use App\Models\Equipment;
use App\Models\EquipmentCategory;
use App\Models\ResourceTypes;
use App\Helpers;
class RentalController extends Controller
{
	private $paginate = 20;

	public function rental_booking(Request $request,$locationId){
	    $events = [];
        $bookings = Booking::where([
        'location_id' => $locationId,
        ])->whereHas('rentals', function ($query) use ($locationId) {
        $query->where('location_id', $locationId);
        })->get();
		$query = Equipment::where('location_id', $locationId)->where('studios_id', 0)->with('Category');
        if($request->has('name') && $request->name!=""){
            $query->whereRaw('name like "%'.$request->name.'%"');
        }
        $studio_equipments = $query->paginate($this->paginate);
        //dd($bookings);
        foreach ($bookings as $booking) {
            $createdByPhone = $booking->booking_by->mobile_number;
            $createdByEmail = $booking->booking_by->email; 
            $createdByUser = $booking->booking_by->fname.' '.$booking->booking_by->lname;
            foreach($booking->rentals as $rental){
                $events[] = [
                    'id' => $rental->detid,
                    'booking_id' => $booking->booking_id,
					'booking_detail_id' =>  $rental->detid,
					'booking_status' => $rental->detstatus,
                    'title' => $createdByUser.", ".$rental->name,
                    'start' => $booking->start_date.'T'.$booking->start_time,
                    'end' => $booking->end_date.'T'.$booking->end_time,
                    'start_date' => $booking->start_date,
                    'end_date' => $booking->end_date, 
                    'start_time' => $booking->start_time,
                    'end_time' => $booking->end_time,
                    'type' => 'rental',
                    'studio_type' => '',
                    'resources' => '',
                    'equipments' => $rental->name,
                    'client_name' => $createdByUser,
                    'client_phone' => $createdByPhone,
                    'client_email' => $createdByEmail,
                    'total_points' => $booking->total_points,
                    'bgcolor' => "#7600FF",
                    'color' => "#7600FF",
                    'textColor' => 'black',
                ]; 
            }
        }
		
        return view("rental.rental-booking")->with(['locationId' => $locationId,  'studio_equipments' =>$studio_equipments,  'events' => $events]); 
	}
	
	public function equipment_schedule(Request $request,$locationId,$equipmentId){
		$equipment = Equipment::find($equipmentId);
        
		return view("rental.rental-schedules")->with(['locationId' => $locationId, 'equipmentId'=>$equipmentId, 'equipment' => $equipment]); 
	}
	
	public function rental_detail(Request $request){
        $equipment_category = EquipmentCategory::pluck('cat_name','id');
        try{
            $data = null;
            if($request->has('lid') && $request->lid!=""){
                $data = Equipment::find($request->lid);
            }
			$specialist = ResourceTypes::where('status',1)->pluck('name','id');
            $content = view("rental.rental-card")->with(['data'=>$data,'specialist'=>$specialist,'locationId'=>$request->locationId,'studioId'=>$request->studioId,'equipment_category'=>$equipment_category])->render();    
            return response()->json([
                'status' => true,
                'content' => $content,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function upload(Request $request)
    {
        $rentalPath = $receiptPath = $manualPath = ''; 
        $fileName = ''; 

        if ($request->hasFile('rental')) {
            $rental = $request->file('rental');
            $fileName = time() . '_' . $rental->getClientOriginalName();
            $rentalPath = $rental->storeAs('rental', $fileName, 'public');
        }

        if ($request->hasFile('receipt')) {
            $receipt = $request->file('receipt');
            $fileName = time() . '_' . $receipt->getClientOriginalName();
            $receiptPath = $receipt->storeAs('receipt', $fileName, 'public');
        }

        if ($request->hasFile('manual')) {
            $manual = $request->file('manual');
            $fileName = time() . '_' . $manual->getClientOriginalName();
            $manualPath = $manual->storeAs('manual', $fileName, 'public');
        }

        return response()->json([
            'success' => true,
            'rentalPath' => $rentalPath,
            'receiptPath' => $receiptPath,
            'manualPath' => $manualPath,
            'fileName' => $fileName
        ]);
    }

    public function save_rental(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'locationId' => 'required',
            'category' => 'required',
            'serial_number' => 'required',
            'manual_link' => 'nullable|url'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'error' => $validator->errors()
            ], 422);
        }

        try {
            if ($request->equipmentid) {
                $data = Equipment::find($request->equipmentid);
                $msg = 'Equipment updated successfully.';
            } else {
                $data = new Equipment;
                $msg = 'Equipment created successfully.';
            }
            
            $data->location_id = $request->locationId;
			$data->specialist = $request->specialist;
            $data->manual = $request->manual;
			$data->manual_link = $request->manual_link;
            $data->receipt = $request->receipt;
            $data->price = Helpers::convertCurrencyToUSD($request->price);
            $data->cost_per_day = Helpers::convertCurrencyToUSD($request->cost_per_day);
            $data->cost_per_hour = Helpers::convertCurrencyToUSD($request->cost_per_hour);
            $data->name = $request->name;
            $data->photo = $request->photo;
            $data->category = $request->category;
            $data->description = $request->description;
            $data->serial_number = $request->serial_number;
            $data->note = $request->note;
            $data->save();
            Session::flash('success',$msg);

            return response()->json([
                'status' => true,
                'location' => $request->locationId,
            ], 200);
        } catch (\PDOException $pde) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }	
}
