<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Equipment extends Model
{  
    protected $table = 'equipments';
    protected $primaryKey = 'id';
	
    public function Category()
    {
      return $this->belongsTo(EquipmentCategory::class, 'category');
    }

    public function resourceTypes()
    {
      return $this->hasOne(ResourceTypes::class,'id','specialist');
    }

    public function schedules()
    {
      return $this->hasMany(Schedule::class, 'refrence_id')->where('type','rental');
    }

    public function bookings()
    {
      return $this->hasMany(BookingDetail::class, 'equipment_id')->where('type','rental');
    }

}
