<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Event extends Model
{
    protected $table = 'events';
    protected $primaryKey = 'event_id';

    public function createdBy()
    {
        return $this->hasOne(User::class, 'id', 'created_by')->select('id','fname','lname');
    }

    public function updatedBy()
    {
        return $this->hasOne(User::class, 'id', 'updated_by')->select('id','fname','lname');
    }

    public function formattedDate()
    {
        return Carbon::parse($this->event_date.'T'.$this->event_time)->isoFormat('dddd, D MMM [AT] h:mm A');
    }

    public function participants()
    {
        return $this->belongsToMany(User::class, 'participants', 'event_id', 'user_id')->withPivot('status');
           
    }

    public function interested()
    {
        return $this->hasMany(Participant::class, 'event_id', 'event_id')->where('participants.status','interested');
    }

    public function going()
    {
        return $this->hasMany(Participant::class, 'event_id', 'event_id')->where('participants.status','going');
    }
}
