<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class LandingPage extends Model
{  
    protected $table = 'landing_pages';
    protected $primaryKey = 'id';

    public function location()
    {
        return $this->hasOne(Location::class, 'id', 'location_id')->select('id','location');
    }

    public function studio()
    {
        return $this->hasOne(Studio::class, 'id', 'studios')->select('id','name');
    }

    function gallery() {
        return $this->hasMany(Gallery::class,'ref_id','id')->where('type','studio')->where('image_type','gallery');
    }
}
