<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Location extends Model
{  
    protected $table = 'location';
    protected $primaryKey = 'id';
	
    function landing_page() {
        return $this->hasOne(LandingPage::class,'location_id','id')->where('type','location');
    }

    function gallery() {
        return $this->hasMany(Gallery::class,'ref_id','id')->where('type','location')->where('image_type','gallery');
    }

    function benefit() {
        return $this->hasMany(Gallery::class,'ref_id','id')->where('type','location')->where('image_type','benefit');
    }

    function our_crew() {
        return $this->hasMany(Gallery::class,'ref_id','id')->where('type','location')->where('image_type','benefit');
    }

	function Studio() {
        return $this->hasMany(Studio::class);
    }
}
