<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Studio extends Model
{
    protected $table = 'studios';
    protected $primaryKey = 'id';

    public function landingPage()
    {
        return $this->hasOne(LandingPage::class, 'studios')->where('type','studio');
    }

    public function schedules()
    {
        return $this->hasMany(Schedule::class, 'refrence_id')->where('type','studio');
    }

    public function bookings()
    {
        return $this->hasMany(BookingDetail::class, 'studio_id')->where('type','studio');
    }

}
