<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UpcomingGuest extends Model
{
	protected $table = 'upcoming_guests';
    protected $primaryKey = 'id';
	protected $fillable = [
        'location_id',
        'invitation_type',
        'event_id',
        'ref_id',
        'guest_uuid',
        'host_uuid',
        'invitation_date',
        'invitation_time',
    ];
	
    public function location()
    {
        return $this->hasOne(Location::class,'id','location_id');
    }

    public function host()
    {
        return $this->hasOne(User::class,'uuid','host_uuid')->select('users.uuid','fname','lname','mobile_number','email');
    }

    public function guest()
    {
        return $this->hasOne(User::class,'uuid','guest_uuid')->select('users.uuid','fname','lname','mobile_number','email');
    }
	
}
