<?php
namespace App;
use GuzzleHttp\Client;
use DB;

class SendBird
{
    private $base_url = "";
    
    public function __construct(){
        $app_id = env("SENDBIRD_APP_ID");
        $this->base_url = "https://api-{$app_id}.sendbird.com/v3";
    }
    
    public function GET_Call($api_name, $params = []){
        try{
            $headers = [
                'Content-Type' => 'application/json',
                'Api-Token' => env('SENDBIRD_APP_TOKEN'),
            ];
            $client = new Client([
                'headers' => $headers
            ]);
            $base_url = "{$this->base_url}/{$api_name}";
            $queryString = http_build_query($params);
            $api_url = (!empty($queryString)) ? "{$base_url}?{$queryString}" : "{$base_url}";
            $res = $client->request('GET', "{$api_url}", []);
            $response = $res->getBody()->getContents();
            
            return [
                'status' => true,
                'data' => json_decode($response, true),
            ];

        }catch(\Exception $e){
            return [
                'status' => false,
                'error' => $e->getMessage(),
            ];
        }
    }

    public function POST_Call($api_name, $params = []){
        try{
            $headers = [
                'Content-Type' => 'application/json',
                'Api-Token' => env('SENDBIRD_APP_TOKEN'),
            ];
            $client = new Client([
                'headers' => $headers
            ]);
            $api_url = "{$this->base_url}/{$api_name}";
            $res = $client->request('POST', "{$api_url}", ['json' => $params]);
            $response = $res->getBody()->getContents();
            
            return [
                'status' => true,
                'data' => json_decode($response, true),
            ];

        }catch(\Exception $e){
            return [
                'status' => false,
                'error' => $e->getMessage(),
            ];
        }
    }

}