@extends('layouts.main')
@section('title', 'Nomadic-Login')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4">{{__('Sign In')}}</h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
            @if (session('error'))
            <div class="alert alert-danger">{{session('error')}}</div>
            @endif
            <form id="loginForm" class="w-100"> 
                @csrf
                <input type="hidden" name="type" value="login" readonly/>
                <div class="form-container">
                    <div class="form-group mb-2">
                        <input type="tel" placeholder="{{__('Mobile Number')}}" id="telephone" class="form-control shadow-none" maxlength="14"/>
                        <span id="msg" class="error"></span>
                        <input type="hidden" id="mobile_number" name="mobile_number"/>
                    </div>
                </div>
                <div align="left">
                    <input id="checkbox-20" name="remember_token" class="checkbox-custom" value="1" type="checkbox" checked>
                    <label for="checkbox-20" class="checkbox-custom-label">Keep me logged in</label> 
                    <span class="form-container float-end">
                        <a class="float-end mt-2" href="{{url('login-email')}}">Login with email</a>
                    </span>
                </div>
                <div id="btn-sendotp" class="form-container">
                    <div class="btnconter mt-3 mb-4">
                        <button class="btn send-otp" type="button">{{__('Send')}}
                            <div class="spinner-border spinner-border-sm text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                        </button>
                    </div>
                </div>
                <div class="otp-container">
                    <div id="otp" class="inputs d-flex flex-row justify-content-center mt-2">
                        <input class="m-2 text-center form-control rounded otp-input" type="text" id="first" name="first" maxlength="1" />
                        <input class="m-2 text-center form-control rounded otp-input" type="text" id="second" name="second" maxlength="1" />
                        <input class="m-2 text-center form-control rounded otp-input" type="text" id="third" name="third" maxlength="1" />
                        <input class="m-2 text-center form-control rounded otp-input" type="text" id="fourth" name="fourth" maxlength="1" />
                        <input class="m-2 text-center form-control rounded otp-input" type="text" id="fifth" name="fifth" maxlength="1" />
                        <input class="m-2 text-center form-control rounded otp-input" type="text" id="sixth" name="sixth" maxlength="1" />
                    </div>
                    <div class="form-container">
                        <span>{{__("Didn’t get an SMS?")}}</span> <span class="otp-timer"><a class="send-otp pointer">{{__('Send again')}}</a></span>
                        <div class="btnconter mt-3 mb-4">
                            <button class="btn" type="button" id="btn_verifyotp">{{__('Submit')}}
                                <div class="spinner-border spinner-border-sm text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<link rel="stylesheet" href="{{asset('css/intlTelInput.css')}}">
<script src="{{asset('js/intlTelInput.js')}}"></script> 
<script>
var errorMap = ["{{__('Invalid number')}}", "{{__('Invalid country code')}}", "{{__('Too short')}}", "{{__('Too long')}}"];
var input = document.querySelector("#telephone");
var msg = document.querySelector("#msg");
var intl = window.intlTelInput(input, {
    autoPlaceholder: false,
    separateDialCode: true,
    placeholderNumberType: "MOBILE",
    utilsScript: "{{asset('js/utils.js')}}"
});
// Validate on blur event
input.addEventListener('keyup', function() {
    if(input.value.trim()){
        if(intl.isValidNumber()){
            input.classList.remove("error");
            msg.classList.add("hide");
            //msg.hide();
        }else{
            input.classList.add("error");
            var errorCode = intl.getValidationError();
            msg.innerHTML = errorMap[errorCode];
            msg.classList.remove("hide");
            //msg.show();
        }
    }
    let full_number = intl.getNumber();
    $('#mobile_number').val(full_number);
});

document.addEventListener("DOMContentLoaded", function(event) {
    OTPInput(); 
});
$(document).ready(function () {
    $(document).on('click','.send-otp',function(){
        if(intl.isValidNumber()){
            $('#telephone').removeClass('is-invalid');
        }else{
            $('#telephone').addClass('is-invalid');
            $('#msg').html("{{__('This field is required.')}}");
            return false;
        }
        let number = $('#mobile_number').val();
        $('.send-otp .spinner-border').show();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, otpfield:number, 'type':'mobile'}, 
            url: APP_URL+"/send-otp",
            success: function(res) {
                if(res.status){
                    let timerSec = {{env('OTP_WAIT_MINUTE')}} * 60;
                    timer(timerSec);
                    $('#mobile_number').attr('readonly',true);
                    $('#btn-sendotp').hide();
                    $('.otp-container').show();
                    $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
                $('.send-otp .spinner-border').hide();
            },
            error: function(res) {
                $('.send-otp .spinner-border').hide();
                ajax_error(res);
            }
        });
    });
    $(document).on('click','#btn_verifyotp',function(){
        $('#btn_verifyotp .spinner-border').show();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#loginForm').serialize(),
            url: APP_URL+"/verify-otp",
            success: function(res) {
                $('#btn_verifyotp .spinner-border').hide();
                if(res.status){
                    window.location.href = APP_URL+'/my-profile';
                }
            },
            error: function(res) {
                $('#btn_verifyotp .spinner-border').hide();
                ajax_error(res);
            }
        });
    });
    
});
</script>
@endsection
