@extends('layouts.main')
@section('title', 'Nomadic-Reset Password')
@section('content')
<div class="container">
    <h2 style="margin-top:6rem;margin-bottom:2rem;">{{__('Reset Password')}}</h2>
    <div class="row mb-5 d-block">
        <div class="col-md-6">
            @if (session('error'))
            <div class="alert alert-danger">{{session('error')}}</div>
            @endif
            @if (session('success'))
            <div class="alert alert-success">{{session('success')}}</div>
            @endif
            <form id="resetForm">
                @csrf
                <div class="mb-3">
                    <label for="emilAddress" class="form-label">E-mail Address</label>
                    <input name="email" type="email" class="form-control" id="emailInput" placeholder="Please enter your email">
                </div>
                <div class="mb-3">
                    <button class="btn btn-primary" id="btn_forgot_pass" type="button">Send Password Reset Link</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('footer_scripts')
<script>
$(document).ready(function () {
    $('#btn_forgot_pass').click(function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#resetForm').serialize(),
            url: APP_URL+"/reset-password",
            success: function(res) {
                if(res.status){
                    window.location.reload();
                }else{
                    $('.pagemsgcontent').html('<div class="alert alert-error">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
            },
            error: function(res) {                    
                ajax_error(res);
            }
        });
    });
});
</script>
@endsection
