@extends('layouts.main')
@section('title', 'Nomadic-Update Password')
@section('content')
<div class="container">
    <h2 style="margin-top:6rem !important;margin-bottom:2rem;">{{__('Update Password')}}</h2>
    <div class="row mb-5 d-block">
        <div class="col-md-6">
            @if (session('error'))
            <div class="alert alert-danger">{{session('error')}}</div>
            @endif
            @if (session('success'))
            <div class="alert alert-success">{{session('success')}}</div>
            @endif
            <form id="resetForm">
                @csrf
                <input type="hidden" name="reset_token" value="{{$data->token}}" readonly>
                <div class="form-container">
                    <div class="form-group mb-2">{{$data->email}}</div>
                    <div class="form-group mb-2">
                        <input type="text" id="new_password" name="new_password" class="form-control shadow-none" placeholder="{{__('New Password')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="text" id="confirm_password" name="confirm_password" class="form-control shadow-none" placeholder="{{__('Confirm Password')}}" />
                    </div>
                </div>
                <div class="mb-3">
                    <button class="btn btn-primary" id="btn_update_pass" type="button">Update Password</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('footer_scripts')
<script>
$(document).ready(function () {
    $('#btn_update_pass').click(function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#resetForm').serialize(),
            url: APP_URL+"/update-password",
            success: function(res) {              
                if(res.status){
                    $('.pagemsgcontent').html('<div class="alert alert-success">Password updated successfully.</div>');
                    $('#alertMsg').modal('show');
                    setTimeout(function() {
                        window.location.href = APP_URL+'/login';
                    }, 1000);
                }else{
                    $('.pagemsgcontent').html('<div class="alert alert-error">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
            },
            error: function(res) {
                ajax_error(res);
            }
        });
    });
});
</script>
@endsection
