<div class="position-relative">
    <div class="chat-messages p-4">
        @foreach($messages as $msg)
            @if(!isset($msg['user']))
            <div class="chat-message-right pb-4 w-75" data-msgid="{{$msg['message_id']}}">
                <div>
                    <img src="https://bootdey.com/img/Content/avatar/avatar1.png" class="rounded-circle me-1" alt="Chris Wood" width="40" height="40">
                </div>
                <div class="flex-shrink-1 bg-light rounded py-2 px-3 me-3 w-100">
                    <div class="font-weight-bold color mb-1">You</div>
                    <div>{{$msg['message']}}</div>
                    <div class="text-muted small text-nowrap text-end mt-2">{{formatTimestamp($msg['created_at'])}}</div>
                </div>
            </div>
            @elseif(auth()->user()->uuid == $msg['user']['user_id'])
            <div class="chat-message-right pb-4 w-75" data-msgid="{{$msg['message_id']}}">
                <div>
                    <img src="https://bootdey.com/img/Content/avatar/avatar1.png" class="rounded-circle me-1" alt="Chris Wood" width="40" height="40">
                </div>
                <div class="flex-shrink-1 bg-light rounded py-2 px-3 me-3 w-100">
                    <div class="font-weight-bold color mb-1">You</div>
                    <div>{{$msg['message']}}</div>
                    <div class="text-muted small text-nowrap text-end mt-2">{{formatTimestamp($msg['created_at'])}}</div>
                </div>
            </div>
            @else
            <div class="chat-message-left pb-4 w-75" data-msgid="{{$msg['message_id']}}">
                <div>
                    <img src="https://bootdey.com/img/Content/avatar/avatar3.png" class="rounded-circle me-1" alt="Sharon Lessman" width="40" height="40">
                </div>
                <div class="flex-shrink-1 bg-light rounded py-2 px-3 ms-3 w-100">
                    <div class="font-weight-bold color mb-1">{{$msg['user']['nickname']}}</div>
                    <div>{{$msg['message']}}</div>
                    <div class="text-muted small text-nowrap text-end mt-2">{{formatTimestamp($msg['created_at'])}}</div>
                </div>
            </div>
            @endif
        @endforeach        
    </div>
</div>
<div class="flex-grow-0 py-3 px-4 border-top">
    <div class="input-group">
        <span id="emojiContainer"></span>
        <button id="emojiBtn" class="btn btn-primary">Emoji</button>
        <input type="text" class="form-control border chat-text" placeholder="Type your message">
        <button class="btn btn-primary btn-send">Send</button>
    </div>
</div>