@extends('layouts.main')
@section('title', 'Nomadic-Discuss')
@section('content')
<section>
  <div class="container mt-4">

    <div class="card">
      <div class="row g-0">
        <div class="col-12 col-lg-5 col-xl-3">
          <div class="py-3 px-4 border-bottom">
            <div class="d-flex align-items-center py-1"><strong>Your Channels</strong></div>
          </div>
          <div id="channelList" style="height:400px;overflow-y:auto;">
            <div class="d-flex justify-content-center mt-5">
              <div class="spinner-border" role="status">
                <span class="visually-hidden">Loading...</span>
              </div>
            </div>
          </div>
          <hr class="d-block d-lg-none mt-1 mb-0">
        </div>
        <div class="col-12 col-lg-7 col-xl-9 border-left">
          <div class="py-2 px-4 border-bottom d-none d-lg-block" style="min-height:65px;">
            <div class="d-flex align-items-center py-1">
              <div class="position-relative">
              <span id="channel_pic"></span>
              </div>
              <div class="flex-grow-1 ps-3">
                <strong id="channel_name"></strong>
                <!-- <div class="text-muted small"><em>Typing...</em></div> -->
              </div>
            </div>
          </div>
          <div id="chat_data">
            <div class="position-relative">
              <div class="chat-messages p-4" style="text-align:center;min-height:300px">
                <b>Select channel to participate..</b>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>
@endsection

@section('footer_scripts')
<link rel="stylesheet" href="{{asset('css/font-awesome.min.css')}}">
<link rel="stylesheet" href="{{asset('css/chat.css')}}">
<script src="https://unpkg.com/axios/dist/axios.min.js"></script>
<script type="text/javascript" src="{{asset('sendbird/sendbird.min.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/emoji-mart@latest/dist/browser.js"></script>
<script>
var sb, user, channel, channelHandler, channelHandlerId;
var APP_ID = "{{env('SENDBIRD_APP_ID')}}";
var USER_ID = "{{auth()->user()->uuid}}";
var SENDBIRD_TOKEN = "{{session()->get('sendbird_token')}}";

async function connectToSendBird(USER_ID, SENDBIRD_TOKEN) {
  try{
    console.log(USER_ID);console.log(SENDBIRD_TOKEN);
    user = await sb.connect(USER_ID, SENDBIRD_TOKEN);
    console.log(user);
    
    // Handling disconnection events (token expiry detection)
    sb.onReconnectStarted = function () {
      console.log('Reconnection started...');
    };

    sb.onReconnectSucceeded = function () {
      console.log('Reconnection successful!');
    };

    sb.onReconnectFailed = function () {
      console.log('Reconnection failed. Token might be expired.');
      // Here, prompt the backend for a new session token
      handleSessionTokenExpired();
    };
    
    // Get channels list
    fetchChannels();
    fetchGroupChannels();

  }catch(err){
    console.log(err);
    handleSessionTokenExpired();
  }
}

function handleSessionTokenExpired() {
  $.ajax({
    type: 'POST',
    dataType: 'json',
    data: {_token:_token},
    url: APP_URL+"/sendbird-token",
    success: function(res) {
      if(res.status){
        SENDBIRD_TOKEN = res.sbtoken;
        connectToSendBird(USER_ID, SENDBIRD_TOKEN);      
      }
    },
    error: function(res) {                    
      ajax_error(res);
    }
  });
}

async function fetchChannels(){
  const params = {limit:20};
  const query = sb.openChannel.createOpenChannelListQuery(params); 
  if (query.hasNext) { 
    const open_channels = await query.next();
    list_channels(open_channels, 'open_channels');
  }
}

async function fetchGroupChannels() {
  try {
    // Create a GroupChannel list query
    const listQuery  = sb.groupChannel.createMyGroupChannelListQuery();
    listQuery.includeEmpty = true;

    // Fetch channels asynchronously
    const group_channels = await listQuery.next();
    console.log('Group Channels:', group_channels);
    list_channels(group_channels, 'group_channels');
    
  } catch (error) {
    console.error('Error:', error);
  }
}

function list_channels(channels, type){
  let listHtml = '';
  for(let i = 0; i < channels.length; i++){
    listHtml += '<a class="list-group-item list-group-item-action border-0 pointer channels" data-type="'+type+'" data-url="'+channels[i]._url+'" data-cover="'+channels[i].coverUrl+'" data-name="'+channels[i]._name+'">'+
      '<div class="d-flex align-items-start">'+
        '<img src="'+channels[i].coverUrl+'" class="rounded-circle mr-1" alt="'+channels[i]._name+'" width="40" height="40">'+
        '<div class="flex-grow-1 ms-2 mt-2 name">'+channels[i]._name+'</div>'+
      '</div>'+
    '</a>';
  }
  if($('#channelList .spinner-border').length > 0){
    $('#channelList').html(listHtml);
  }else{
    $('#channelList').append(listHtml);
  }
  
}

async function flush(){
  sb.removeChannelHandler(channelHandlerId);
}

async function enterChannel(CHANNEL_URL, TYPE){
  channelHandlerId = 'unique-handler-id-'+Date.now();

  if(TYPE=="open_channels"){
    channel = await sb.openChannel.getChannel(CHANNEL_URL);
    await channel.enter();
    console.log('Entered the channel successfully');
    
    // setup channel handeler
    channelHandler = {
      // Triggered when a new message is received in the Open Channel
      onMessageReceived: function(channel, message) {
        let created_at = formatTimestamp(message.createdAt);
        console.log('Message:', message);
        let newHtml = '<div class="chat-message-left pb-4 w-75" data-msgid="'+message.messageId+'">'+
            '<div>'+
                '<img src="https://bootdey.com/img/Content/avatar/avatar3.png" class="rounded-circle me-1" alt="Sharon Lessman" width="40" height="40">'+
            '</div>'+
            '<div class="flex-shrink-1 bg-light rounded py-2 px-3 ms-3 w-100">'+
                '<div class="font-weight-bold color mb-1">'+message.sender.nickname+'</div>'+
                '<div>'+message.message+'</div>'+
                '<div class="text-muted small text-nowrap text-end mt-2">'+created_at+'</div>'+
            '</div>'+
        '</div>';
        $('.chat-messages').append(newHtml).scrollTop($('.chat-messages').prop("scrollHeight"));
      }
    };

    await sb.openChannel.addOpenChannelHandler(channelHandlerId, channelHandler);
  
  }else if(TYPE=="group_channels"){
    
      channel = await sb.groupChannel.getChannel(CHANNEL_URL);

      // Create a new GroupChannelHandler
      channelHandler = new Sendbird.GroupChannelHandler();

      // Handle message received event
      channelHandler.onMessageReceived = (channel, message) => {
        console.log('Message received:', message);
        let created_at = formatTimestamp(message.createdAt);
        console.log('Message:', message);
        let newHtml = '<div class="chat-message-left pb-4 w-75" data-msgid="'+message.messageId+'">'+
            '<div>'+
                '<img src="https://bootdey.com/img/Content/avatar/avatar3.png" class="rounded-circle me-1" alt="Sharon Lessman" width="40" height="40">'+
            '</div>'+
            '<div class="flex-shrink-1 bg-light rounded py-2 px-3 ms-3 w-100">'+
                '<div class="font-weight-bold color mb-1">'+message.sender.nickname+'</div>'+
                '<div>'+message.message+'</div>'+
                '<div class="text-muted small text-nowrap text-end mt-2">'+created_at+'</div>'+
            '</div>'+
        '</div>';
        $('.chat-messages').append(newHtml).scrollTop($('.chat-messages').prop("scrollHeight"));
      };  
      await sb.groupChannel.addGroupChannelHandler(channelHandlerId, channelHandler);
  }

  console.log('Handler added successfully');

}

function formatTimestamp(timestamp) {
    // Convert timestamp to seconds (since JavaScript uses seconds, not milliseconds)
    timestamp = timestamp / 1000;

    // Create a new Date object
    const date = new Date();

    // Format today's date as YYYY-MM-DD
    const today = date.toISOString().split('T')[0];
    
    // Set date to yesterday
    const yesterday = new Date(date);
    yesterday.setDate(date.getDate() - 1);
    const yesterdayString = yesterday.toISOString().split('T')[0];

    // Convert the timestamp to a Date object
    const timestampDate = new Date(timestamp * 1000);
    const timestampString = timestampDate.toISOString().split('T')[0];

    // Check if the timestamp is today, yesterday, or earlier
    if (today === timestampString) {
        return timestampDate.toLocaleTimeString([], {hour: '2-digit', minute: '2-digit', hour12: true}) + ", Today";
    } else if (yesterdayString === timestampString) {
        return timestampDate.toLocaleTimeString([], {hour: '2-digit', minute: '2-digit', hour12: true}) + ", Yesterday";
    } else {
        return timestampDate.toLocaleString('en-US', {
            hour: '2-digit',
            minute: '2-digit',
            hour12: true,
            day: 'numeric',
            month: 'short'
        });
    }
}

async function sendMessage(message){
  await channel.sendUserMessage({
    message: message
  });
}

$(document).ready(function (){
  try{
    // Initialised sendbird
    var {
      SendbirdChat,
      OpenChannelModule,
      GroupChannelModule
    } = Sendbird;

    sb = SendbirdChat.init({
      appId: APP_ID,
      modules: [
          new OpenChannelModule(),
          new GroupChannelModule()
      ],
    });

    // Initialised user
    connectToSendBird(USER_ID, SENDBIRD_TOKEN);  
    
  }catch (err) {
    console.log(err);
  }

  $(document).on('click', '#emojiBtn', function(){
    $('#emojiContainer').toggle();
  });
  $(document).on('click', '.channels', function(){
    $('.channels').removeClass('active');
    $(this).addClass('active');
    let type = $(this).data('type');
    let url = $(this).data('url');
    let cover = $(this).data('cover');
    let name = $(this).data('name');
    $('#channel_name').html(name);
    $('#channel_pic').html('<img src="'+cover+'" class="rounded-circle mr-1" width="40" height="40" alt="avatar"/>');
    
    $.ajax({
      type: 'POST',
      dataType: 'json',
      data: {_token:_token, channel_type:type, channel_url:url},
      url: APP_URL+"/messages",
      success: function(res) {
        if(res.status){
            $('#chat_data').html(res.content);
            $('.chat-messages').scrollTop($('.chat-messages').prop("scrollHeight"));
            // Set up the emoji picker
            const emojiPicker = new EmojiMart.Picker({
              onEmojiSelect: (emoji) => {
                console.log(emoji);
                const inputField = $('.chat-text').val() + emoji.native;
                $('.chat-text').val(inputField);
              }
            });
            $('#emojiContainer').html(emojiPicker);
            enterChannel(url, type);
        }
      },
      error: function(res) {                    
        ajax_error(res);
      }
    });
  });

  $(document).on('click', '.btn-send', function(){
    let txt = $.trim($('.chat-text').val());
    $('.chat-text').val('');
    if(txt==""){
      return false;
    }
    let type = $('.channels.active').data('type');
    let url = $('.channels.active').data('url');
    //let currentTime = new Date().toLocaleTimeString();
    const now = new Date();  
    let currentTime = formatTime(now);
    let tmpmsgid = Date.now();
    let message = '<div class="chat-message-right pb-4 w-75" id="id_'+tmpmsgid+'">'+
        '<div>'+
            '<img src="https://bootdey.com/img/Content/avatar/avatar1.png" class="rounded-circle me-1" alt="You" width="40" height="40">'+
        '</div>'+
        '<div class="flex-shrink-1 bg-light rounded py-2 px-3 me-3 w-100">'+
            '<div class="font-weight-bold color mb-1">You</div>'+
            '<div>'+txt+'</div>'+
            '<div class="text-muted small text-nowrap text-end mt-2">'+currentTime+', Today</div>'+
        '</div>'+
    '</div>';
    $('.chat-messages').append(message);
    $('.chat-messages').scrollTop($('.chat-messages').prop("scrollHeight"));
    sendMessage(txt);
  });

});
</script>
  
  @endsection