@extends('layouts.sidebar')
@section('title', 'Nomadic-Studios')
@section('content')
<div class="pagetitle">
  <h1 class="float-start">Local Studio Pages</h1>
  <a class="btn btn-primary float-end" href="{{url('backend/studio-landing-page/'.$locId)}}"><i class="bi bi-plus"></i> Create Local Studio Page</a>
</div>

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search" value="@if(request()->get('name')){{request()->get('name')}}@endif">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Name</td>
                <td>Studio Type</td>
                <td>Manager</td>
                <td>Team Size</td>
                <td>Equipment Quantity</td>
                <td>Status</td>
              </tr>
            </thead>
            <tbody>
              @if(!empty($data) && $data->count())
                @foreach($data as $dt)
                <tr>
                  <td>{{ucfirst($dt->name)}}</td>
                  <td>{{$dt->type}}</td>
                  <td>Martin Roser</td>
                  <td>20</td>
                  <td>14</td>
                  <td>
                    <a href="{{url('backend/studio-landing-page/'.$dt->location_id.'/'.$dt->id)}}"><i class="bi bi-pencil"></i></a>
                  </td>
                </tr>
                @endforeach
              @else
              <tr>
                <td colspan="6">No record found</td>
              </tr>  
              @endif
            </tbody>
          </table>
        </div>
      </div>

    </div>

  </div>
</section>
@endsection