@extends('layouts.sidebar')
@section('title', 'Nomadic-Manage News')
@section('content')
<div class="pagetitle">
  <h1 class="float-start">Manage News</h1>
  <a class="btn btn-primary float-end" href="{{url('backend/news/'.$locId)}}"><i class="bi bi-plus"></i> Create News</a>
</div>

<section class="section profile">
  @if(session()->has('success'))
  <div class="alert alert-success">{{session()->get('success')}}</div>
  @endif
  @if(session()->has('error'))
  <div class="alert alert-danger">{{session()->get('error')}}</div>
  @endif
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search" value="@if(request()->get('name')){{request()->get('name')}}@endif">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Date</td>
                <td>Title</td>
                <td>Tags</td>
                <td>CreatedBy</td>
                <td>UpdatedBy</td>
                <td>Action</td>
              </tr>
            </thead>
            <tbody>
              @if($data->count()>0)
                @foreach($data as $dt)
                <tr>
                  <td>{{date('d M Y',strtotime($dt->created_at))}}</td>
                  <td>{{ucfirst($dt->name)}}</td>
                  <td>{{$dt->tags}}</td>
                  <td>@if($dt->createdBy) {{$dt->createdBy->fname}} {{$dt->createdBy->lname}} @endif</td>
                  <td>@if($dt->updatedBy) {{$dt->updatedBy->fname}} {{$dt->updatedBy->lname}} @endif</td>
                  <td>
                    <a href="{{url('backend/news/'.$dt->location_id.'/'.$dt->id)}}"><i class="bi bi-pencil"></i></a>
                    <a class="delete-record pointer" data-url="{{url('backend/delete-news/'.$dt->location_id.'/'.$dt->id)}}"><i class="bi bi-trash"></i></a>
                  </td>
                </tr>
                @endforeach
              @else
              <tr>
                <td colspan="6">No record found</td>
              </tr>  
              @endif
            </tbody>
            <tfoot>
              <tr>
                <td colspan="6">
                  <div class="foot-paging">
                    {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

  </div>
</section>
@endsection