@extends('layouts.sidebar')
@section('title', 'Nomadic-News')
@section('content')
<div class="pagetitle">
  <h1>@if(isset($news->id))Update @else Create @endif news</h1>
</div>

<section class="section profile">
  <div class="col-xl-12">
    <input type="hidden" id="newsid" name="newsid" value="@if(isset($news->id)){{$news->id}}@endif" readonly>
    <input type="hidden" id="type" name="type" value="news" readonly>
    <input type="hidden" id="location_id" name="location_id" value="{{$locationId}}" readonly>

    @if(session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
    
    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Banner Picture</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div id="dispbannerimg" class="mb-3">
          @if(isset($news->banner) && $news->banner!="")
          <img src="{{asset('storage/location/news')}}/{{$news->banner}}" class="img-fluid w-75" style="border-radius:5px;">
          @endif
        </div>
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="{{url('fileupload')}}" method="post" enctype="multipart/form-data" id="banner_picture" class="dropzone">
                  @csrf
                  <input type="hidden" name="image_type" value="banner" readonly>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Name</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="name" placeholder="Name" value="@if(isset($news->name)){{$news->name}}@endif" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Tags</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="tags" placeholder="Tags" value="@if(isset($news->tags)){{$news->tags}}@endif" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Heading for Introduction</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="heading_intro" placeholder="Introduction" value="@if(isset($news->heading_intro)){{$news->heading_intro}}@endif" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Paragraph for Introduction</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="quill-editor-default" class="quill-editor-default" style="height:100px;">@if(isset($news->para_intro)){{$news->para_intro}}@endif</textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Heading for Elaboration</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="heading_elaboration" placeholder="Elaboration" value="@if(isset($news->heading_elaboration)){{$news->heading_elaboration}}@endif" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Paragraph for Elaboration</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="quill-editor-default2" class="quill-editor-default2" style="height:100px;">@if(isset($news->para_elaboration)){{$news->para_elaboration}}@endif</textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Conclusion Picture</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div id="dispconclusionimg" class="mb-3">
          @if(isset($news->conclusion_picture) && $news->conclusion_picture!="")
          <img src="{{asset('storage/location/news')}}/{{$news->conclusion_picture}}" class="img-fluid w-75" style="border-radius:5px;">
          @endif
        </div>
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="{{url('fileupload')}}" method="post" enctype="multipart/form-data" id="conclusion_picture" class="dropzone">
                  @csrf
                  <input type="hidden" name="image_type" value="conclusion" readonly>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Heading for Conclusion</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="heading_conclusion" placeholder="Conclusion" value="@if(isset($news->heading_conclusion)){{$news->heading_conclusion}}@endif" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Paragraph for Conclusion</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="quill-editor-default3" class="quill-editor-default3" style="height:100px;">@if(isset($news->para_conclusion)){{$news->para_conclusion}}@endif</textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="row mt-3">
      <div class="col-md-12 text-center">
        <input id="btn_savenews" type="button" class="btn btn-primary mb-2 mt-4" value="Save news">
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<script src="https://cdn.tiny.cloud/1/7oxmjjhuf38181ubsazv0hcwhi602g0gw8bbalyo8kvqttzl/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  tinyMCE.init({
    selector: 'textarea#quill-editor-default, textarea#quill-editor-default2, textarea#quill-editor-default3',
    plugins: 'anchor autolink link code',
    menubar: '',
    toolbar: 'bold italic underline link bullist code',
  });
</script>
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script src="{{asset('js/cropper.js')}}"></script>
<link href="{{asset('css/cropper.css')}}" rel="stylesheet">
<script>
  Dropzone.autoDiscover = false;
  var myDropzone = new Dropzone("#banner_picture",{ 
      maxFiles: 1,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        let aRatio = 16/9;
        cropperImageFunc(file, done, this, aRatio, 1280, 720);
      }
  });
  myDropzone.on("sending", function(file, xhr, formData) {
    formData.append("type", $('#type').val());  
    formData.append("newsid", $('#newsid').val());
    formData.append("location_id", $('#location_id').val());
  });
  myDropzone.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone.on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      $('#newsid').val(response.newsid);
      $('#dispbannerimg').html('<img src="'+APP_URL+'/'+response.imgurl+'" class="img-fluid w-75" style="border-radius:5px;">');
      myDropzone.removeAllFiles(true);
  });

  // conclusion
  var myDropzone2 = new Dropzone("#conclusion_picture",{ 
      maxFiles: 1,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        let aRatio = 16/9;
        cropperImageFunc(file, done, this, aRatio, 627, 418);
      }
  });
  myDropzone2.on("sending", function(file, xhr, formData) {
    formData.append("type", $('#type').val());
    formData.append("newsid", $('#newsid').val());
    formData.append("location_id", $('#location_id').val());
  });
  myDropzone2.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone2.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone2.on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      $('#newsid').val(response.newsid);
      $('#dispconclusionimg').html('<img src="'+APP_URL+'/'+response.imgurl+'" class="img-fluid w-75" style="border-radius:5px;">');
      myDropzone.removeAllFiles(true);
  });
   
  $(document).ready(function () {
    $(document).on('click','#btn_savenews',function(){
      let newsid = $('#newsid').val();
      let location_id = $('#location_id').val();
      let name = $('input[name="name"]').val();
      let tags = $('input[name="tags"]').val();
      let heading_intro = $('input[name="heading_intro"]').val();
      let para_intro = tinyMCE.get('quill-editor-default').getContent();
      let heading_elaboration = $('input[name="heading_elaboration"]').val();
      let para_elaboration = tinyMCE.get('quill-editor-default2').getContent();
      let heading_conclusion = $('input[name="heading_conclusion"]').val();
      let para_conclusion = tinyMCE.get('quill-editor-default3').getContent();
      
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, newsid:newsid, location_id:location_id, name:name, tags:tags, heading_intro:heading_intro, para_intro:para_intro, heading_elaboration:heading_elaboration, para_elaboration:para_elaboration, heading_conclusion:heading_conclusion, para_conclusion:para_conclusion},
        url: APP_URL+"/backend/save-news/"+location_id,
        success: function(res) {
          if(res.status){
            window.location.href = APP_URL+'/backend/news/'+location_id+'/'+res._id;
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
  });
</script>
@endsection