@extends('layouts.main')
@section('title', 'Booking | Select studio')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Create something with us!')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/booking-banner.png')}}">
</div>

<section>
    <div class="container text-dark" data-aos="fade-up">
        <div class="row">
            <div class="col-md-12">
                <img class="img-fluid w-100" src="{{asset('images/booking-image.png')}}">
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-12 text-center">
                <h5>Congratulations!</br></br>Your booking is confirmed.</h5>
            </div>
        </div>
    </div>

    <h5 class="ps-3 mt-3">Details</h5>
    <div class="container text-dark" data-aos="fade-up">
        <div class="row mt-3">
            <h5>Location</h5>
            <div class="col-md-2">
                <img class="img-fluid w-100" src="{{url('storage/location/'.$booking->banner_picture)}}">
            </div>
            <div class="col-md-2">{{$booking->location}}</div>
        </div>

        <h5 class="mt-3">Date</h5>
        <div>{{date('d M, Y', strtotime($booking->start_date))}} {{date('g:i A',strtotime($booking->start_time))}} - {{date('d M, Y', strtotime($booking->end_date))}} {{date('g:i A',strtotime($booking->end_time))}}</div>

        @foreach($bookings as $book)
            @if($book->type=='studio')
            <h5 class="mt-3">Type of studio</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <img class="img-fluid w-100" src="{{url('storage/location/thumb_'.$studio->landingPage->banner_picture)}}">
                </div>
                <div class="col-md-3">
                    <h5>{{$studio->name}}</h5>
                    <div class="mt-3">{!! $studio->landingPage->description !!}</div>
                </div>
                <div class="col-md-3">
                    @php $data = json_decode($book->data) @endphp
                    @if(isset($data->daily))
                        @foreach($data->daily as $daily)
                        <div class="row">
                            <div class="col-md-6 text-muted">{{$daily}}pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= {{$daily}} pts</div>
                        </div>
                        @endforeach
                    @endif
                    @if(isset($data->hourly))
                        @foreach($data->hourly as $hr)
                        @php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        @endphp
                        <div class="row">
                            <div class="col-md-6 text-muted">{{$hourly_points}}pts x {{$hourly_data[0]}}hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= {{$hourly_data[1]}} pts</div>
                        </div>
                        @endforeach
                    @endif
                </div>
            </div>
            @endif

            @if($book->type=='rental')
            <h5 class="mt-3">Equipment</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <img class="img-fluid w-100" src="{{url('storage/rental/'.$equipment->photo)}}">
                </div>
                <div class="col-md-3">
                    <h5>{{$equipment->name}}</h5>
                    <div class="mt-3">{!! $equipment->description !!}</div>
                </div>
                <div class="col-md-3">
                    @php $data = json_decode($book->data) @endphp
                    @if(isset($data->daily))
                        @foreach($data->daily as $daily)
                        <div class="row">
                            <div class="col-md-6 text-muted">{{$daily}}pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= {{$daily}} pts</div>
                        </div>
                        @endforeach
                    @endif
                    @if(isset($data->hourly))
                        @foreach($data->hourly as $hr)
                        @php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        @endphp
                        <div class="row">
                            <div class="col-md-6 text-muted">{{$hourly_points}}pts x {{$hourly_data[0]}}hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= {{$hourly_data[1]}} pts</div>
                        </div>
                        @endforeach
                    @endif
                </div>
            </div>
            @endif

            @if($book->type=='resource')
            <h5 class="mt-3">Additional support</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    @if(is_null($resource->profile_pic))
                    <img class="img-fluid w-100" src="{{asset('images/user-img.png')}}">
                    @else
                    <img class="img-fluid w-100" src="{{url('storage/profile-pic/'.$resource->profile_pic)}}">
                    @endif
                </div>
                <div class="col-md-3">
                    <h5>{{$resource->fname}} {{$resource->lname}}</h5>
                    @if(isset($resource->resourceName->name))<h5 class="txtgray">{{$resource->resourceName->name}}</h5>@endif
                    <div class="mt-3">{!! $resource->description !!}</div>
                </div>
                <div class="col-md-3">
                    @php $data = json_decode($book->data) @endphp
                    @if(isset($data->daily))
                        @foreach($data->daily as $daily)
                        <div class="row">
                            <div class="col-md-6 text-muted">{{$daily}}pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= {{$daily}} pts</div>
                        </div>
                        @endforeach
                    @endif
                    @if(isset($data->hourly))
                        @foreach($data->hourly as $hr)
                        @php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        @endphp
                        <div class="row">
                            <div class="col-md-6 text-muted">{{$hourly_points}}pts x {{$hourly_data[0]}}hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= {{$hourly_data[1]}} pts</div>
                        </div>
                        @endforeach
                    @endif
                </div>
            </div>
            @endif
        @endforeach

        <div class="row mt-5 pt-4 ps-4 pe-4" style="border-top:1px solid;">
            <div class="col-md-6"><h5>Booking cost</h5></div>
            <div class="col-md-6 text-end"><h5>{{$booking->total_points}} pts</h5></div>
        </div>
        <div class="row mt-3 ps-4 pe-4">
            <div class="col-md-6"><h5>Points left</h5></div>
            <div class="col-md-6 text-end"><h5>{{session()->get('point_balance')}} pts</h5></div>
        </div>

        <div class="row mt-4 mb-4">
            <div id="cancl_book_cont" class="col-md-12 text-center">
                @if($booking->status==0)
                    @php $booking_time = strtotime($booking->end_date.' '.$booking->end_time); @endphp
                    @if(time() > $booking_time)
                    <b>Not marked as complete</b>
                    @else
                        <a class="btn btn-dark w-30 me-5" href="{{url('invite-guest/booking/'.$bookingId)}}"> Invite guest</a>
                        <input type="button" class="btn btn-danger w-30 cancel-booking" data-booking="{{$bookingId}}" value="Cancel booking" />
                    @endif
                @elseif($booking->status==1) <b>Booking Completed</b>
                @elseif($booking->status==2) <b>Booking Cancelled</b>
                @endif
            </div>
        </div>
    </div>
</section>
@endsection