@extends('layouts.main')
@section('title', 'Booking | Select Equipment')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Create something with us!')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/booking-banner.png')}}">
</div>

<section>
    <div class="container text-dark" data-aos="fade-up">
        <div class="row">
            <div class="col-md-8">
                @if($equipments->count() > 0)
                <h2 class="mb-4">2. Select equipment you want to rent</h2>
                @foreach($equipments as $equipment)
                <div class="row col-md-12 mt-3 @if(!$equipment->available) text-muted @endif">
                    <div class="col-md-1">
                        <div>
                            <input id="checkbox-{{$loop->index}}" class="checkbox-custom" value="{{$equipment->id}}" name="booking_equipment" type="radio" data-type="equipment" data-days="{{$equipment->booking_days}}" data-hours="{{$equipment->booking_hours}}" @if(session()->has('temp-booking-equipment-selection') && session()->get('temp-booking-equipment-selection')==$equipment->id)checked @endif @if(!$equipment->available) disabled @endif>
                            <label for="checkbox-{{$loop->index}}" class="checkbox-custom-label"></label>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <h3>{{$equipment->name}}</h3>
                        @if(isset($equipment->resourceTypes->name))<p class="fw-bold c-red text-center mt-4">Require {{$equipment->resourceTypes->name}}</p>@endif
                        @if($equipment->description)
                        <div class="mt-2">{{$equipment->description}}</div>
                        @endif
                        @if(!$equipment->available)
                        <p>equipment is booked at this time please select different time. <span class="text-primary pointer check-availability">check availability</span></p>
                        <div class="availability-calendar" data-id="{{$equipment->id}}" data-type="equipment"></div>
                        @endif
                    </div>
                    <div class="col-md-2">
                        <h3>{{$equipment->equipment_points}}pts</h3>
                    </div>
                    <div class="col-md-4">
                        <div class="imgbox">
                            <img src="{{url('storage/rental/'.$equipment->photo)}}" class="imgfluidlogged @if(!$equipment->available) opacity-50 @endif" />
                        </div>
                    </div>
                </div>
                @endforeach
                <div class="row col-md-12 mt-5">
                    <div class="foot-paging">
                    {!! $equipments->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                    </div>
                </div>
                @else
                <h2 class="mt-4">Equipments are not available this time.</h2>
                @endif
            </div>
            <div class="col-md-4 p-0">
                @include('frontend.booking.booking-form')
            </div>
        </div>
    </div>
</section>
@endsection

@section('footer_scripts')
<script>
    $(document).ready(function () {
        
    });
</script>
@endsection
