@extends('layouts.main')
@section('title', 'Booking | Select studio')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Create something with us!')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/booking-banner.png')}}">
</div>

<section>
    <div class="container text-dark" data-aos="fade-up">
        <div class="row">
            <div class="col-md-8">
                @if($studios->count() > 0)
                <h2 class="mb-4">1. Select type of studio</h2>
                @foreach($studios as $studio)
                <div class="row col-md-12 mt-3 @if(!$studio->available) text-muted @endif">
                    <div class="col-md-1">
                        <div>
                            <input id="checkbox-{{$loop->index}}" class="checkbox-custom" value="{{$studio->id}}" name="booking_studio" type="radio" data-type="studio" data-days="{{$studio->booking_days}}" data-hours="{{$studio->booking_hours}}" @if(session()->has('temp-booking-studio-selection') && session()->get('temp-booking-studio-selection')==$studio->id)checked @endif @if(!$studio->available) disabled @endif>
                            <label for="checkbox-{{$loop->index}}" class="checkbox-custom-label"></label>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <h3>{{$studio->name}}</h3>
                        @if(!$studio->available)
                        <p>studio is booked at this time please select different time. <span class="text-primary pointer check-availability">check availability</span></p>
                        <div class="availability-calendar" data-id="{{$studio->id}}" data-type="studio"></div>
                        @endif
                    </div>
                    <div class="col-md-2">
                        <h3>{{$studio->studio_points}}pts</h3>
                    </div>
                    <div class="col-md-4">
                        <div class="imgbox">
                            <img src="{{url('storage/location/'.$studio->landingPage->banner_picture)}}" class="imgfluidlogged @if(!$studio->available) opacity-50 @endif" />
                        </div>
                    </div>
                </div>
                @endforeach
                <div class="row col-md-12 mt-5">
                    <div class="foot-paging">
                    {!! $studios->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                    </div>
                </div>
                @else
                <h2 class="mt-4">Studios are not available this time.</h2>
                @endif
            </div>
            <div class="col-md-4 p-0">
                @include('frontend.booking.booking-form')
            </div>
        </div>
    </div>
</section>
@endsection

@section('footer_scripts')
<script>
    $(document).ready(function () {
        
    });
</script>
@endsection
