<div class="container" data-aos="fade-up">
  <h1 class="txtwhite mb-4">Upcoming events</h1>
  <div class="row">
  @if($events->count() > 0)
    @foreach($events as $event)
    <div class="col-md-3 mb-4">
      <div class="position-relative">
        <div class="imgbox">
          <img src="img/upcomingevent/upcoevnt1.jpg" class="imgfluidlogged">
        </div>  
      </div>
      <div class="clearfix"></div>
      <div class="mt-2 mb-2 txtwhite">{{date('l, d M',strtotime($event->event_date))}} AT {{date('h:i A',strtotime($event->event_time))}}</div>
      <div class="clearfix"></div>
      <h4 class="mb-2 txtwhite">{{Str::limit(ucfirst($event->event_title),25)}}</h4>
      <div class="clearfix"></div>
      @if($event->event_type=='online')
      <div class="mb-2 txtwhite">{{$event->event_type}}</div>
      @endif
      @if($event->event_type=='location' && $event->address!='')
      <div class="mb-2 txtwhite">{{$event->address}}</div>
      @endif
      <div class="clearfix"></div>
      <div class="mb-4 txtwhite font13px">{{$event->interested_count}} interested {{$event->going_count}} going</div>
      <div class="clearfix"></div>
      <div class="d-inline position-relative">
        <button type="button" class="btn btnwhite" @if(Auth::guest()) disabled @elseif(isset($event->interested[0]->user_id)) disabled @else onclick="event_action(this,{{$event->event_id}},'interested')" @endif>Interested</button>
        <button type="button" class="btn btnwhite" @if(Auth::guest()) disabled @elseif(isset($event->going[0]->user_id)) disabled @else onclick="event_action(this,{{$event->event_id}},'going')" @endif>Going</button>
        <button type="button" class="btn2 btnwhite d-inline minwidth position-relative" onclick="share({{$event->event_id}})">
          <i class="bi bi-share mlmr"></i>
        </button>
      </div>
    </div>
    @endforeach
  @endif
  </div>    
</div>