@extends('layouts.main')
@section('title', 'Nomadic Studios | Invite your guest')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4">{{__('Invite your guest')}} @if($type && $id) - {{ucfirst($type)}} ({{$id}}) @endif</h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
             @if(session('success'))
            <div class="alert alert-success p-2">{{session('success')}}</div>
            @endif
            <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
            <form action="{{ route('invite.guest.process') }}" method="POST" id="invite" class="w-100">
                @csrf
                <input type="hidden" name="num" value="{{$id}}" readonly>
                <input type="hidden" name="type" value="{{$type}}" readonly>
                <div class="form-container">
                    <div class="form-group mb-2">Select Location</div>
                    <div class="form-group mb-2 position-relative">
                        <select class="form-control shadow-none" @if(isset($loc)) disabled @endif name="location_id" id="txt_location">
                            <option value="">Location</option>
                            @foreach($locations as $key=>$val)
                            <option value="{{$key}}" @if(isset($loc) && $loc==$key) selected @endif>{{$val}}</option>
                            @endforeach
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>

                    <div class="form-group mb-2">Details of your guest</div>
                    <div class="form-group mb-2">
                        <input type="text" id="fname" name="fname" class="form-control shadow-none" placeholder="{{__('First Name')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="text" id="lname" name="lname" class="form-control shadow-none" placeholder="{{__('Last Name')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="email" id="email" name="email" class="form-control shadow-none" placeholder="{{__('Email')}}" />
                    </div>

                    <div class="form-group mb-2">Select Date and Time</div>
                    <div class="form-group mb-2">
                        <input type="date" id="txt_date" name="invitation_date" class="form-control shadow-none" value="{{(isset($start_date)) ? $start_date : ''}}" @if(isset($start_date)) disabled @endif/>
                    </div>
                    <div class="form-group mb-2">
                        <input type="time" name="invitation_time" value="{{(isset($start_time)) ? $start_time : ''}}" class="form-control shadow-none" @if(isset($start_time)) disabled @endif/>
                    </div>

                    <div class="btnconter mt-3 mb-4">
                        <input type="submit" class="btn" name="submit" value="{{__('Invite Guest')}}" />
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<link rel="stylesheet" href="{{asset('css/intlTelInput.css')}}">
<script src="{{asset('js/intlTelInput.js')}}"></script> 
<script>
   
    
    $(document).ready(function () {
       
    });
</script>
@endsection
