@extends('layouts.main')
@section('title', 'Locations')
@section('content')
    <section>
      <div class="row content fade-up">
        <div class="col-md-8">
          <div class="top-heading">
            Live is a journey, <br />where is your next step?
          </div>
        </div>
      </div>
    </section>
    <section>
      <div class="row content">
        <div class="video-image">
          <img class="img-fluid w-100" src="{{asset('images/location-banner.jpg')}}">
        </div>
      </div>
    </section>
    <section>
      <div class="container" data-aos="fade-up">
        <div class="heading1 pb-3">Where you’re staying</div>
        <div class="heading2 pb-5">Locations</div>
        <div class="row">
          <div class="col-md-6">
            <div class="content1 heading4">
              Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent
              tristique leo vitae purus lacinia, ut euismod nulla viverra. Duis
              rutrum fringilla vestibulum. Quisque gravida, tortor eget accumsan
              aliquet.
            </div>
          </div>
          <div class="col-md-6">
            <div class="content2">
              Lorem ipsum dolor sit amet, consectetur adipiscing elit.
              Praesent tristique leo vitae purus lacinia, ut euismod nulla
              viverra. Duis rutrum fringilla vestibulum. <br>Quisque
              gravida, tortor eget accumsan aliquet, turpis urna elementum
              nisl, finibus hendrerit enim dui vel magna. Praesent fringilla
              magna diam, vitae ullamcorper lectus pulvinar eu. Pellentesque
              habitant morbi tristique senectus.
            </div>
          </div>
        </div>
      </div>
    </section>

    <section>
      <div class="container" data-aos="fade-up">
        <div class="row">
          @foreach($locations as $loc)
          @if(strtolower($loc->location)=='global') @continue @endif
          <div class="col-md-6 mb-4 overflow-hidden">
            @if($loc->landing_page)
            <img class="img-fluid w-100 @if($loc->coming_soon==1) opacity-50 @endif" src="{{asset('storage/location/'.$loc->landing_page->banner_picture)}}" />
            @endif
            <div class="heading4 float-start">
            @if($loc->coming_soon==1) {{$loc->location}}
            @else
              <a href="{{url('location/'.$loc->slug)}}">{{$loc->location}}</a>
            @endif
            </div>
            <svg
              class="_252"
              width="24"
              height="25"
              viewBox="0 0 24 25"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z"
                fill="#111111"
              />
            </svg>
          </div>
          @endforeach
        </div>
      </div>
    </section>
@endsection