@extends('layouts.main')
@section('title', 'My Profile')
@section('content')
@if(auth()->user()->role!='guest')
<section class="p-0">
  <div class="row content">
    <div class="video-image">
      <img class="img-fluid w-100" src="{{asset('images/image-1.png')}}" />
      <div class="image-overlay"></div>
      <div class="booking-container text-center">
          <p style="color: #fff;">What you need to create?</p>
          <div class="booking-form m-auto text-left p-3">
            <input type="hidden" id="myemail" value="{{auth()->user()->email}}" readonly>
            <form id="bookingForm">
              @csrf
              <div class="row">
                <div class="col-md-2 position-relative">
                  <h6 class="lblbooking">Where</h6>
                  <select name="txt_location" class="form-control">
                    <option value="">Location</option>
                    @foreach($locations as $loc)
                    <option value="{{$loc->id}}">{{$loc->location}}</option>
                    @endforeach
                  </select>
                  <i class="bi bi-caret-down-fill searchicon" style="top:32px;color:#000000;"></i>
                </div>
                <div class="col-md-2">
                  <h6 class="lblbooking">Start</h6>
                  <input name="txt_start_date" type="date" class="form-control" />
                </div>
                <div class="col-md-2">
                  <h6 class="lblbooking">&nbsp;</h6>
                  <input name="txt_start_time" type="time" class="form-control" />
                </div>
                <div class="col-md-2">
                  <h6 class="lblbooking">End</h6>
                  <input name="txt_end_date" type="date" class="form-control" />
                </div>
                <div class="col-md-2">
                  <h6 class="lblbooking">&nbsp;</h6>
                  <input name="txt_end_time" type="time" class="form-control" />
                </div>
                <div class="col-md-2">
                  <button id="btn_booking_form" type="button" class="btn btn-primary d-block mt27">Search <div class="spinner-border spinner-border-sm text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">Loading...</span></div></button>
                </div>
              </div>
            </form>
          </div>
        </div>
        
      </div>
  </div>
</section>
@endif

<section>
  <div class="container" data-aos="fade-up">
    <div class="row gx-5">
      <div class="col-md-7">
        <div class="heading5 p-2">Upcoming reservations</div>
        <div class="org-line1 mb-4"></div>
        <div class="clearfx"></div>
        @if($bookings->count() > 0)
        <div class="row">
          <div class="col-md-12">
            @foreach($bookings as $book)
            <div class="row">
              <div class="card boxshadow">
                <div class="card-body pt-3">
                  <div class="row">
                    <div class="col-md-4 mb-2 position-relative">
                      <div class="imgbox1">
                        <img class="imgfluidlogged" src="{{url('storage/location/'.$book->locLanding->banner_picture)}}" height="200">
                      </div>
                    </div>
                    <div class="col-md-8 mb-2 position-relative">
                      <label>Date</label>
                      <div class="cleaefix"></div>
                      <div class="fw-bold">
                      {{date('d M, Y', strtotime($book->start_date))}} {{date('g:i A',strtotime($book->start_time))}} - {{date('d M, Y', strtotime($book->end_date))}} {{date('g:i A',strtotime($book->end_time))}}
                      </div>
                      <div class="cleaefix"></div>
                      <table class="table table-borderless">
                        <thead>
                          <tr>
                            <td>Location</td>
                            <td>Studio</td>
                            <td>Equipment</td>
                            <td>Resource</td> 
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <th>{{$book->loc->location}}</th>
                            <th>@if($book->studioNum) Y @endif</th>
                            <th>@if($book->equipNum) Y @endif</th>
                            <th>@if($book->resourceNum) Y @endif</th>
                          </tr>
                          <tr>
                            <th colspan="3">
                              <label class="fw-bold">{{$book->total_points}} pts</label>
                            </th>
                            <th>
                              <a href="{{url('booking-confirmed/'.$book->booking_id)}}" style="color:#000000;">See Detail
                                <svg class="_252" width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
                                </svg>
                              </a>
                            </th>
                          </tr>            
                        </tbody>
                      </table>
                    </div>
                  </div>        
                </div>
              </div>
            </div>
            @endforeach
            <div>
              <a href="{{url('booking-list')}}" style="color:#000000;">See All
                <svg class="_252" width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
              </svg>
              </a>
            </div>
          </div>
        </div>
        @else
        <div class="row">
          <div class="col-md-8 mx-auto">
            <div class="row">
              <div class="col-md-4" style="margin-top:100px;">
                <img src="{{asset('images/profile-1.png')}}" class="img-fluid" />
              </div>
              <div class="col-md-4" style="margin-top:100px;">
                <img src="{{asset('images/profile-2.png')}}" class="img-fluid" />
              </div>
              <div class="col-md-4 mt-2">
                <img src="{{asset('images/profile-3.png')}}" class="img-fluid" />
              </div>
            </div>
            <div class="row mt-4">
              <div class="col-md-8 mx-auto text-center">
                <h5>What you need to create</h5>
                <button type="button" class="btn btn-primary mt-2">Create booking </button>
              </div>
            </div>
          </div>
        </div>
        @endif
      </div>
      <div class="col-md-5">
        <div class="heading5 p-2">Guest invitations</div>
        <div class="org-line1 mb-4"></div>
        <div class="clearfx"></div>
        @if($invitations->count() > 0)
          <div class="row">
            <div class="col-md-12">
              @foreach($invitations as $inv)
              <div class="row">
                <div class="card boxshadow height165 invitedcard pointer" data-id="{{$inv->id}}">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-4 mb-2 position-relative">
                        <div class="imgbox150">
                          @if($inv->profile_pic)
                          <img src="{{asset('storage/profile-pic')}}/{{$data->profile_pic}}" class="imgfluidlogged">
                          @else
                          <img src="{{asset('images/user-img.png')}}" class="imgfluidlogged">
                          @endif
                        </div>
                      </div>
                      <div class="col-md-8 mb-2 position-relative">
                        <label>Date</label>
                        <div class="cleaefix"></div>
                        <div class="fw-bold">{{date('g:i A',strtotime($inv->invitation_time))}}, {{date('d M Y', strtotime($inv->invitation_date))}}</div>
                        <div class="cleaefix"></div>
                        <table class="table table-borderless">
                          <thead>
                            <tr>
                              <td>Location</td>
                              <td>Invited By</td>
                            </tr>
                          </thead>
                          <tbody>
                            <tr>
                              <th>{{ucfirst($inv->location->location)}}</th>
                              <th>{{ucfirst($inv->fname)}} {{ucfirst($inv->lname)}}</th>
                            </tr>
                          </tbody>
                        </table>
                      </div>
                    </div>        
                  </div>
                </div>
              </div>
              @endforeach
            </div>
          </div>
          @if($invcount > 3)
          <a href="{{url('invitations')}}" style="color:#000000;">See All
            <svg class="_252" width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
            </svg>
          </a>
          @endif
        @else
          @if(auth()->user()->role=='member')
          <div class="row">
            <div class="col-md-8 mx-auto">
              <div class="text-center">
                <img src="{{asset('images/avatar-1.png')}}" class="img-fluid" />
                <img src="{{asset('images/avatar-3.png')}}" class="img-fluid avtr3" />
                <img src="{{asset('images/avatar-2.png')}}" class="img-fluid avtr2" />
              </div>
              <div class="row mt-4">
                <div class="col-md-12 text-center">
                  <h5>Do you want to bring guest?</h5>
                  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent tristique leo vitae purus lacinia, ut euismod nulla viverra. Duis rutrum fringilla vestibulum. Quisque gravida, tortor eget accumsan aliquet.</p>
                  <a class="btn btn-primary mt-3" href="{{url('invite-guest')}}">Invite Guest </a>
                  <a class="btn btn-primary ms-3 mt-3" href="{{url('invited-guest')}}">Guest List</a>
                </div>
              </div>
            </div>
          </div>
          @else
          <div class="row">
            <div class="col-md-12 text-center">
              <p>No pending invitation.</p>
            </div>
          </div>
          @endif
        @endif
      </div>
    </div>
  </div>
</section>

<section class="p-0">
  <div class="container" data-aos="fade-up">
    <div class="row gx-5">
      <div class="col-md-8">
        <div class="heading5 p-2">Related news</div>
        <div class="org-line1 mb-4"></div>
        <div class="clearfx"></div>
        <div class="row">
        @if($related_news)
          @foreach($related_news as $rnews)
          <div class="col-md-4">
            <div class="card boxshadow">
              <div class="card-body pt-3">
                <div class="col-md-12 mb-2 position-relative">
                  <img src="{{asset('storage/location/news/'.$rnews->conclusion_picture)}}" class="img-thumbnail rounded-0 p-0">
                  <div class="clearfix"></div>
                  <small class="mt-2 mb-2 d-block text-success">{{Str::limit($rnews->tags,20)}}</small>
                  <div class="clearfix"></div>
                  <div class="float-start">
                    <h5>{{Str::limit($rnews->name,20)}}</h5>
                  </div>
                  <div class="float-end">
                  <a href="{{url('view-news/'.$rnews->id)}}" style="color:#000000;"><i class="bi bi-arrow-up-right" style="cursor:pointer;"></i></a>
                  </div>
                  <div class="clearfix"></div>
                  <p class="mb-2 d-block font13px">{{Str::limit($rnews->heading_intro,30)}}</p>
                  <div class="clearfix"></div>
                  <div class="d-inline">
                    @if($rnews->createdBy->profile_pic)
                    <img src="{{asset('storage/profile-pic/'.$rnews->createdBy->profile_pic)}}" alt="Profile" class="rounded-circle height35">
                    @else
                    <img src="{{asset('images/user-img.png')}}" alt="Profile" class="rounded-circle height35">
                    @endif
                  </div>
                  <div class="d-inline">
                    <span class="font13px" style="font-weight:100;">{{ucfirst($rnews->createdBy->fname)}} {{ucfirst($rnews->createdBy->lname)}}</span>
                    <div class="font12px" style="margin-top:-15px;margin-left:40px;">{{date('d l Y',strtotime($rnews->created_at))}}</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          @endforeach
        @endif
        </div>
      </div>
      <div class="col-md-4">
        <div class="heading5 p-2">Social feed</div>
        <div class="org-line1 mb-4"></div>
        <div class="clearfx"></div>
        <div class="row">
          <div class="col-md-12">
            <div class="card bordertop2">
              <div class="card-body pt-3">
                <div class="col-md-12 mb-2 position-relative">
                  <div class="d-inline">
                    <img src="http://localhost/nomadic/public/images/user-img.png" alt="Profile" class="rounded-circle height35">
                  </div>
                  <div class="d-inline">
                  <b>Nolan Stanton</b> <a class="text-primary">@Nolan Stanton</a><a class="text-primary m-lg-3">25s</a>
                  <div class="clearfix"></div>
                  <div class="font13px offset-1 mb-2">13 Places Where You Can See the Bluest Water in 
                    the World</div>
                  </div>
                  <img src="http://localhost/nomadic/public/img/socialfeed1.jpg" class="imgfluid imgradius">
                  <div class="clearfix"></div>
                  <div class="float-start w-50 mt-3">
                  <div class="d-inline">
                  <i class="bi bi-chat text-primary"></i>
                  <a class="text-primary ms-3 font13px">61</a>
                  <i class="bi bi-repeat ms-3 text-primary"></i>
                  <a class="text-primary ms-3 font13px">12</a>
                  </div>
                  
                  </div>
                  <div class="float-end w-50 mt-3">
                    <div class="d-inline">
                      <i class="bi bi-heart-fill text-danger"></i>
                      <a class="text-danger ms-3 fw-bold font13px">6.2k</a>
                      <i class="bi bi-upload ms-5 text-primary"></i>
                      <a class="text-primary ms-3 font13px">61</a>
                      </div>
                  </div>
                  <div class="clearfix"></div>
                  <small class="mt-2 mb-2 d-block fw-bold text-primary">Show this thread</small>
                  
                </div>
            </div>
          </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="card bordertop2">
              <div class="card-body pt-3">
                <div class="col-md-12 mb-2 position-relative">
                  <div class="d-inline">
                    <img src="http://localhost/nomadic/public/images/user-img.png" alt="Profile" class="rounded-circle height35">
                  </div>
                  <div class="d-inline">
                  <b>Nolan Stanton</b> <a class="text-primary">@Nolan Stanton</a><a class="text-primary m-lg-3">25s</a>
                  <div class="clearfix"></div>
                  <div class="font13px offset-1 mb-2">13 Places Where You Can See the Bluest Water in 
                    the World</div>
                  </div>
                  <img src="http://localhost/nomadic/public/img/socialfeed1.jpg" class="imgfluid imgradius">
                  <div class="clearfix"></div>
                  <div class="float-start w-50 mt-3">
                  <div class="d-inline">
                  <i class="bi bi-chat text-primary"></i>
                  <a class="text-primary ms-3 font13px">61</a>
                  <i class="bi bi-repeat ms-3 text-primary"></i>
                  <a class="text-primary ms-3 font13px">12</a>
                  </div>
                  
                  </div>
                  <div class="float-end w-50 mt-3">
                    <div class="d-inline">
                      <i class="bi bi-heart-fill text-danger"></i>
                      <a class="text-danger ms-3 fw-bold font13px">6.2k</a>
                      <i class="bi bi-upload ms-5 text-primary"></i>
                      <a class="text-primary ms-3 font13px">61</a>
                      </div>
                  </div>
                  <div class="clearfix"></div>
                  <small class="mt-2 mb-2 d-block fw-bold text-primary">Show this thread</small>       
                </div>
            </div>
          </div>
          </div>
        </div>    
        <div class="text-center">
          <button type="button" class="btn2 btnseedetails">See all
            <i class="bi bi-arrow-up-right mlmr"></i>
            </button>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="upcomingeventbg mt-5">
  @include('frontend.event.upcoming-events')
</section>
@endsection

