@extends('layouts.main')
@section('title', 'News')
@section('content')
<section class="p-0">
  <div class="row content">
    <div class="video-image">
      <img class="img-fluid w-100" src="{{asset('images/news-banner.png')}}" />
    </div>
  </div>
</section>

<section>
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-12">
        <div class="heading5 p-2">Discover our news</div>
        <div class="clearfx"></div>
        <div class="btn-group gap-2">
          <input type="date" id="txt_date" class="btn-outline-secondary2 txtcustom" value="{{!empty(app('request')->filterDate) ? app('request')->filterDate : ''}}"/>
          <input type="text" id="txt_tags" class="btn-outline-secondary2 txtcustom" placeholder="Search By Tags" value="{{!empty(app('request')->filterTags) ? app('request')->filterTags : ''}}"/>
        </div> 
        <div class="clearfix"></div>
        <div class="col-md-7 mx-auto">
          <div class="container" data-aos="fade-up">
            @if($newsData->count() > 0)
              @foreach($newsData as $news)
              <div class="row mt-5">
                <div class="col-md-12">
                  <a href="{{url('view-news/'.$news->id)}}"><img src="{{asset('storage/location/news/thumb_'.$news->banner)}}" class="img-thumbnail p-0" /></a>
                  <div class="clearfix"></div>
                  <small class="mt-2 mb-2 d-block text-success">{{$news->tags}}</small>
                  <div class="clearfix"></div>
                  <div class="heading3">{{ucfirst($news->name)}}</div>
                  <div class="clearfix"></div>
                  <p class="mb-2 d-block">{{$news->heading_intro}}</p>
                  <div class="clearfix"></div>
                  <div class="d-inline">
                  @if($news->createdBy->profile_pic)
                  <img src="{{asset('storage/profile-pic/'.$news->createdBy->profile_pic)}}" alt="Profile" class="rounded-circle height35">
                  @else
                  <img src="{{asset('images/user-img.png')}}" alt="Profile" class="rounded-circle height35">
                  @endif
                  </div>
                  <div class="d-inline">
                    <span class="font13px" style="font-weight:100;">
                    {{ucfirst($news->createdBy->fname)}} {{ucfirst($news->createdBy->lname)}}
                    </span>
                    <div class="font12px" style="margin-top:-15px;margin-left:40px;">{{date('d l Y',strtotime($news->created_at))}}</div>
                  </div>
                </div>
              </div>
              @endforeach
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@section('footer_scripts')
<script>
$(document).ready(function () {
  // new filters
  var delayTimerNews;
  $(document).on('keyup','#txt_tags',function(){
    clearTimeout(delayTimerNews);
    delayTimerNews = setTimeout(() => news_filter(), 100)
  });
  $(document).on('change','#txt_date',function(){
    news_filter();
  });
});
function news_filter(){
  let txt_date = $('#txt_date').val();
  let txt_tags = $('#txt_tags').val();
  let url_filter = [];
  if(txt_date!=""){
    url_filter.push('filterDate='+txt_date);
  }
  if(txt_tags!=""){
    url_filter.push('filterTags='+txt_tags);
  }
  if(url_filter.length>0){
    let filter = url_filter.join('&');
    window.location.href = APP_URL+'/news?'+filter;
  }
}
</script>
@endsection