@extends('layouts.main')
@section('title', 'Our Partners')
@section('content')
<section class="p-0">
  <div class="row content">
    <div class="video-image">
      <div class="facilities-and-resources mt160">
        <div style="color: #ccc;">We are here to help<br><p style="color: #fff;">Our partners</p></div>
      </div>
      <img class="img-fluid w-100" src="{{asset('images/our-partners/banner.png')}}" />
    </div>
  </div>
</section>

<section>
  <div class="container" data-aos="fade-up">

    <div class="row">
    <div class="heading5 text-center mb-1" style="display:block;">Accomodations</div>
      <div class="col-md-2 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/acc1.png')}}">
      </div>
      <div class="col-md-2 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/acc2.png')}}">
      </div>
      <div class="col-md-2 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/acc3.png')}}">
      </div>
      <div class="col-md-2 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/acc4.png')}}">
      </div>
      <div class="col-md-2 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/acc5.png')}}">
      </div>
      <div class="col-md-2 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/acc1.png')}}">
      </div>
    </div>
  
    <div class="row">
      <div class="heading5 text-center mt-3 mb-1" style="display:block;">Equipments</div>
      <div class="col-md-3 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/eq1.png')}}">
      </div>
      <div class="col-md-3 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/eq2.png')}}">
      </div>
      <div class="col-md-3 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/eq3.png')}}">
      </div>
      <div class="col-md-3 overflow-hidden">
        <img class="img-fluid" src="{{asset('images/our-partners/eq4.png')}}">
      </div>
    </div>

    <div class="row">
      <div class="heading5 text-center mt-3 mb-5" style="display:block;">Digital Services</div>
      <div class="col-md-4 overflow-hidden ps-5 pe-5">
        <img class="img-fluid pt-2" src="{{asset('images/our-partners/dig1.png')}}">
      </div>
      <div class="col-md-4 overflow-hidden ps-5 pe-5">
        <img class="img-fluid" src="{{asset('images/our-partners/dig2.png')}}">
      </div>
      <div class="col-md-4 overflow-hidden ps-5 pe-5">
        <img class="img-fluid pt-3" src="{{asset('images/our-partners/dig3.png')}}">
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-md-4 overflow-hidden ps-5 pe-5">
        <img class="img-fluid pt-3" src="{{asset('images/our-partners/dig4.png')}}">
      </div>
      <div class="col-md-4 overflow-hidden ps-5 pe-5">
        <img class="img-fluid pt-3" src="{{asset('images/our-partners/dig5.png')}}">
      </div>
    </div>

    <div class="p-3 mt-3">
      <div class="row mt-5">
        <div class="col-md-3">
          <h5>People</h5>
          @if($locations)
            <h5>Location</h5>
            @foreach($locations as $loc)
            <div class="clearfix"></div>
            <h6 class="txtgray">{{$loc->location}}</h6>
            @endforeach
          @endif
          @if($studioTypes)
            <h5>Services</h5>
            @foreach($studioTypes as $st)
            <div class="clearfix"></div>
            <h6 class="txtgray">{{$st->name}}</h6>
            @endforeach
          @endif
        </div>
        @if($resources)
          @foreach($resources as $res)
          <div class="col-md-3">
            <div class="imgbox">
              <img src="{{url('storage/profile-pic/'.$res->profile_pic)}}" class="imgfluidlogged">
              </div>
              <div class="clearfix"></div>
              <h6 class="mt-2">{{$res->fname}} {{$res->lname}}</h6>
              <div class="clearfix"></div>
              <div class="d-inline">
                <h6 class="float-start fontsize9rem">{{$res->name}}</h6>
                <!-- <h6 class="float-end fontsize9rem">Mex</h6> -->
              </div>
          </div>
          @endforeach
        @endif
      </div>
    </div>

  </div>
</section>

@endsection