@extends('layouts.main')
@section('title', 'People')
@section('content')
<section class="p-0">
  <div class="row content">
    <div class="video-image">
      <div class="facilities-and-resources mt160">
        <div style="color: #ccc;">Meet our<br><p style="color: #fff;">Crew</p></div>
      </div>
      <img class="img-fluid w-100" src="{{asset('images/people/banner.png')}}" />
    </div>
  </div>
</section>

<section>
  <div class="container" data-aos="fade-up">
    <div class="p-3 mt-3">
      <div class="row mt-5">
        <div class="col-md-3">
          @if($crews)
            <h5>Specialist</h5>
            @foreach($crews as $crew)
            <div class="clearfix"></div>
            <h6 class="txtgray">{{$crew->name}}</h6>
            @endforeach
          @endif
          @if($locations)
            <h5 class="mt-3">Locations</h5>
            @foreach($locations as $loc)
            <div class="clearfix"></div>
            <h6 class="txtgray">{{$loc->location}}</h6>
            @endforeach
          @endif
        </div>
        @if($resources)
          @foreach($resources as $res)
          <div class="col-md-3">
            <div class="imgbox">
              <a href="{{url('crew-profile/'.$res->uuid)}}"><img src="{{url('storage/profile-pic/'.$res->profile_pic)}}" class="imgfluidlogged" /></a>
              </div>
              <div class="clearfix"></div>
              <h6 class="mt-2">{{$res->fname}} {{$res->lname}}</h6>
              <div class="clearfix"></div>
              <div class="d-inline">
                <h6 class="float-start fontsize9rem">{{$res->name}}</h6>
                <!-- <h6 class="float-end fontsize9rem">Mex</h6> -->
              </div>
          </div>
          @endforeach
        @endif
      </div>
    </div>

  </div>
</section>

@endsection