@extends('layouts.main')
@section('title', $lp->studio->name)
@section('content')
<section class="p-0">
  <div class="row content">
    <div class="video-image">
      <div class="facilities-and-resources mt160">
        <div style="color: #ccc;">{{$lp->location->location}} <br><p style="color: #fff;"> {{$lp->studio->name}}</p></div>
      </div>
      <img class="img-fluid w-100" src="{{asset('storage/location/'.$lp->banner_picture)}}" />
    </div>
  </div>
</section>

<section>
  <div class="container" data-aos="fade-up" style="min-height:200px;">
    <div class="row">
      <div class="col-md-7 mx-auto"> 
        <div class="content1 heading5">{!! html_entity_decode($lp->description) !!}</div>
      </div>
    </div>
  </div>
</section>

<section>
  <div class="container" data-aos="fade-up">
    @if($lp->gallery)
    <div id="thumbnail-slider">
      <div class="inner">
        <ul>
          @foreach($lp->gallery as $gal)
          <li>
            <a class="thumb" href="{{url('storage/location/'.$gal->image_url)}}">
              <!-- <div class="thumbcaption">Lorem ipsum dolor sit amet, consectetur adipiscing elit</div> -->
            </a>
          </li>
          @endforeach
        </ul>    
      </div>
    </div>
    @endif
 
    @include('frontend.crews')

    @if($equipments)
    <div class="row mt-5">
      <div class="heading1 pb-2 fnt30">We have all you need</div>
      <div class="heading2 pb-3 fnt30">Equipments</div>
      <div class="clearfix"></div>
      <div class="col-md-8 mx-auto">
        <div class="row">
          @foreach($equipments as $eq)
          <div class="col-md-2 overflow-hidden">{{$eq->cat_name}}</div>
          @endforeach
        </div>
      </div>
    </div>
    @endif

    <div class="row mt-5">
      <div class="col-md-12 text-center">
        <div class="heading4">Book Now
        <svg
          class="_252"
          width="24"
          height="25"
          viewBox="0 0 24 25"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z"
            fill="#111111"
          />
        </svg>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@section('footer_scripts')
<link href="{{asset('css/thumbnail-slider.css')}}" rel="stylesheet">
<script src="{{asset('js/thumbnail-slider.js')}}"></script>
@endsection