@extends('layouts.sidebar')
@section('title', 'Nomadic-Billing')
@section('content')
<div class="pagetitle">
  <h1>Billing</h1>
</div><!-- End Page Title -->

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="heading3 ps-0 mb-2">Transactions</div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Date</td>
                <td>Status</td>
                <td>Amount</td>
                <td>User</td>
              </tr>
            </thead>
            <tbody>
              @foreach($data as $point)
              <tr>
                <td>{{date('d M Y',strtotime($point->created_at))}}</td>
                <td>{{$points_action[$point->action]}} @if($point->plan_id) ({{$point->plan->name}}) @endif</td>
                <td>@if($point->amount){{convertCurrency($point->amount)}}@else 0 @endif {{session()->get('user_currency')}}</td>
                <td>{{$point->receivedby->fname}} {{$point->receivedby->lname}}</td>
              </tr>
              @endforeach
            </tbody>
            <tfoot>
              <tr>
                <td colspan="5">
                  <div class="foot-paging">
                    {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>
  </div>
</section>
@endsection
@section('footer_scripts')
<script>
  $(document).ready(function () {
    $(document).on('click', '.vieweye', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      
      let uuid = $(this).data('uuid');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, uuid:uuid, type:'view'},
          url: APP_URL+"/userinfo",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });

  });
</script>
@endsection