<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1" user-scalable="no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title')</title>    

    <link href="https://fonts.cdnfonts.com/css/neue-haas-grotesk-display-pro" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('vendor/bootstrap/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('vendor/bootstrap-icons/bootstrap-icons.css')}}">
    <link rel="stylesheet" href="{{asset('vendor/bootstrap/css/bootstrap-datepicker3.min.css')}}">
    <link rel="stylesheet" href="{{asset('css/style.css')}}">
    <link rel="stylesheet" href="{{asset('css/topnav.css')}}">

    <script src="{{asset('js/jquery-2.2.4.min.js')}}"></script>
    <script src="{{asset('vendor/bootstrap/js/bootstrap-datepicker.min.js')}}"></script>
    <script src="{{asset('js/jquery.validate.min.js')}}"></script>
</head>
  <script>
    var APP_URL = {!! json_encode(url('/')) !!}
    var _token = $('meta[name="csrf-token"]').attr('content');
  </script>
  <script src="{{ asset('js/nomadic.js') }}" ></script>
<body>
<div class="mainContainer">
  @include('partials/header')
  <main id="main2">
    @yield('content')
  </main>
  <div class="modal fade" id="alertMsg" style="z-index:90000">
      <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content bdrradius">
          <div class="modal-body">
              <div class="mt-2 mb-4 pagemsgcontent"></div>
              <div class="text-center">
              <button type="button" class="btn btn-primary ml-2" data-bs-dismiss="modal">Ok</button>
              </div>
          </div>
          </div>
      </div>
  </div>

  <div class="modal" id="general_modal" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content bdrradius">
        <div class="modal-header">
          <h5 class="modal-title"></h5>
        </div>
        <div class="modal-body"></div>
        <div class="modal-footer">
          
        </div>
      </div>
    </div>
  </div>

  <div class="modal" id="guest_modal" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered modal-sm">
      <div class="modal-content lightgrey bdradius1">
        <div class="modal-body p-0 bdradius1">
          <p><i class="bi bi-x-lg popuclose pointer" data-bs-dismiss="modal" aria-label="Close"></i></p>
          <div class="md-container"></div>
        </div>
      </div>
    </div>
  </div>

  <!-- Start modal for Language and region -->
  @include('language_price')
  <!-- End modal for Language and region-->
  <div class="modal fade" id="createplanner" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="createplannerLabel" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen-md-down">
    <div class="modal-content">
      <div class="modal-header borderbottom">
        <h5 class="modal-title fw-bolder" id="createplannerLabel">Booking Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="book_modal"></div>
    </div>
  </div>
</div>
  @include('partials/footer')
  <script src="{{asset('vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
  <script src="{{asset('js/main.js')}}"></script>
  <script src="{{asset('js/topnav.js')}}"></script>
  @yield ('footer_scripts')
</div>
</body>
</html>