<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1" user-scalable="no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title')</title>    

    <link rel="stylesheet" href="{{asset('vendor/bootstrap/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('vendor/bootstrap-icons/bootstrap-icons.css')}}">
    <!-- <link href="{{asset('vendor/quill/quill.snow.css')}}" rel="stylesheet">
    <link href="{{asset('vendor/quill/quill.bubble.css')}}" rel="stylesheet"> -->
    <link rel="stylesheet" href="{{asset('css/bootstrap-select.css')}}">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link rel="stylesheet" href="{{asset('css/style.css')}}">
    <link rel="stylesheet" href="{{asset('css/topnav.css')}}">

    <script src="{{asset('js/jquery-2.2.4.min.js')}}"></script>
    <script src="{{asset('js/jquery.validate.min.js')}}"></script>
    <script src="{{asset('vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('js/bootstrap-select.min.js')}}"></script>
</head>
  <script>
    var APP_URL = {!! json_encode(url('/')) !!}
    var _token = $('meta[name="csrf-token"]').attr('content');
  </script>
  <script src="{{ asset('js/nomadic.js') }}" ></script>
<body>
  <div class="mainContainer">
  @include('partials/header')
  <div class="sub-content">
    @include('partials/sidebar')
    <main id="main" class="main">
      @yield('content')
    </main>
  </div>
  <div class="modal fade" id="alertMsg" style="z-index:9000">
      <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content bdrradius">
          <div class="modal-body">
              <div class="mt-2 mb-4 pagemsgcontent"></div>
              <div class="text-center">
              <button type="button" class="btn btn-primary ml-2" data-bs-dismiss="modal">Ok</button>
              </div>
          </div>
          </div>
      </div>
  </div>

  <div class="modal fade" id="language_modal">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Language and region</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="row">
          @foreach(config('app.available_locales') as $key=>$val)
            @php
            $lang_arr = explode('|',$key);
            @endphp
            <div class="col-md-3 mb-2 lang-box" data-code="{{$val}}">
              <div class="region-lang">{{$lang_arr[0]}}</div>
              <div class="country-lang">{{$lang_arr[1]}}</div>
            </div>
          @endforeach
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Start modal for Language and region -->
  @include('language_price')
  <!-- End modal for Language and region-->
  <div class="modal fade" id="confirmBox" style="z-index:90000">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bdrradius">
          <div class="modal-header position-relative h4">Confirm Box</div>
          <div class="modal-body">
              <div class="text-center">Are you sure want to perform this action?</div>
          </div>
          <div class="modal-footer">
            <input id="confirm_action" type="button" class="btn btn-primary" value="Yes" data-url=""/>
            <input type="button" class="btn btn-danger" value="Cancel" data-bs-dismiss="modal"/>
          </div>
        </div>
      </div>
  </div>
  <div class="modal fade" id="createplanner" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="createplannerLabel" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen-md-down">
    <div class="modal-content">
      <div class="modal-header borderbottom">
        <h5 class="modal-title fw-bolder" id="createplannerLabel">Booking Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="book_modal"></div>
    </div>
  </div>
</div>
  @include('partials/footer')
  @yield ('footer_scripts')
  <script src="{{asset('js/main.js')}}"></script>
  <script src="{{asset('js/topnav.js')}}"></script>
  </div>
</body>
</html>