@extends('layouts.'.$layout)
@section('title', 'Nomadic-Event')
@section('content')
<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
    @if($event)
        @if(isset($event->thumbnail) && $event->thumbnail!="")
        <img src="{{ asset('storage/location/events/' . $event->thumbnail) }}" alt="Event Image" class="img-fluid w-100 " style="border-radius:5px;">
        @endif
        @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
        @endif
        <div class="container mt-4 center-content" style="padding-left:180px;">
            <h3 >{{ $event->formattedDate() }}</h3>
            <!-- Name of Event Creator -->
            <h1>{{ ucfirst($event->event_title) }}</h1>
            <h2>{{ $event->createdBy->fname.' '.$event->createdBy->lname }}</h2>
            <!-- Edit and Share Buttons with Icons -->
            <div class="d-flex mb-3">
                @if($layout=='sidebar')
                <a class="btn btn-primary me-1" href="{{url('backend/events/'.$locationId.'/'.$event->event_id)}}" style="display:inline;" ><i class="bi bi-pencil-square"></i></a>
                @else
                <button type="button" class="btn btn-primary me-1" @if(Auth::guest()) disabled @elseif(isset($event->interested[0]->user_id)) disabled @else onclick="event_action(this,{{$event->event_id}},'interested')" @endif>Interested</button>
                <button type="button" class="btn btn-primary me-1" @if(Auth::guest()) disabled @elseif(isset($event->going[0]->user_id)) disabled @else onclick="event_action(this,{{$event->event_id}},'going')" @endif>Going</button>
                @endif
                <button type="button" onclick="share({{$event->event_id}})" class="btn btn-primary"><i class="bi bi-share-fill"></i></button>
            </div>
            <!-- User Icon and Responded Number -->
            <div class="d-flex align-items-center mt-3" style="padding-top:50px;">
                <i class="bi bi-person-fill"></i>
                <span class="ml-2" style="padding-left:15px;">{{ $interestedCount + $goingCount }} User Responded</span> &nbsp;
                @if($layout=='sidebar')
                <a href="{{url('backend/event-responded/'.$locationId.'/'.$event->event_id)}}" style="display:inline;" >view</a>
                @endif
            </div>
            <!-- Calendar Icon and Event Date Time -->
            <div class="d-flex align-items-center mt-3">
                <i class="bi bi-calendar"></i>
                <span class="ml-2" style="padding-left:15px;">{{ $event->formattedDate() }}</span>
            </div>
            
            <div class="d-flex align-items-center mt-3">
                <i class="bi bi-geo-alt-fill"></i>
                @if($event->event_type=='online')
                <span class="ml-2" style="padding-left:15px;">ONLINE</span>
                @elseif($event->event_type=='location' && $event->address)
                <span class="ml-2" style="padding-left:15px;">{{ $event->address }}</span>
                @endif
            </div>
            
            <!-- Ticket Icon and Ticket Price with Link -->
            <div class="d-flex align-items-center mt-3">
            <i class="bi bi-ticket-perforated"></i>
                <span class="ml-2" style="padding-left:15px;"> ${{ $event->ticket_price }} <a href="{{ $event->ticket_url }}" target="_blank">Tickets</a></span>
            </div>
            <!-- Globe Icon and Event Type -->
            <div class="d-flex align-items-center mt-3">
                <i class="bi bi-globe"></i>
                <span class="ml-2" style="padding-left:15px;">{{ $event->public_private }}</span>
            </div>
            <!-- Event Description -->
            <div class="mt-3">
                {!! $event->description !!}
            </div>
            <!-- Participant Heading -->
            <h5 class="mt-4">Participants</h5>
            <!-- Interested and Going Buttons -->
            
            <!-- Interested button form -->
            <button type="button" style="background-color:#ffffff; padding:30px; width:250px; color:blue;" class="btn btn-outline-primary"><span id="interested_count">{{$interestedCount}}</span> Interested</button>

            <!-- Going button form -->
            <button type="button" style="background-color:#ffffff; padding:30px; width:250px; color:blue;" class="btn btn-outline-primary"><span id="going_count">{{$goingCount}}</span> Going</button>

            @if($event->event_type=='location' && $event->address)
            <h5 class="mt-4">Address</h5>
            <p>{{$event->address}}</p>
            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="mapouter">
                        <div class="gmap_canvas">
                            <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=1324&amp;height=400&amp;hl=en&amp;q={{$event->address}}&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                            <a href="https://connectionsgame.org/">Connections Unlimited</a>
                        </div><style>.mapouter{position:relative;text-align:right;width:100%;height:400px;}.gmap_canvas {overflow:hidden;background:none!important;width:100%;height:400px;}.gmap_iframe {height:400px!important;}</style>
                    </div>
                </div>
            </div>
            @endif
        </div>
    @else
        <p>No event found.</p>
    @endif  
  </div>
</section>
@endsection