@extends('layouts.'.$layout)
@section('title', 'Nomadic-Responded')
@section('content')

<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
    @if($event)
      @if(isset($event->thumbnail) && $event->thumbnail!="")
      <img src="{{ asset('storage/location/events/' . $event->thumbnail) }}" alt="Event Image" class="img-fluid w-100 " style="border-radius:5px;">
      @endif
      <div class="container mt-4 center-content" style="padding-left:180px;">
          <!-- Top Event Image -->

          <!-- Event Date and Time -->
          <H3 >{{ $event->formattedDate() }}</H3>

          <!-- Name of Event Creator -->
          <H1>{{ ucfirst($event->event_title) }}</H1>
          <H2>{{ $event->createdBy->fname.' '.$event->createdBy->lname }}</H2>

          <!-- Edit and Share Buttons with Icons -->
          <div class="d-flex mb-3">
            @if($layout=='sidebar')  
            <a class="btn btn-primary" href="{{url('backend/events/'.$locationId.'/'.$event->event_id)}}" style="display:inline;"><i class="bi bi-pencil-square"></i></a>&nbsp;
            @endif
            <button type="button" onclick="share()" class="btn btn-primary"><i class="bi bi-share-fill"></i></button>
          </div>

          <br/><br/>
          @if($layout=='sidebar')
          <a href="{{url('backend/event-detail/'.$locationId.'/'.$event->event_id)}}" style="background-color:#ffffff; padding:10px; width:150px; color:#666666;" class="btn btn-outline-primary" ><i class="bi bi-caret-left-fill"></i> Back to event </a><br/>
          @else
          <a href="{{url('view-event/'.$event->event_id)}}" style="background-color:#ffffff; padding:10px; width:150px; color:#666666;" class="btn btn-outline-primary" ><i class="bi bi-caret-left-fill"></i> Back to event </a><br/>
          @endif

          <h2 class="mt-4">Participants</h2>

          @if(session('success'))
          <div class="alert alert-success">
              {{ session('success') }}
          </div>
          @endif

          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
            <table class="table">
              <tbody>
                @if($participants->count()>0)
                  @foreach($participants as $dt)
                  <tr>
                    <td>
                    @if($dt->user->profile_pic)
                    <img src="{{ asset('storage/profile-pic/' . $dt->user->profile_pic) }}" class="img-fluid rounded-circle" style="height: 25px; width: 25px;">
                    @else
                    <img src="{{ asset('images/user-img.png') }}" class="img-fluid rounded-circle" style="height: 25px; width: 25px;">
                    @endif
                    {{ ucfirst($dt->user->fname.' '.$dt->user->lname) }}
                    </td>
                    <td>@if($dt->status=="going") <span class="bi bi-circle-fill text-success"></span>@endif {{ucfirst( $dt->status)}}</td>
                    @if($layout=='sidebar')
                    <td>
                      <form action="{{ route('events.participants.remove', $event) }}" id="delparticipants" style="display:inline;" method="POST">
                      @csrf
                      <button type="submit" style="border:0px;" data-url="{{ route('events.participants.remove', $event) }}"><i class="bi bi-x-lg"></i></button>
                      </form>
                    </td>
                    @endif
                  </tr>
                  @endforeach
                @else
                <tr>
                  <td @if($layout=='sidebar') colspan="3" @else colspan="2" @endif>No record found</td>
                </tr>  
                @endif
              </tbody>
              <tfoot>
                <tr>
                  <td colspan="3">
                    <div class="foot-paging">
                      {!! $participants->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                    </div>  
                  </td>
                </tr>
              </tfoot>
            </table>
          </div>
      </div>
    @else
      <p>No event found.</p>
    @endif
  </div>
</section>
 