@extends('layouts.sidebar')
@section('title', 'Nomadic-Schedule Location')
@section('content')
<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="lpid"value="{{$page->id}}" readonly>
    <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
    <ul class="nav nav-tabs nav-tabs-bordered position-relative" id="borderedTab" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="Schedule-tab" data-bs-toggle="tab" data-bs-target="#bordered-Schedule" type="button" role="tab" aria-controls="Schedule" aria-selected="true">Schedule</button>
      </li>
      <li class="nav-item " role="presentation">
        <button class="nav-link" id="General-tab" data-bs-toggle="tab" data-bs-target="#bordered-General" type="button" role="tab" aria-controls="General" aria-selected="false">General</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="studios-tab" data-bs-toggle="tab" data-bs-target="#bordered-studios" type="button" role="tab" aria-controls="Studios" aria-selected="false">Studios</button>
      </li>
    </ul>
    <div class="tab-content pt-2" id="borderedTabContent">
      <div class="tab-pane fade show active" id="bordered-Schedule" role="tabpanel" aria-labelledby="Schedule-tab">
        <div class="row">
          <div class="col-md-12">
            <div id="calendar"></div>
          </div>
        </div>
      </div>
      <div class="tab-pane fade" id="bordered-General" role="tabpanel" aria-labelledby="General-tab">
        <form id="saveProfile">
          <div class="row">
            <div class="col-xl-4">
              <div class="card">
                <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                  <label class="lblprofile">Details</label>
                </div>
              </div>
            </div>
            <div class="col-xl-8 mt-4">
              <div class="card">
                <div class="card-body pt-3">
                  <div class="row">
                    <div class="col-md-7 mb-2 position-relative">
                      <label>Address</label>
                      <input type="text" class="form-control" name="address" placeholder="Address" value="@if(isset($page->address)){{$page->address}}@endif" />
                      <label class="mt-3">Opening hours</label></br>
                      <textarea name="opening_hours" class="form-control txtarea mb-3" rows="4" placeholder="Opening hours">@if(isset($page->opening_hours)){{$page->opening_hours}}@endif</textarea>
                      <label class="mt-3">Phone</label></br>
                      <input type="text" class="form-control" name="phone" placeholder="Phone" value="@if(isset($page->phone)){{$page->phone}}@endif" />
                      <label class="mt-3">Email</label></br>
                      <input type="text" class="form-control" name="email" placeholder="Email address" value="@if(isset($page->email)){{$page->email}}@endif"/>
                      <label class="mt-3">How to get there</label></br>
                      <textarea name="how_to_get_there" class="form-control txtarea mb-3" rows="4" placeholder="Hot to get there">@if(isset($page->how_to_get_there)){{$page->how_to_get_there}}@endif</textarea>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row mt-3">
            <div class="col-md-12 text-center">
              <input id="btn_saveloclandingpage" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
            </div>
          </div>
        </form>
      </div>

      <div class="tab-pane fade " id="bordered-studios" role="tabpanel" aria-labelledby="studios-tab">
        <div class="row">
          <div class="gridcard col-xl-12">
            <div class="card">
              <div class="row">
                <div class="col-md-7 mb-2 position-relative">
                  <input id="search_field" type="text" class="form-control" placeholder="Search">
                  <i class="bi bi-search searchicon"></i>
                </div>
              </div>
              <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
                <table class="table">
                  <thead>
                    <tr>
                      <td colspan="2">
                        <button type="button" class="btn float-end addicon"><i class="bi bi-plus"></i> Add New Studio</button>
                      </td>
                    </tr>
                  </thead>
                  <tbody>
                    @if(!empty($local_studios) && $local_studios->count())
                      @foreach($local_studios as $dt)
                      <tr>
                        <td>{{$dt->name}}</td>
                        <td align="right">
                          <i class="bi bi-pencil editicon" data-uuid="{{$dt->id}}"></i>
                        </td>
                      </tr>
                      @endforeach
                    @else
                    <tr>
                      <td colspan="2">No record found</td>
                    </tr>  
                    @endif
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="2">
                        <div class="foot-paging">
                          {!! $local_studios->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                        </div>  
                      </td>
                    </tr>
                  </tfoot>
                </table>
              </div>
            </div>
          </div>

          <div class="col-xl-5 user-card" style="display:none;">
            <div class="card thinborder" style="min-height:500px;">
              <div class="card-body pt-3">
              </div>
            </div>
          </div>
        </div>
      </div>
      
    </div>
    <!-- End Bordered Tabs -->
  </div>
</section>
@endsection
@section('footer_scripts')
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/index.global.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/@fullcalendar/bootstrap5@6.1.9/index.global.min.js'></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    var calendarEl = document.getElementById('calendar');
    var modal = document.getElementById("createplanner");
    var calendar = new FullCalendar.Calendar(calendarEl, {
      timeZone: 'UTC',
      themeSystem: 'bootstrap5',
      headerToolbar: {
        left: 'today prev,next',
        center: 'title',
        right: 'dayGridMonth,timeGridWeek,timeGridDay'
      },
      navLinks: true, 
      selectable: true,
      nowIndicator: true,
      dayMaxEvents: true, 
      editable: true,
      selectable: true,
      businessHours: false,
      dayMaxEvents: true, 
      weekNumbers: false,
      dayMaxEvents: true,
      events: @json($events),
      eventClick: function(info) {
		    let startTime = info.event.start.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: true });
        let startDate = info.event.start.getDay() +' '+months[info.event.start.getMonth()] +' '+ info.event.start.getFullYear()+' '+startTime;
        let endTime = info.event.end.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: true });
        let endDate = info.event.end.getDay() +' '+months[info.event.end.getMonth()] +' '+ info.event.end.getFullYear()+' '+endTime;
		    
        booking_html(startDate, endDate, info.event.extendedProps);
      },
      eventDrop: function (info) {
        var newDate = new Date(info.event.start);
        if (newDate < Date.now()) {
            info.revert();
        }
      }
    });
    calendar.render();
    var evt = document.createEvent('UIEvents');
    evt.initUIEvent('resize', true, false, window, 0);
    window.dispatchEvent(evt);
  });
  $(document).ready(function () {
    $(document).on('click','.searchicon',function(){
      let user_search = $('#user_search').val();
      if($.trim(user_search)!=""){
        window.location.href = APP_URL+'/applications?name='+user_search;
      }
    });
    $(document).on('click', '.addicon, .editicon', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      let uuid = $(this).data('uuid');
	    let locationId = $("#locationId").val();
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, lid:uuid,type:'edit',locationId:locationId},
          url: APP_URL+"/studio-detail",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
              $('select[name="crew[]"]').selectpicker();
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });
    $(document).on('click', '#btn_delete', function(){
      let obj = $(this);
      obj.attr('disabled',true);
      let did = obj.data('did');
      let type = obj.data('type');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, type:type, did:did},
          url: APP_URL+"/remove-action",
          success: function(res) {
            obj.attr('disabled',false);
            if(res.status){
              reload_tab('#studios-tab');
            }
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });
    $(document).on('click', '#btn_saveStudio', function(){
      let obj = $(this);
      obj.attr('disabled',true);
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: $('#updateStudio').serialize(),
          url: APP_URL+"/save-studio",
          success: function(res) {
            obj.attr('disabled',false);
            if(res.status){
              reload_tab('#studios-tab');
            }
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });
    $(document).on('click','#btn_saveloclandingpage',function(){
      let lpid = $('#lpid').val();
      let location_id = $('#location_id').val();
      let phone = $('input[name="phone"]').val();
      let email = $('input[name="email"]').val();
      let address = $('input[name="address"]').val();
      let opening_hours = $('textarea[name="opening_hours"]').val();
      let how_to_get_there = $('textarea[name="how_to_get_there"]').val();
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, lpid:lpid, phone:phone, email:email, address:address, opening_hours:opening_hours,  how_to_get_there:how_to_get_there,type:'edit'},
        url: APP_URL+"/backend/location-landing-page-save/"+location_id,
        success: function(res) {
          if(res.status){
            $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">General information saved successfully.</div>');
            $('#alertMsg').modal('show');
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
  });
</script>

@endsection