@extends('layouts.sidebar')
@section('title', 'Nomadic-Schedule Rental')
@section('content')
<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
    <ul class="nav nav-tabs nav-tabs-bordered position-relative" id="borderedTab" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="Schedule" data-bs-toggle="tab" data-bs-target="#bordered-Schedule" type="button" role="tab" aria-controls="Schedule" aria-selected="true">Schedule</button>
      </li>
      <li class="nav-item " role="presentation">
        <button class="nav-link" id="Equipment" data-bs-toggle="tab" data-bs-target="#bordered-Equipment" type="button" role="tab" aria-controls="Equipment" aria-selected="false">Equipment</button>
      </li>
    </ul>
    <div class="tab-content pt-2" id="borderedTabContent">
      <div class="tab-pane fade show active" id="bordered-Schedule" role="tabpanel" aria-labelledby="Schedule">
        <div class="row">
          <div class="col-md-12">
            <div id="calendar"></div>
          </div>
        </div>
      </div>
      <div class="tab-pane fade" id="bordered-Equipment" role="tabpanel" aria-labelledby="Equipment">
       <div class="row">
          <div class="gridcard col-xl-12">
            <div class="card">
              <div class="row">
                <div class="col-md-7 mb-2 position-relative">
                  <input id="search_field" type="text" class="form-control" placeholder="Search">
                  <i class="bi bi-search searchicon"></i>
                </div>
              </div>
              <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
                <table class="table">
                  <thead>
                  <tr>
                      <td colspan="6">
                        <button type="button" class="btn float-end addicon"><i class="bi bi-plus"></i> Add New Equipment</button>
                      </td>
                    </tr>
                    <tr>
                      <td> Name </td>
                      <td> Category </td>
                      <td> Status </td>
                      <td> Serial Number </td>
                      <td> Price </td>
                      </td></td>
                     
                    </tr>
                  </thead>
                  <tbody>
                    @if(!empty($studio_equipments) && $studio_equipments->count())
                      @foreach($studio_equipments as $dt)
                      <tr>
                          <td>{{$dt->name}}</td>
                          <td>{{$dt->Category->cat_name}}</td>
                          <td>
                            @if($dt->status==0)<span class="bi bi-circle-fill text-danger"></span> Unavailable  @else<span class="bi bi-circle-fill text-success"></span> Available @endif </td>
                          <td>{{$dt->serial_number}}</td>
                          <td>{{convertCurrency($dt->price)}} ({{session()->get('user_currency')}})</td>
                          <td align="right">
                              <i class="bi bi-pencil editicon" data-uuid="{{$dt->id}}"></i> &nbsp;<a href="{{url('backend/equipment-schedule/'.$locationId.'/'.$dt->id)}}" style="display:inline;" >
                              <i class="bi bi-calendar "></i>
                              </a>
                          </td>
                      </tr>
                      @endforeach
                    @else
                    <tr>
                      <td colspan="6">No record found</td>
                    </tr>  
                    @endif
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="6">
                        <div class="foot-paging">
                          {!! $studio_equipments->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                        </div>  
                      </td>
                    </tr>
                  </tfoot>
                </table>
              </div>
            </div>
          </div>

          <div class="col-xl-5 user-card" style="display:none;">
            <div class="card thinborder" style="min-height:500px;">
              <div class="card-body pt-3">
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- End Bordered Tabs -->
  </div>
</section>
@endsection
@section('footer_scripts')
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/index.global.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/@fullcalendar/bootstrap5@6.1.9/index.global.min.js'></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.js"></script>
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    var calendarEl = document.getElementById('calendar');
    var modal = document.getElementById("createplanner");

    @isset($events_rent)
        var eventsRentArray = @json($events_rent);
    @else
        var eventsRentArray = [];
    @endisset
    var calendar = new FullCalendar.Calendar(calendarEl, {
        timeZone: 'UTC',
        themeSystem: 'bootstrap5',
        headerToolbar: {
            left: 'today prev,next',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        navLinks: true, 
        selectable: true,
        nowIndicator: true,
        dayMaxEvents: true, 
        editable: true,
        selectable: true,
        businessHours: false,
        dayMaxEvents: true, 
        weekNumbers: false,
        dayMaxEvents: true,
        events: @json($events).concat(eventsRentArray),
        eventClick: function(info) {
            let startTime = info.event.start.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: true });
            let startDate = info.event.start.getDay() +' '+months[info.event.start.getMonth()] +' '+ info.event.start.getFullYear()+' '+startTime;
            let endTime = info.event.end.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: true });
            let endDate = info.event.end.getDay() +' '+months[info.event.end.getMonth()] +' '+ info.event.end.getFullYear()+' '+endTime;
            
            booking_html(startDate, endDate, info.event.extendedProps);
        },
        eventDrop: function (info) {
            var newDate = new Date(info.event.start);
            if (newDate < Date.now()) {
                info.revert();
            }
        }
    });

    calendar.render();
    var evt = document.createEvent('UIEvents');
    evt.initUIEvent('resize', true, false, window, 0);
    window.dispatchEvent(evt);
});

$(document).ready(function () {
    $(document).on('click', '.addicon, .editicon', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      let uuid = $(this).data('uuid');
	    let locationId = $("#locationId").val();
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, lid:uuid,type:'edit',locationId:locationId},
          url: APP_URL+"/rental-detail",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
			        dropfiles();
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });
    $(document).on('click', '#btn_delete', function(){
      if(confirm('Are you sure want to perform this action?')){
        let obj = $(this);
        obj.attr('disabled',true);
        let did = obj.data('did');
        let type = obj.data('type');
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, type:type, did:did},
            url: APP_URL+"/remove-action",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status){
                reload_tab("#Equipment");
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      }
    });
	
    $(document).on('click', '#btn_saveEquipment', function(){
      let obj = $(this);
      obj.attr('disabled', true);
      var formData = new FormData($('#updateEquipment')[0]);
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: formData,
        processData: false,  
        contentType: false,  
        url: APP_URL+"/save-rental",
        success: function(res) {
          obj.attr('disabled', false);
          if(res.status){
            reload_tab("#Equipment");
          }
        },
        error: function(res) {
          obj.attr('disabled', false);  
          ajax_error(res);
        }
      });
    });
});
  
function dropfiles(){
  Dropzone.autoDiscover = false;
  var myDropzone = new Dropzone("#dropphoto", {
    url: "{{ route('file.upload') }}",
    method: "post",
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    paramName: "rental",
    maxFiles: 1,
    acceptedFiles: ".jpeg, .jpg, .png",
  });
  myDropzone.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#photo').val(response.fileName);
    $('#dispphotoimg').html('<img src="'+APP_URL+'/storage/'+response.rentalPath+'" class="img-fluid w-100" style="border-radius:5px;">');
    myDropzone.removeAllFiles(true);
  });

  var myReceipt = new Dropzone("#dropreceipt", {
    url: "{{ route('file.upload') }}",
    method: "post",
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    paramName: "receipt",
    maxFiles: 1,
    acceptedFiles: ".jpeg, .jpg, .png, .pdf",
  });
  myReceipt.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#receipt').val(response.fileName);
    $('#dispreceiptimg').html('<img src="'+APP_URL+'/storage/'+response.receiptPath+'" class="img-fluid w-100" style="border-radius:5px;">');
    myReceipt.removeAllFiles(true);
  });
  $('#dropreceipt .dz-txt').html('or drag and drop PNG, JPG, GIF or pdf');

  var myManual = new Dropzone("#dropmanual", {
    url: "{{ route('file.upload') }}",
    method: "post",
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    paramName: "manual",
    maxFiles: 1,
    acceptedFiles: ".pdf",
  });
  myManual.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#manual').val(response.fileName);
    $('#dispmanualimg').html('<a href="'+APP_URL+'/storage/'+response.manualPath+'"  target="_blank">'+response.fileName+'</a>');
    myManual.removeAllFiles(true);
  });
  $('#dropmanual .dz-txt').html('or drag and drop pdf file');
}
</script>
@endsection