@extends('layouts.main')
@section('title', 'Nomadic Studios | Plans')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4">{{__('Select membership level')}}</h2> 
    <span>- {{__('14 days residence/year')}}</span></br>
    <span>- {{__('14 days studio time/year')}}</span>
    <div class="row mb-5" align="center">
        @foreach($plans as $plan)
        <div class="col-md-22 me-4 subscription-box">
            <div class="p-2 mb-4">{{$plan->name}}</div>
            <h3 class="mb-4"><b>${{$plan->price}}</b><span>/{{$plan->frequency}}</span></h3>
            <div class="p-2"><i class="bi bi-check2 me-2"></i>{{$plan->points}} Pts</div>
            <div class="p-2"><i class="bi bi-check2 me-2"></i>
            @if($plan->stripe_plan=="")
            Must be invited by member
            @else
            Book up {{$plan->advance_duration}} {{$plan->advance_frequency}} in advance
            @endif
            </div>
            <div class="p-2"><i class="bi bi-check2 me-2"></i>{{$guests[$plan->num_of_guest]}} guests</div>
            @if($plan->slug=='guest')
            <a href="{{ route('consent') }}" class="btn btn-primary pull-right mt-4 mb-3">{{__('Choose plan')}}</a>
            @else
            <a href="{{ route('plans.show', $plan->slug) }}" class="btn btn-primary pull-right mt-4 mb-3">{{__('Choose plan')}}</a>
            @endif
        </div>
        @endforeach
    </div>
</div>
@endsection
