@extends('layouts.main')
@section('title', 'Nomadic Studios | Payment')  
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container">
    <h2 class="mt-4">{{__('Add credit card')}}</h2>
    <div class="row mb-5 d-block"  align="center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                {{__('You will be charged')}} ${{ number_format($plan->price, 2) }} {{__('for')}} {{ $plan->name }} {{__('Plan')}}
                </div>
  
                <div class="card-body">
                    <div class="alert alert-danger p-2 errorMsgUpdt" style="display:none;"></div>
                    <form id="payment-form" action="{{ route('subscription.create') }}" method="POST">
                        @csrf
                        <input type="hidden" name="plan" id="plan" value="{{ $plan->id }}">
  
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="text" name="name" id="card-holder-name" class="form-control" value="" placeholder="{{__('Name on the card')}}">
                                </div>
                            </div>
                        </div>
  
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div id="card-element"></div>
                                </div>
                            </div>
                            <div class="col-md-12 mt-4">
                                <button type="submit" class="btn btn-primary" id="card-button" data-secret="{{ $intent->client_secret }}">{{__('Add payment method')}}</button>
                            </div>
                        </div>
  
                    </form>
  
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<script src="https://js.stripe.com/v3/"></script>
<script>
    const stripe = Stripe("{{ env('STRIPE_KEY') }}")
  
    const elements = stripe.elements()
    const cardElement = elements.create('card')
  
    cardElement.mount('#card-element')
  
    const form = document.getElementById('payment-form')
    const cardBtn = document.getElementById('card-button')
    const cardHolderName = document.getElementById('card-holder-name')
  
    form.addEventListener('submit', async (e) => {
        e.preventDefault()
        let fullname = $('#card-holder-name').val();
        if($.trim(fullname)==""){
            $('.errorMsgUpdt').html("{{__('Name is required field.')}}").show();
            return false;
        }
        
        cardBtn.disabled = true
        const { setupIntent, error } = await stripe.confirmCardSetup(
            cardBtn.dataset.secret, {
                payment_method: {
                    card: cardElement,
                    billing_details: {
                        name: cardHolderName.value
                    }   
                }
            }
        )
  
        if(error) {
            console.log(error);
            $('.errorMsgUpdt').html(error.message).show();
            $('#card-button').removeAttr('disabled');
        } else {
            $('.errorMsgUpdt').html('').hide();
            let token = document.createElement('input')
            token.setAttribute('type', 'hidden')
            token.setAttribute('name', 'token')
            token.setAttribute('value', setupIntent.payment_method)
            form.appendChild(token)
            form.submit();
        }
    })
</script>
@endsection