@extends('layouts.sidebar')
@section('title', 'Nomadic-Studio')
@section('content')
<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="daily_rate" value="{{convertCurrency($studio->daily_rate)}}">
    <input type="hidden" id="hourly_rate" value="{{convertCurrency($studio->hourly_rate)}}">
    <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
    <input type="hidden" id="studioId" name="studioId" value="{{$studioId}}" readonly>
    <ul class="nav nav-tabs nav-tabs-bordered position-relative" id="borderedTab" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="Schedule" data-bs-toggle="tab" data-bs-target="#bordered-Schedule" type="button" role="tab" aria-controls="Schedule" aria-selected="true">Schedule</button>
      </li>
      <li class="nav-item " role="presentation">
        <button class="nav-link" id="Inventory" data-bs-toggle="tab" data-bs-target="#bordered-Inventory" type="button" role="tab" aria-controls="Inventory" aria-selected="false">Inventory</button>
      </li>
    </ul>
    <div class="tab-content pt-2" id="borderedTabContent">
      <div class="tab-pane fade show active" id="bordered-Schedule" role="tabpanel" aria-labelledby="Schedule">
        <div class="row">
          <div class="col-md-8">
            <div id="calendar"></div>
          </div>
          <div class="col-md-4">
              <div class="col-md-12 p-0">
                <form id="scheduleCalendar">
                  @csrf
                  <input type="hidden" id="type" name="type" value="studio" readonly>
                  <input type="hidden" id="refrence_id" name="refrence_id" value="{{$studioId}}" readonly>
                  <input type="hidden" id="schedule_id" name="schedule_id" value="">
                  <input type="hidden" id="edit_schedule_type" name="edit_schedule_type" value="">
                  <input type="hidden" id="schedule_location" name="schedule_location" value="{{$locationId}}">
                  <h5 class="fw-bolder">Availablitiy & prices</h5>
                  <div class="row mt-4">
                    <div class="col-md-11 position-relative">
                      <select class="form-control" name="availability_type">
                        <option value="0">Daily availability</option>
                        <option value="1">Recurring availability</option>
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                  </div>
                  <div id="dailyAvailCont" class="mt-4">
                    <div style="overflow-x:auto">
                      <table class="table table-borderless tbl_boolingdtlsiner avlpricetbl">
                        <thead class="borderbottomnone">
                          <tr>
                            <td class="avltxt" colspan="3"><i class="bi bi-clock"></i> Daily Availability</td>
                            <td class="avltxtsmall">Daily ({{session()->get('user_currency')}})</td>
                            <td class="avltxtsmall">Hourly ({{session()->get('user_currency')}})</td>
                            <td class="avltxt"><i id="add_daily_click" class="bi bi-plus float-right f20"></i></td>
                          </tr>
                        </thead>
                        <tbody id="daily_container">
                          <tr>
                            <td>
                              <input name="daily_start_date[0]" type="date" class="form-control"  style="width:100px;" data-index="0" onkeyup="validateDateTime(0)">
                            </td>
                            <td><input name="daily_start_time[0]" type="time" class="form-control" data-index="0" onkeyup="validateDateTime(0)"></td>
                            <td><input name="daily_end_time[0]" type="time" class="form-control" data-index="0" onkeyup="validateDateTime(0)"></td>
                            <td><input name="daily_daily_rate[0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="daily_hourly_rate[0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td><i class="bi bi-trash daily-trash f20"></i></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                    <div class="clearfix"></div>
                  </div>
                  <div id="recuAvailCont" class="mt-4" style="display:none;">
                    <div style="overflow-x:auto">  
                      <table class="table table-borderless tbl_boolingdtlsiner mt-4 avlpricetbl">
                        <thead class="borderbottomnone">
                          <tr>
                            <td class="avltxt" colspan="3"><i class="bi bi-clock"></i> Recurring Availability</td>
                            <td class="avltxtsmall">Daily ({{session()->get('user_currency')}})</td>
                            <td class="avltxtsmall">Hourly ({{session()->get('user_currency')}})</td>
                            <td class="avltxt"></td>
                          </tr>
                        </thead>
                        <tbody>
                          <tr class="row-0">
                            <td class="fw-bold"><input class="recurrchk" data-day="0" name="recurring_days[0]" type="checkbox" value="0">Mon</td>
                            <td>
                              <input name="recurring_start_time[0][0]" type="time" data-index="0" class="form-control" onkeyup="validateDateTimeRecu(0,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[0][0]" type="time" class="form-control" onkeyup="validateDateTimeRecu(0,0)">
                            </td>
                            <td><input name="recurring_daily_rate[0][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="recurring_hourly_rate[0][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="0"></i>
                            </td>
                          </tr>
                          <tr class="row-1">
                            <td class="fw-bold"><input class="recurrchk" data-day="1" name="recurring_days[1]" type="checkbox" value="1">Tue</td>
                            <td>
                              <input name="recurring_start_time[1][0]" type="time" data-index="0" class="form-control" onkeyup="validateDateTimeRecu(1,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[1][0]" type="time" class="form-control" onkeyup="validateDateTimeRecu(1,0)">
                            </td>
                            <td><input name="recurring_daily_rate[1][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="recurring_hourly_rate[1][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="1"></i>
                            </td>
                          </tr>
                          <tr class="row-2">
                            <td class="fw-bold"><input class="recurrchk" data-day="2" name="recurring_days[2]" type="checkbox" value="2">Wed</td>
                            <td>
                              <input name="recurring_start_time[2][0]" type="time" data-index="0" class="form-control" onkeyup="validateDateTimeRecu(2,2)">
                            </td>
                            <td>
                              <input name="recurring_end_time[2][0]" type="time" class="form-control" onkeyup="validateDateTimeRecu(2,2)">
                            </td>
                            <td><input name="recurring_daily_rate[2][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="recurring_hourly_rate[2][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="2"></i>
                            </td>
                          </tr>
                          <tr class="row-3">
                            <td class="fw-bold"><input class="recurrchk" data-day="3" name="recurring_days[3]" type="checkbox">Thu</td>
                            <td>
                              <input name="recurring_start_time[3][0]" type="time" data-index="0" class="form-control" onkeyup="validateDateTimeRecu(3,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[3][0]" type="time" class="form-control" onkeyup="validateDateTimeRecu(3,0)">
                            </td>
                            <td><input name="recurring_daily_rate[3][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="recurring_hourly_rate[3][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="3"></i>
                            </td>
                          </tr>
                          <tr class="row-4">
                            <td class="fw-bold"><input class="recurrchk" data-day="4" name="recurring_days[4]" type="checkbox" value="4">Fri</td>
                            <td>
                              <input name="recurring_start_time[4][0]" type="time" data-index="0" class="form-control" onkeyup="validateDateTimeRecu(4,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[4][0]" type="time" class="form-control" onkeyup="validateDateTimeRecu(4,0)">
                            </td>
                            <td><input name="recurring_daily_rate[4][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="recurring_hourly_rate[4][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="4"></i>
                            </td>
                          </tr>
                          <tr class="row-5">
                            <td class="fw-bold"><input class="recurrchk" data-day="5" name="recurring_days[5]" type="checkbox" value="5">Sat</td>
                            <td>
                              <input name="recurring_start_time[5][0]" type="time" data-index="0" class="form-control" onkeyup="validateDateTimeRecu(5,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[5][0]" type="time" class="form-control" onkeyup="validateDateTimeRecu(5,0)">
                            </td>
                            <td><input name="recurring_daily_rate[5][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="recurring_hourly_rate[5][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="5"></i>
                            </td>
                          </tr>
                          <tr class="row-6">
                            <td class="fw-bold"><input class="recurrchk" data-day="6" name="recurring_days[6]" type="checkbox" value="6">Sun</td>
                            <td>
                              <input name="recurring_start_time[6][0]" type="time" data-index="0" class="form-control" onkeyup="validateDateTimeRecu(6,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[6][0]" type="time" class="form-control" onkeyup="validateDateTimeRecu(6,0)">
                            </td>
                            <td><input name="recurring_daily_rate[6][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->daily_rate)}}"></td>
                            <td><input name="recurring_hourly_rate[6][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($studio->hourly_rate)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="6"></i>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <!-- <h6 class="fw-bold mt-3 mb-3"><i class="bi bi-globe2"></i> Timeszones</h6> -->
                  <div class="col-md-12 mb-2 mt-2 position-relative">
                    <!-- <select class="form-control">
                      <option>Bali, Indonesia (GMT + 8)</option>
                    </select> 
                    <i class="bi bi-caret-down-fill searchicon rgt0"></i> -->
                    <div class="text-center mt-4 mb-2">
                      <button id="schedule_save" type="button" class="btn btn-primary">Save</button>
                      <button id="schedule_reset" type="button" class="btn btn-primary">Reset</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
        </div>
      </div>
      <div class="tab-pane fade" id="bordered-Inventory" role="tabpanel" aria-labelledby="Inventory">
        <div class="row">
          <div class="gridcard col-xl-12">
            <div class="card">
              <div class="row">
                <div class="col-md-7 mb-2 position-relative">
                  <input id="search_field" type="text" class="form-control" placeholder="Search">
                  <i class="bi bi-search searchicon"></i>
                </div>
              </div>
              <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
                <table class="table">
                  <thead>
                  <tr>
                      <td colspan="6">
                        <button type="button" class="btn float-end addicon"><i class="bi bi-plus"></i> Add New Equipment</button>
                      </td>
                    </tr>
                    <tr>
                      <td> Name </td>
                      <td> Category </td>
                      <td> Status </td>
                      <td> Serial Number </td>
                      <td> Price </td>
                      </td></td>
                     
                    </tr>
                  </thead>
                  <tbody>
                    @if(!empty($studio_equipments) && $studio_equipments->count())
                      @foreach($studio_equipments as $dt)
                      <tr>
                        <td>{{$dt->name}}</td>
                         <td>{{$dt->Category->cat_name}}</td>
                         <td>
                          @if($dt->status==0) <span class="bi bi-circle-fill text-danger"></span> Unavailable     
                          @else <span class="bi bi-circle-fill text-success"></span> Available @endif </td>
                          <td>{{$dt->serial_number}}</td>
                          <td>{{convertCurrency($dt->price)}} ({{session()->get('user_currency')}})</td>
                          <td align="right">
                            <i class="bi bi-pencil editicon" data-uuid="{{$dt->id}}"></i>
                          </td>
                      </tr>
                      @endforeach
                    @else
                    <tr>
                      <td colspan="6">No record found</td>
                    </tr>  
                    @endif
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="6">
                        <div class="foot-paging">
                          {!! $studio_equipments->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                        </div>  
                      </td>
                    </tr>
                  </tfoot>
                </table>
              </div>
            </div>
          </div>
          <div class="col-xl-5 user-card" style="display:none;">
            <div class="card thinborder" style="min-height:500px;">
              <div class="card-body pt-3"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- End Bordered Tabs -->
  </div>
</section>
@endsection
@section('footer_scripts')
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/index.global.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/@fullcalendar/bootstrap5@6.1.9/index.global.min.js'></script>
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script type="text/javascript" >
function dropfiles(){
  Dropzone.autoDiscover = false;
  /*var myDropzone = new Dropzone("#dropphoto", {
    url: "{{ route('file.upload') }}",
    method: "post",
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    paramName: "rental",
    maxFiles: 1,
    acceptedFiles: ".jpeg, .jpg, .png",
  });
  myDropzone.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#photo').val(response.fileName);
    $('#dispphotoimg').html('<img src="'+APP_URL+'/storage/'+response.rentalPath+'" class="img-fluid w-100" style="border-radius:5px;">');
    myDropzone.removeAllFiles(true);
  });
*/
  var myReceipt = new Dropzone("#dropreceipt", {
    url: "{{ route('file.upload') }}",
    method: "post",
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    paramName: "receipt",
    maxFiles: 1,
    acceptedFiles: ".jpeg, .jpg, .png, .pdf",
  });
  myReceipt.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#receipt').val(response.fileName);
    $('#dispreceiptimg').html('<img src="'+APP_URL+'/storage/'+response.receiptPath+'" class="img-fluid w-100" style="border-radius:5px;">');
    myReceipt.removeAllFiles(true);
  });
  $('#dropreceipt .dz-txt').html('or drag and drop PNG, JPG or pdf');

  var myManual = new Dropzone("#dropmanual", {
    url: "{{ route('file.upload') }}",
    method: "post",
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    paramName: "manual",
    maxFiles: 1,
    acceptedFiles: ".pdf",
  });
  myManual.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#manual').val(response.fileName);
    $('#dispmanualimg').html('<a href="'+APP_URL+'/storage/'+response.manualPath+'"  target="_blank">'+response.fileName+'</a>');
    myManual.removeAllFiles(true);
  });
  $('#dropmanual .dz-txt').html('or drag and drop pdf file');
}
</script>
<script>
  $(document).ready(function () {
    scheduleCalendarInit();
    
    $(document).on('click', '.addicon, .editicon', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      let uuid = $(this).data('uuid');
	    let locationId = $("#locationId").val();
		  let studioId = $("#studioId").val();
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, lid:uuid,type:'edit',locationId:locationId,studioId:studioId},
          url: APP_URL+"/equipment-detail",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
			   dropfiles();
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });
    $(document).on('click', '#btn_delete', function(){
      let obj = $(this);
      obj.attr('disabled',true);
      let did = obj.data('did');
      let type = obj.data('type');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, type:type, did:did},
          url: APP_URL+"/remove-action",
          success: function(res) {
            obj.attr('disabled',false);
            if(res.status){
              reload_tab("#Inventory");
            }
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });	
    $(document).on('click', '#btn_saveStudio', function(){
      let obj = $(this);
      obj.attr('disabled', true);
      var formData = new FormData($('#updateEquipment')[0]);
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: formData,
        processData: false,  
        contentType: false,  
        url: APP_URL+"/save-equipment",
        success: function(res) {
          obj.attr('disabled', false);
          if(res.status){
            reload_tab("#Inventory");
          }
        },
        error: function(res) {
          obj.attr('disabled', false);  
          ajax_error(res);
        }
      });
    });
  });
</script>

@endsection