@extends('layouts.sidebar')
@section('title', 'Nomadic-Manage Team')
@section('content')
<div class="pagetitle">
  <h1>Manage Team</h1>
</div><!-- End Page Title -->
<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Email</td>
                <td>Name</td>
                <td>Role</td>
                <td></td>
              </tr>
            </thead>
            <tbody>
              @if(!empty($data) && $data->count())
                @foreach($data as $dt)
                <tr>
                <td>@if(isset($dt->email)){{$dt->email}}@endif</td>
                  <td>{{$dt->fname}} {{$dt->lname}}</td>
                  <td>@if($dt->user_role){{$dt->user_role->role_name}}@endif</td>
                  
                  <td>
                    <i class="bi bi-pencil editicon" data-uuid="{{$dt->uuid}}"></i>
                  </td>
                </tr>
                @endforeach
              @else
              <tr>
                <td colspan="5">No record found</td>
              </tr>  
              @endif
            </tbody>
            <tfoot>
              <tr>
                <td colspan="5">
                  <div class="foot-paging">
                    {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

    <div class="col-xl-5 user-card" style="display:none;">
      <div class="card thinborder" style="min-height:500px;">
        <div class="card-body pt-3">
        </div>
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<script>
  $(document).ready(function () {
    $(document).on('click', '.editicon', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      let uuid = $(this).data('uuid');	  
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, uuid:uuid,type:'edit',locationId:'{{$locationId}}'},
          url: APP_URL+"/teaminfo",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
			  $('select[name="role"]').html(res.options).selectpicker('refresh');
              $('select[name="role"]').selectpicker();
			   $('select[name="specialist"]').html(res.specialist_option).selectpicker('refresh');
              $('select[name="specialist"]').selectpicker();
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });
	
	
	
	 $(document).on('click', '#btn_saveTeam', function(){
  let locationId = $('input[name="locationId"]').val();
  let daily_rate = $('input[name="daily_rate"]').val();
  let hourly_rate = $('input[name="hourly_rate"]').val();
      
      let roles = $('select[name="role"]').val();
      if(roles==null || roles.length==0){
        $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">Please select at least one role to proceed.</div>');
        $('#alertMsg').modal('show');
        return false;
      }
	  
	  let specialists = $('select[name="specialist"]').val();
      if(specialists==null || specialists.length==0){
        $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">Please select at least one specialist to proceed.</div>');
        $('#alertMsg').modal('show');
        return false;
      }
	  
	   let userID = $('#userID').val();
      let user_uuid = $('#user_uuid').val();
      let obj = $(this);
      obj.attr('disabled',true);
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, user_uuid:user_uuid, userID:userID, locationId:locationId, roles:roles, daily_rate:daily_rate, hourly_rate:hourly_rate, specialists:specialists},
          url: APP_URL+"/save-team",
          success: function(res) {
            obj.attr('disabled', false);
            if(res.status){
                $('.gridcard').removeClass('col-xl-7').addClass('col-xl-12');
                $('.user-card').hide();
                $('.user-card .card-body').html('');
                $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                $('#alertMsg').modal('show');
            }
        },
        error: function(res) {
            obj.attr('disabled', false);
            ajax_error(res);
        }
    });
});

	
	
	
    
    $(document).on('click', '#btn_addpermission', function(){
        let location = $('input[name="location"]').val();
      if(location==""){
        $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">Please select location to add permissions.</div>');
        $('#alertMsg').modal('show');
        return false;
      }
      let roles = $('select[name="role"]').val();
      if(roles==null || roles.length==0){
        $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">Please select at least one permission to proceed.</div>');
        $('#alertMsg').modal('show');
        return false;
      }
      let user_uuid = $('#user_uuid').val();
      let obj = $(this);
      obj.attr('disabled',true);
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, user_uuid:user_uuid, location:{{$locationId}}, roles:roles},
          url: APP_URL+"/add-permissions",
          success: function(res) {
            obj.attr('disabled',false);
            if(res.status){
              $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
              $('#alertMsg').modal('show');
            }
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });
  });
</script>
@endsection