@if($data)
<div class="row">
  <div class="col-md-7">
    @if($data->profile_pic)
    <img src="{{asset('storage/profile-pic')}}/{{$data->profile_pic}}" class="img-fluid" style="height:100%;">
    @else
    <img src="{{asset('images/user-img.png')}}" class="img-fluid" style="height:100%;">
    @endif
  </div>
  <div class="col-md-5">
    <label class="small text-muted">Name</label>
    <div class="clearboth"></div>
    <label class="small text-muted">
     <b> @if($data->fname){{ucfirst($data->fname)}} {{ucfirst($data->lname)}}@endif</b>
    </label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Email</label>
    <div class="clearboth"></div>
    <label class="small text-muted word-wrap">@if(isset($data->email))<b>{{$data->email}}</b>@endif</label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Phone</label>
    <div class="clearboth"></div>
    <label class="small text-muted">@if(isset($data->mobile_number))<b>{{$data->mobile_number}}</b>@endif</label>
  </div>
</div>
<div class="row">
  <div class="col-md-12 mt-3">
    <label class="small text-muted"><b>Bio</b></label>
    <div class="clearboth"></div>
    <label  class="small text-muted mt-3">@if(isset($data->description)){{$data->description}}@endif</label>
    @if(isset($data->address))
    <label class="small text-muted"><b>Address</b></label>
    <div class="clearboth"></div>
    <label  class="small text-muted mt-3">{{$data->address}}</label>
    <div class="clearboth"></div>
    @endif
    @if(isset($data->profile_link))
    <label class="small text-muted"><b>Links</b></label>
    <div class="clearboth"></div>
    <label  class="small text-muted mt-3">{{$data->profile_link}}</label>
    <div class="clearboth"></div>
    @endif
    @if(isset($data->instagram_link))
    <label  class="small text-muted mt-3">{{$data->instagram_link}}</label>
    <div class="clearboth"></div>
    @endif
    @if(isset($data->facebook_link))
    <label  class="small text-muted mt-3">{{$data->facebook_link}}</label>
    <div class="clearboth"></div>
    @endif
    @if(isset($data->twitter_link))
    <label class="small text-muted mt-3">{{$data->twitter_link}}</label>
    <div class="clearboth"></div>
    @endif

    <form id="updateTeam">
      @csrf
      <input type="hidden" id="user_uuid" name="user_uuid" value="{{$data->uuid}}" readonly>
      <input type="hidden" id="userID" name="userID" value="{{$data->id}}" readonly>

      <div class="clearboth"></div>
      <label class="small text-muted mt-4"><b>Assign Role</b></label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-10 position-relative">
        <input type="hidden" name="locationId" value="{{$locationId}}" />
        <select class="form-control" name="role" data-done-button="true" multiple></select>
        </div>
      </div>
      
      <div class="clearboth"></div>
      <label class="small text-muted mt-4"><b>Equipment Specialist</b></label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-10 position-relative">
        <select class="form-control" name="specialist" data-done-button="true" multiple></select>
        </div>
      </div>

      <div class="clearboth"></div>
      <label  class="small text-muted mt-4" for="daily_rate"><b>Daily Rate ({{session()->get('user_currency')}})</b></label>
      <div class="clearboth"></div>  
      <div class="row mb-2">
        <div class="col-md-10 position-relative"> 
          <input type="number" name="daily_rate" class="form-control" placeholder="$" id="daily_rate" value="@if($data){{convertCurrency($data->daily_rate)}}@endif" onkeypress="return event.charCode >= 48 && event.charCode <= 57"/> 
        </div>
      </div>
      
      <div class="clearboth"></div> 
      <label  class="small text-muted mt-4" for="hourly_rate"><b>Hourly Rate ({{session()->get('user_currency')}})</b></label>
      <div class="row mb-2">
        <div class="col-md-10 position-relative">
          <input type="number" name="hourly_rate" class="form-control" placeholder="$" id="hourly_rate" value="@if($data){{convertCurrency($data->hourly_rate)}}@endif" onkeypress="return event.charCode >= 48 && event.charCode <= 57"/>
        </div>
      </div>
    </form>
  </div>
</div>
<div class="row mt-3 usraction">
 
   <div class="col-md-6">
    <input id="btn_saveTeam" type="button" class="btn w-100 mb-2" value="Save Changes">
  </div>
 
</div>
@else
<div align="center">No data found</div>
@endif