  @extends('layouts.main')
  @section('title', 'Nomadic-Account Setting')
  @section('content')
  <div class="banner"></div>
  <div class="container position-relative" data-aos="fade-up" style="top:50px;padding-bottom:30px;">
    <h2 class="mt-4 mb-4">{{__('Account Settings')}}</h2>
    @if (session('error'))
    <div class="alert alert-danger p-2">{{session('error')}}</div>
    @elseif (session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
    <span id="page" style="display:none;">account-setting</span>
    <div class="row mb-5 d-block">
      <div class="col-xl-12">
        <ul class="nav nav-tabs nav-tabs-bordered" id="borderedTab2" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#bordered-profile" type="button" role="tab" aria-controls="Profile" aria-selected="true">My Profile</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="membership-tab" data-bs-toggle="tab" data-bs-target="#bordered-membership" type="button" role="tab" aria-controls="Membership" aria-selected="false">Membership</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="booking-tab" data-bs-toggle="tab" data-bs-target="#bordered-booking" type="button" role="tab" aria-controls="Booking" aria-selected="false">Points Balance</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="security-tab" data-bs-toggle="tab" data-bs-target="#bordered-security" type="button" role="tab" aria-controls="Security" aria-selected="false">Security</button>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" href="{{url('account-setting-calendar')}}">Calendar</a>
          </li>
        </ul>
        <div class="tab-content pt-2" id="borderedTabContent2">
          <div class="tab-pane fade show active" id="bordered-profile" role="tabpanel" aria-labelledby="profile-tab">
            <div class="row">
              <div class="col-xl-3">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Your Profile Picture</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <div id="dispbannerimg" class="mb-3">
                          @if($data->profile_pic)
                          <img src="{{asset('storage/profile-pic')}}/{{$data->profile_pic}}" class="img-fluid w-100" style="border-radius: 5px;">
                          @else
                          <img src="{{asset('images/user-img.png')}}" class="img-fluid w-100" style="border-radius: 5px;">
                          @endif
                        </div>
                        <form action="{{url('save-profile-picture')}}" method="post" enctype="multipart/form-data" id="imageUpload" class="dropzone">
                          @csrf
                          <input type="hidden" name="type" value="profile" readonly>
                        </form>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                      <label class="lblprofile">Personal Info</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="text" class="form-control" placeholder="First Name" name="fname" value="{{$data->fname}}">
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="text" class="form-control" placeholder="Last Name" name="lname" value="{{$data->lname}}">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Bio</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <textarea name="description" class="form-control txtarea mb-3" rows="8">{{auth()->user()->description}}</textarea>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                      <label class="lblprofile">Price ({{session()->get('user_currency')}})</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="number" class="form-control" placeholder="Daily Rate" name="daily_rate" value="{{convertCurrency($data->daily_rate)}}">
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="number" class="form-control" placeholder="Hourly Rate" name="hourly_rate" value="{{convertCurrency($data->hourly_rate)}}">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row mt-3">
              <div class="col-md-6 text-end">
                <input id="btn_saveaccount" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
              </div>
            </div>
          </div>
          <div class="tab-pane fade" id="bordered-membership" role="tabpanel" aria-labelledby="membership-tab">
            <div class="row mb-4">
              <div class="heading3 mt-3 mb-2">Membership level</div>
              <div class="col-md-12 border border-dark ms-3">
              @if($plan)
                <div class="p-2 mb-4">{{$plan->name}}</div>
                <h3 class="mb-4"><b>${{$plan->price}}</b><span>/{{$plan->frequency}}</span></h3>
                @if(auth()->user()->pm_type && auth()->user()->pm_type=='visa')
                <img src="{{asset('images/icon-visa.png')}}" alt="visa" width="25" height="25">
                @elseif(auth()->user()->pm_type && auth()->user()->pm_type=='master')
                <img src="{{asset('images/icon-mastercard.png')}}" alt="visa" width="25" height="25">
                @else
                <img src="{{asset('images/icon-card.png')}}" alt="Credit Card" width="25" height="25">
                @endif
                <span class="ms-3">****{{auth()->user()->pm_last_four}}</span>
                @if($next_billing_date!="")
                <div class="p-2">Your next billing date is {{$next_billing_date}}</div>
                @endif
                <div class="p-2"><i class="bi bi-check2 me-2"></i>{{$plan->points}} Pts</div>
                <div class="p-2"><i class="bi bi-check2 me-2"></i>
                @if($plan->stripe_plan=="")
                Must be invited by member
                @else
                Book up {{$plan->advance_duration}} {{$plan->advance_frequency}} in advance
                @endif
                </div>
                <div class="p-2"><i class="bi bi-check2 me-2"></i>{{$guests[$plan->num_of_guest]}} guests</div>

                <div class="p-2">
                  <input type="button" class="btn btn-danger subplancancel w-30 mb-2" value="Cancel Plan">
                  <a class="btn btn-dark w-30 mb-2" href="{{url('plans')}}">Change Plan</a>
                </div>
              @else
                <div class="p-2 mb-4">Guest</div>
              @endif
              </div>
            </div>
            <div class="row ms-1">
              <div class="heading3 ps-0 mb-2">Transactions</div>
              <table class="table">
                <thead>  
                  <tr>
                    <td>Date</td>
                    <td>Status</td>
                    <td>Total cost</td>
                  </tr>
                </thead>
                <tbody>
                  @foreach($points as $point)
                  @if($point->action=='MEMBERSHIP_CREDIT' || $point->action=='POINTS_PURCHASED')
                  <tr>
                    <td>{{date('d M Y',strtotime($point->created_at))}}</td>
                    <td>{{$points_action[$point->action]}} @if($point->plan_id) ({{$point->plan->name}}) @endif</td>
                    <td>@if($point->amount){{convertCurrency($point->amount)}}@else 0 @endif {{session()->get('user_currency')}}</td>
                  </tr>
                  @endif
                  @endforeach
                </tbody>
              </table>
            </div> 
          </div>
          <div class="tab-pane fade" id="bordered-booking" role="tabpanel" aria-labelledby="booking-tab">
            <div class="row mb-4">
              <div class="heading3 mt-3 mb-2">Points balance</div>
              <div class="col-md-6 border border-dark ms-3">
                <div class="row p-2 pt-4">
                  <div class="col-md-6">Last month booking cost</div>
                  <div class="col-md-5 text-end">{{$last_month_booking_cost}}pts</div>
                </div>
                <div class="row p-2">
                  <div class="col-md-6">Current month booking cost</div>
                  <div class="col-md-5 text-end">{{$current_month_booking_cost}}pts</div>
                </div>
                <div class="row p-2 pb-4">
                  <div class="col-md-6"><b>Current balance</b></div>
                  <div class="col-md-5 text-end"><b>{{$current_balance}}pts</b></div>
                </div>
                <div class="p-2 mt-5">
                  <input type="button" class="btn btn-primary w-30 mb-2 buypoints" data-type="cancel" value="Buy more points">
                  <input type="button" class="btn btn-dark transferpoint w-30 mb-2" data-type="change" value="Transfer point">
                </div>
              </div>
            </div>
            <div class="row ms-1">
              <div class="heading3 ps-0 mb-2">Transactions</div>
              <table class="table">
                <thead>  
                  <tr>
                    <td>Date</td>
                    <td>Status</td>
                    <td>Total cost</td>
                  </tr>
                </thead>
                <tbody>
                  @foreach($points as $point)
                  <tr>
                    <td>{{date('d M Y',strtotime($point->created_at))}}</td>
                    <td>{{$points_action[$point->action]}}</td>
                    <td>
                      @if($point->action=='POINTS_SENT' || $point->action=='BOOK_EVENT') {{$point->debit}}pts
                      @else {{$point->credit}}pts @endif
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div> 
          </div>
          <div class="tab-pane fade" id="bordered-security" role="tabpanel" aria-labelledby="security-tab">
            <div class="row">
              <div class="col-xl-3">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                      <label class="lblprofile">Phone number</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input type="tel" placeholder="Mobile Number" id="telephone" class="form-control shadow-none" maxlength="14"/>
                        <span id="msg" class="error"></span>
                        <input type="hidden" id="mobile_number" name="phone_number" value="{{$data->mobile_number}}"/>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">Email</label>
                  </div>
                </div>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-7 mb-2 position-relative">
                        <input name="email" class="form-control mb-3" placeholder="Email" value="{{auth()->user()->email}}" />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <div class="card">
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
                    <label class="lblprofile">
                      <a href="{{url('reset-password')}}" class="color-none">Reset Password</a>
                      <svg
                        class="_252"
                        width="24"
                        height="25"
                        viewBox="0 0 24 25"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          fill-rule="evenodd"
                          clip-rule="evenodd"
                          d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z"
                          fill="#111111"
                        />
                      </svg>
                    </label>
                  </div>
                </div>
              </div>
            </div>

            <div class="row mt-3">
              <div class="col-md-6 text-end">
                <input id="btn_savesecurity" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="otp_modal" style="display:none;z-index:10000;"></div>
  @endsection
  @section('footer_scripts')
  <link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
  <link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
  <script src="{{asset('js/dropzone.js')}}"></script>
  <link rel="stylesheet" href="{{asset('css/intlTelInput.css')}}">
  <script src="{{asset('js/intlTelInput.js')}}"></script>
  <script>
    var errorMap = ["{{__('Invalid number')}}", "{{__('Invalid country code')}}", "{{__('Too short')}}", "{{__('Too long')}}"];
    var input = document.querySelector("#telephone");
    var msg = document.querySelector("#msg");
    var intl = window.intlTelInput(input, {
        autoPlaceholder: false,
        separateDialCode: true,
        placeholderNumberType: "MOBILE",
        utilsScript: "{{asset('js/utils.js')}}"
    });
    // Validate on blur event
    input.addEventListener('keyup', function() {
        if(input.value.trim()){
            if(intl.isValidNumber()){
                input.classList.remove("error");
                msg.classList.add("hide");
                //msg.hide();
            }else{
                input.classList.add("error");
                var errorCode = intl.getValidationError();
                msg.innerHTML = errorMap[errorCode];
                msg.classList.remove("hide");
                //msg.show();
            }
        }
        let full_number = intl.getNumber();
        $('#mobile_number').val(full_number);
    });
    // input.addEventListener('keyup', (e) => {
    //     let val = e.target.value;
    //     e.target.value = val
    //     .replace(/\D/g, '')
    //     .replace(/(\d{1,4})(\d{1,3})?(\d{1,3})?/g, function(txt, f, s, t) {
    //         if (t) {
    //             return `(${f}) ${s}-${t}`
    //         } else if (s) {
    //             return `(${f}) ${s}`
    //         } else if (f) {
    //             return `(${f})`
    //         }
    //     });
    // });
    intl.setNumber($('#mobile_number').val());
    
    Dropzone.autoDiscover = false;
    var myDropzone = new Dropzone("#imageUpload",{ 
        maxFiles: 1,
        maxFilesize: 100,
        autoProcessQueue: true,
        uploadMultiple: false, 
        addRemoveLinks: true,
        acceptedFiles: ".jpeg,.jpg,.png"
    });
    myDropzone.on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress)+'%');
    });
    myDropzone.on("error", function (file, errorMessage) {
        $('.progress-text').html('0%').hide();
    });
    myDropzone.on("success", function (file, response) {
        $('.progress-text').html('0%').hide();
        $('#dispbannerimg').html('<img src="'+APP_URL+'/storage/profile-pic/'+response.success+'" class="img-fluid w-100" style="border-radius:5px;">');
    });
  
    $(document).ready(function () {
      $(document).on('click','.buypoints',function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token},
            url: APP_URL+"/buy-more-points",
            success: function(res) {
                if(res.status){
                  $('#otp_modal').html(res.content).modal('show');
                }
            },
            error: function(res) {                    
                ajax_error(res);
            }
        });
      });
      $(document).on('click','.transferpoint',function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token},
            url: APP_URL+"/transfer-points",
            success: function(res) {
                if(res.status){
                  $('#otp_modal').html(res.content).modal('show');
                }
            },
            error: function(res) {                    
                ajax_error(res);
            }
        });
      });
      $(document).on('click', '.subplancancel', function(){
        let obj = $(this);
        obj.attr('disabled',true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token},
            url: APP_URL+"/subscription-cancel",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status){
                $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                $('#alertMsg').modal('show');
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      });
      $(document).on('click', '#btn_saveaccount', function(){
        let obj = $(this);
        obj.attr('disabled',true);
        let fname = $('input[name="fname"]').val();
        let lname = $('input[name="lname"]').val();
        let description = $('textarea[name="description"]').val();
        let daily_rate = $('input[name="daily_rate"]').val();
        let hourly_rate = $('input[name="hourly_rate"]').val();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, fname:fname, lname:lname, description:description, daily_rate:daily_rate, hourly_rate:hourly_rate},
            url: APP_URL+"/account-setting-save",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status){
                $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                $('#alertMsg').modal('show');
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      });
      $(document).on('click', '#btn_savesecurity', function(){
        let obj = $(this);
        obj.attr('disabled',true);
        let email = $('input[name="email"]').val();
        let phone_number = $('input[name="phone_number"]').val();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, email:email, phone_number:phone_number},
            url: APP_URL+"/otp-verification-profile",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status && res.content!=""){
                $('#otp_modal').html(res.content).modal('show');
                OTPInput();
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      });

      $(document).on('click','#btn_otpverify',function(){
          if($('#otpForm').valid()){
              $('#btn_otpverify .spinner').show();
              $.ajax({
                  type: 'POST',
                  dataType: 'json',
                  data: $('#otpForm').serialize(),
                  url: APP_URL+"/verify-otp-profile",
                  success: function(res) {
                      $('#btn_otpverify .spinner').hide();
                      if(res.status){
                        $('#otp_modal').html('').modal('hide');
                        $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">Changes updated successfully.</div>');
                        $('#alertMsg').modal('show');
                      }
                  },
                  error: function(res) {                    
                      $('#btn_otpverify .spinner').hide();
                      ajax_error(res);
                  }
              });
          }
      });

      $(document).on('click','.send-otp',function(){
          let otpfield;
          let type = $(this).data('type');
          if(type=='email'){
              otpfield = $('#email').val();
          }else{
              otpfield = $('#mobile_number').val();
          }
          $.ajax({
              type: 'POST',
              dataType: 'json',
              data: {_token:_token, type:type, otpfield:otpfield},
              url: APP_URL+"/send-otp",
              success: function(res) {
                  if(res.status){
                      $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                      $('#alertMsg').modal('show');
                  }
              },
              error: function(res) {
                  ajax_error(res);
              }
          });
      });

      // $('#otpForm').validate({
      //     rules: {
      //         first: {
      //             required: true,
      //         },
      //         second: {
      //             required: true
      //         },
      //         third: {
      //             required: true
      //         },
      //         fourth: {
      //             required: true
      //         },
      //         fifth: {
      //             required: true
      //         },
      //         sixth: {
      //             required: true
      //         },
      //         eot1: {
      //             required: true,
      //         },
      //         eot2: {
      //             required: true
      //         },
      //         eot3: {
      //             required: true
      //         },
      //         eot4: {
      //             required: true
      //         },
      //         eot5: {
      //             required: true
      //         },
      //         eot6: {
      //             required: true
      //         },
      //     },
      //     errorElement: 'span',
      //     errorPlacement: function (error, element) {
      //         error.addClass('invalid-feedback float-start');
      //         element.closest('.rounded').append(error);
      //     },
      //     highlight: function (element, errorClass, validClass) {
      //         $(element).addClass('is-invalid');
      //     },
      //     unhighlight: function (element, errorClass, validClass) {
      //         $(element).removeClass('is-invalid');
      //     }
      // });
    });
  </script>
  @endsection