@extends('layouts.dashboard')
@section('content') 

    <div class="container">    
        <div class="contentbox">
            <div class="contentboxheading"><i class="las la-user-tie"></i> <span id="formStatus">Add New User</span>
                <a class="btn btn-primary pull-right mt-2 mr10 btn-form-toggle"><span>Show</span> Form</a>
            </div>
            <div class="contentboxinner">
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>   
                @endif
                <div class="form-container fhide"> 
                    <form class="row g-3" id="saveuser">
                        @csrf                    
                        <input type="hidden"  name="hdn_user_id" id="hdn_userId" readonly>  
                        <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
                        <div class="row mt-3"> 
                            <div class="col-3">
                                <label for="usertype" class="form-label ml10">User Type</label>
                                <select class="selectpicker" name="usertype" id="ddl_userType">
                                    <option value="0">Select User Type</option>
                                    @foreach($userType as $key=>$val)
                                        <option value="{{$key}}">{{$val}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-3">
                                <label for="fname" class="form-label ml10">First Name</label>
                                <input type="text" class="form-control" id="txt_fname" name="fname" placeholder="First name">
                            </div>   

                            <div class="col-md-3">
                                <label for="lname" class="form-label ml10">Last Name</label>
                                <input type="text" class="form-control" id="txt_lname" name="lname" placeholder="Last Name">
                            </div>
                        
                            <div class="col-md-3">
                                <label for="mobile" class="form-label ml10"> User Mobile</label>
                                <input type="text" class="form-control" id="txt_mobile" name="mobile" placeholder="Mobile">
                            </div>

                            <div class="col-md-3">
                                <label for="email" class="form-label ml10"> User Email</label>
                                <input type="email" class="form-control" id="txt_email" name="email" placeholder="example@example.xom">
                            </div>               
                            
                            <div class="col-md-3">
                                <label for="status" class="form-label ml10">Status</label>
                                <select id="inputState" class="selectpicker" id="ddl_status" name="status">
                                    <option value="1" selected>Active</option>
                                    <option value="0">In Active</option>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <div class="mt-2">
                                    <button type="button" class="btn btn-primary mt-4 mb-4" id="btn_adduser">Add user</button>
                                </div>
                            </div>
                        </div> 
                    </form>
                </div>
                <div class="row">
                    <div class="col-md-12">
                    <div class="subheading mt-2">Existing Users Details</div>
                        <div class=" mt-3 mb-3">
                            <table class="table table-striped" id="tbl_adduser">
                                <thead>
                                    <tr>
                                        <th>Action</th>
                                        <th>User Type</th>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th>Created By</th>
                                        <th>Created Date</th>
                                    </tr>
                                </thead>
                                <tbody id="ajaxData">@include('user.addUser_ajax')</tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer_scripts')
@endsection 