@extends('layouts.sidebar')
@section('title', 'Nomadic-Upcoming Guests')
@section('content')
<div class="pagetitle">
  <h1>Upcoming Guests</h1>
</div><!-- End Page Title -->

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input type="hidden" id="guestId" value="{{$guestId}}" readonly>
            <input id="search_field" type="text" class="form-control" placeholder="Search">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <th>Date & Time</th>
                <th>Invitation Type</th>
                <th>Guest Name</th>
                <th>Status</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              @if(!empty($data) && $data->count() > 0)
                @foreach($data as $dt)
                <tr>
                  <td>{{$dt->invitation_date}} {{$dt->invitation_time}}</td>
                  <td>{{ucfirst($dt->invitation_type)}}</td>
                  <td>{{ucfirst($dt->fname)}} {{ucfirst($dt->lname)}}</td>
                  <td class="guest_{{$dt->guest_uuid}}">
                    @if($dt->status==0) <span class="txtApproved">Invited</span> 
                    @elseif($dt->status==1) <span class="txtPayment">Check In</span> 
                    @elseif($dt->status==2) <span class="txtCancelled">Cancelled</span> @endif
                  </td>
                  <td>
                    <i id="guest_{{$dt->id}}" class="bi bi-eye vieweye" data-id="{{$dt->id}}" data-status="{{$dt->status}}" data-gfname="{{$dt->fname}}" data-glname="{{$dt->lname}}" data-gemail="{{$dt->email}}" data-hfname="{{$dt->host->fname}}" data-hlname="{{$dt->host->lname}}" data-invitation-date="{{$dt->invitation_date}}" data-invitation-time="{{$dt->invitation_time}}" data-location="{{$dt->location->location}}" data-hpic="{{$dt->host->profile_pic}}"></i>
                  </td>
                </tr>
                @endforeach
              @else
              <tr>
                <td colspan="4">No record found</td>
              </tr>  
              @endif
            </tbody>
            <tfoot>
              <tr>
                <td colspan="4">
                  <div class="foot-paging">
                    {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

    <div class="col-xl-5 user-card" style="display:none;">
      <div class="card thinborder" style="min-height:400px;">
        <div class="card-body pt-3">
          <div class="row">
            <div class="col-md-6">
              <img id="hpic" src="" class="img-fluid">
            </div>
            <div class="col-md-6">
              <input type="hidden" id="upcomingid" />
              <label class="small text-muted">Name</label>
              <div class="clearboth"></div>
              <label class="lblprofilebind" id="gname"></label>
              <div class="clearboth"></div>
              <label class="small text-muted mt-2">Email</label>
              <div class="clearboth"></div>
              <label class="lblprofile" id="gemail"></label>
              <div class="clearboth"></div>
              <label class="small text-muted mt-2">Invited By</label>
              <div class="clearboth"></div>
              <label class="lblprofile" id="hname"></label>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-6">
              <label class="small text-muted">Date</label>
              <div class="clearboth"></div>
              <label class="lblprofile" id="invdate"></label>
            </div>
            <div class="col-md-6">
                <label class="small text-muted">Location</label>
                <div class="clearboth"></div>
                <label class="lblprofile" id="ulocation"></label>
            </div>
          </div>
          <div class="row mt-4 actionbtns"></div>
        </div>
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<script>
  $(document).ready(function () {
    let guest_id = $('#guestId').val();
    console.log(guest_id);
    if(guest_id!=""){
      let obj = $('#guest_'+guest_id);
      view_guest(obj);
    }

    $(document).on('click', '.vieweye', function(){
      view_guest($(this));
    });

    $(document).on('click', '.invaction', function(){
      let status = $(this).data('status');
      let upcoming_id = $('#upcomingid').val();
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, upcoming_id:upcoming_id, status:status},
        url: APP_URL+"/invite-action",
        success: function(res) {
          if(res.status){
            window.location.reload();
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });

  });
  function view_guest(obj){
    $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      
    let picurl;
    let hpic = obj.data('hpic');
    if(hpic){
      picurl = APP_URL+'/storage/profile-pic/'+hpic;
    }else{
      picurl = APP_URL+'/images/user-img.png';
    }
    $('#upcomingid').val(obj.data('id'));
    $('#hpic').attr('src',picurl);
    $('#gname').html(obj.data('gfname')+' '+obj.data('glname'));
    $('#gemail').html(obj.data('gemail'));
    $('#hname').html(obj.data('hfname')+' '+obj.data('hlname'));
    $('#invdate').html(obj.data('invitation-date')+' '+obj.data('invitation-time'));
    $('#ulocation').html(obj.data('location'));
    let statusHtml;
    let status = obj.data('status');
    if(status==0){
      statusHtml = '<div class="col-md-6"><input type="button" class="btn btn-danger invaction w-100 mb-2" data-status="2" value="Cancel Invitation" /></div><div class="col-md-6"><input type="button" class="btn btn-dark invaction w-100 mb-2" data-status="1" value="CheckIn" /></div>';
    }else if(status==1){
      statusHtml = '<div class="col-md-6"><input type="button" class="btn btn-danger invaction w-100 mb-2" data-status="2" value="Cancel Invitation" /></div>';
    }else if(status==2){
      statusHtml = '<div class="col-md-6"><input type="button" class="btn btn-dark invaction w-100 mb-2" data-status="0" value="Invite Again" /></div>';
    }
    $('.actionbtns').html(statusHtml);
    $('.user-card').show();
  }
</script>
@endsection