<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\GlobalController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\ManagingController;
use App\Http\Controllers\ContentEditingController;
use App\Http\Controllers\StudioController;
use App\Http\Controllers\RentalController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\GuestController;										
use App\Http\Controllers\GuestDataController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\CronJobController;
use App\Http\Controllers\CommunicationController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [HomeController::class, 'home'])->name('home');
Route::get('home', [HomeController::class, 'home'])->name('home');
Route::get('language/{locale}', function ($locale) {
    app()->setLocale($locale);
    session()->put('locale', $locale);

    return redirect()->back();
});

Route::get('/test', [CronJobController::class, 'test_email']);

Route::get('/iptracking/{token}', [CronJobController::class, 'iptracking']);

Route::post('set-currency', [UserController::class, 'set_currency']);

Route::post('send-otp', [UserController::class, 'send_otp']);
Route::post('verify-otp', [UserController::class, 'verify_otp']);
Route::post('stripe-webhook', [PlanController::class, 'stripe_webhook']);

Route::get('reset-password', [UserController::class, 'resetPassword'])->name('reset-password');
Route::post('reset-password', [UserController::class, 'submitResetPassword']);
Route::get('update-password/{token}', [UserController::class, 'updatePassword']);
Route::post('update-password', [UserController::class, 'submitUpdatePassword']);

//frontend
Route::get('locations', [PageController::class, 'locations']);
Route::get('location/{slug}', [PageController::class, 'location_detail']);
Route::get('studios', [PageController::class, 'studios']);
Route::get('studio-type/{slug}', [PageController::class, 'studio_type']);
Route::get('location-studio/{locslug}/{stslug}', [PageController::class, 'location_studio']);
Route::get('studio/{id}', [PageController::class, 'studio_detail']);
Route::get('our-partners', [PageController::class, 'our_partners']);
Route::get('crew', [PageController::class, 'crew']);
Route::get('crew-profile/{uuid}', [PageController::class, 'crew_profile']);
Route::get('events', [PageController::class, 'events']);
Route::get('/view-event/{eventId}', [PageController::class, 'view_event']);
Route::get('/news', [PageController::class, 'news']);
Route::get('/view-news/{newsId}', [PageController::class, 'view_news']);
Route::get('/services', [PageController::class, 'services']);

Route::group(['middleware' => ['guest','loc']], function() {
    Route::get('login-email', [UserController::class, 'login_manual'])->name('login-otp');
    Route::get('login', [UserController::class, 'login'])->name('login');
    Route::post('login-save', [UserController::class, 'login_save']);
    Route::get('signup', [UserController::class, 'signup']);
    Route::post('signup-validate', [UserController::class, 'signup_validate']);
    Route::get('otp-verification', [UserController::class, 'otp_verification']);
    Route::post('signup-save', [UserController::class, 'signup_save']);
});

Route::group(['middleware' => ['auth','custom_auth']], function() {
    Route::get('my-profile', [HomeController::class, 'my_profile'])->name('my-profile');
    Route::post('sendbird-token', [UserController::class, 'sendbird_token']);

    Route::get('/invite-guest/{type?}/{id?}', [GuestDataController::class, 'invite_guest']);
    Route::post('/invite-guest-process', [GuestDataController::class, 'invite_guest_process'])->name('invite.guest.process');//cron job
    Route::get('/invitations', [GuestDataController::class, 'invitations']);
    Route::get('/invited-guest', [GuestDataController::class, 'invited_guest']);
    Route::post('invite-action', [GuestController::class, 'invite_action']);
    Route::post('/guest-data', [GuestDataController::class, 'guest_data']);
    // frontent pages
    Route::post('/event/interested/{eventId}', [ManagingController::class, 'event_action_interested']);
    Route::post('/event/going/{eventId}', [ManagingController::class, 'event_action_going']);
    // booking
    Route::get('booking-list', [BookingController::class, 'booking_list']);
    Route::post('booking-form', [BookingController::class, 'index']);
    Route::get('choose-your-preference/{type}', [BookingController::class, 'choose_your_preference']);
    Route::post('make-selection', [BookingController::class, 'make_selection']);
    Route::post('check-availability', [BookingController::class, 'check_availability']);
    Route::get('booking-process', [BookingController::class, 'booking_process']);
    Route::get('booking-confirmed/{number}', [BookingController::class, 'booking_confirmed']);
    Route::post('booking-cancelled', [BookingController::class, 'booking_cancelled']);
    Route::post('read-notification', [UserController::class, 'read_notification']);
    
    //backend
    Route::get('backend/dashboard', function () {
        return view('dashboard');
    });
    Route::get('logout', [UserController::class,'logout'])->name('logout');
    Route::get('profile-picture', [UserController::class, 'profile_picture']);
    Route::post('save-profile-picture', [UserController::class, 'save_profile_picture']);
    Route::post('remove-profile-picture', [UserController::class, 'remove_profile_picture']);
    
    Route::get('plans', [PlanController::class, 'index']);
    Route::get('plans/{plan}', [PlanController::class, 'show'])->name("plans.show");
    Route::post('subscription', [PlanController::class, 'subscription'])->name("subscription.create");
    Route::post('subscription-cancel', [PlanController::class, 'subscription_cancel']);
    Route::post('buy-more-points', [PlanController::class, 'buy_more_points']);
    Route::get('purchase-points/{points}', [PlanController::class, 'purchase_points']);
    Route::post('process-buy-more-points', [PlanController::class, 'process_buy_more_points'])->name("charge.points");

    Route::get('additional-information', [UserController::class, 'additional_information'])->name('additional-information');
    Route::post('add-info-save', [UserController::class, 'additional_info_save']);
    Route::get('consent', [UserController::class, 'consent'])->name('consent');
    Route::get('congratulations', [UserController::class, 'congratulations'])->name('congratulations');
    Route::post('remove-action', [GlobalController::class, 'remove_action']);

    Route::get('account-setting', [GlobalController::class, 'account_setting']);
    Route::post('account-setting-save', [GlobalController::class, 'account_setting_save']);
    Route::get('account-setting-calendar', [GlobalController::class, 'account_setting_calendar']);
    Route::post('calendar-upsert-sch', [GlobalController::class, 'calendar_upsert_sch']);
    Route::post('otp-verification-profile', [GlobalController::class, 'otp_verification_profile']);
    Route::post('verify-otp-profile', [GlobalController::class, 'verify_otp_profile']);
    Route::post('search-user', [UserController::class, 'search_user']);

    Route::get('backend/applications', [GlobalController::class, 'applications']);
    Route::get('backend/manage-users', [GlobalController::class, 'applications']);
    Route::post('user-app-action', [UserController::class, 'user_app_action']);
    Route::post('userinfo', [UserController::class, 'userinfo']);
    Route::post('userroles', [UserController::class, 'userroles']);
    Route::post('add-permissions', [UserController::class, 'add_permissions']);
    
    Route::post('transfer-points', [UserController::class, 'transfer_points']);
    Route::post('add-points', [UserController::class, 'add_points']);
    
    Route::post('update-user', [UserController::class, 'update_user']);
    Route::post('save-profile', [GlobalController::class, 'save_profile']);
    Route::get('backend/user-management/{uuid}', [GlobalController::class, 'user_management']);
    Route::get('backend/locations', [GlobalController::class, 'locations']);
    Route::post('location-detail', [GlobalController::class, 'location_detail']);
    Route::post('save-location', [GlobalController::class, 'save_location']);
    Route::get('backend/account-settings', [GlobalController::class, 'account_settings']);
    Route::get('backend/billing', [GlobalController::class, 'billing']);

    Route::get('backend/location-landing-page/{locationId}', [ContentEditingController::class, 'location_landing_page']);
    Route::post('backend/location-landing-page-save/{locationId}', [ContentEditingController::class, 'location_landing_page_save']);

    Route::get('backend/local-studios/{locationId}', [ContentEditingController::class, 'local_studios']);
    Route::get('backend/studio-landing-page/{locationId}/{studioId?}', [ContentEditingController::class, 'studio_landing_page']);
    Route::post('backend/studio-landing-page-save/{locationId}', [ContentEditingController::class, 'studio_landing_page_save']);

    Route::get('backend/manage-news/{locationId}', [ContentEditingController::class, 'manage_news']);
    Route::get('backend/news/{locationId}/{newsId?}', [ContentEditingController::class, 'upsert_news']);
    Route::post('backend/save-news/{locationId}', [ContentEditingController::class, 'save_news']);
    Route::get('backend/delete-news/{locationId}/{id}', [ContentEditingController::class, 'delete_news']);

    Route::get('backend/manage-events/{locationId}', [ContentEditingController::class, 'manage_events']);
    Route::get('backend/events/{locationId}/{eventsId?}', [ContentEditingController::class, 'upsert_events']);
    Route::post('backend/save-events/{locationId}', [ContentEditingController::class, 'save_events']);
    Route::get('backend/delete-events/{locationId}/{id}', [ContentEditingController::class, 'delete_events']);

    Route::post('fileupload', [ContentEditingController::class, 'fileupload']);
    Route::post('gallery-images', [ContentEditingController::class, 'gallery_images']);
    Route::post('gallery-image-delete', [ContentEditingController::class, 'gallery_image_delete']);

    Route::get('backend/schedule-location/{locationId}', [ManagingController::class, 'schedule_location']);
    Route::post('studio-detail', [ManagingController::class, 'studio_detail']);
    Route::post('save-studio', [ManagingController::class, 'save_studio']);
	
    Route::get('backend/studio-list/{locationId}/{studioId}/', [StudioController::class, 'studio_booking']);
    Route::post('equipment-detail', [StudioController::class, 'equipment_detail']);
    Route::post('save-equipment', [StudioController::class, 'save_equipment']);
	 
    Route::get('backend/rentals/{locationId}', [RentalController::class, 'rental_booking']);
    Route::post('rental-detail', [RentalController::class, 'rental_detail']);
    Route::post('save-rental', [RentalController::class, 'save_rental']);
    Route::get('backend/equipment-schedule/{locationId}/{equipmentId}', [RentalController::class, 'equipment_schedule']);
    Route::post('backend/fileupload', [RentalController::class, 'upload'])->name('file.upload');
	 
    Route::get('backend/team/{locationId}', [ManagingController::class, 'team_list']);
    Route::post('team-detail', [ManagingController::class, 'team_detail']);
    
	Route::get('backend/allevents/{locationId}', [ManagingController::class, 'schedule_event_list']);
	Route::get('backend/event-detail/{locationId}/{event_id}', [ManagingController::class, 'event_detail']);
	Route::get('backend/event-responded/{locationId}/{event_id}', [ManagingController::class, 'listParticipants']);
	Route::post('/events/{event}/participants/interested', [ManagingController::class, 'markInterested'])
    ->name('events.participants.interested');
	Route::post('/events/{event}/participants/going', [ManagingController::class, 'markGoing'])
    ->name('events.participants.going');

	Route::post('/events/{event}/participants/remove', [ManagingController::class, 'removeParticipant'])
    ->name('events.participants.remove');
	
	Route::post('/booking/mark/{bookingDetailId}/{status}', [ManagingController::class, 'bookingStatus']);

	Route::get('backend/team/{locationId}', [GlobalController::class, 'team']);
	Route::post('teaminfo', [UserController::class, 'teaminfo']);
	Route::post('save-team', [UserController::class, 'save_team']);
   
    Route::post('/import-guest-data', [GuestDataController::class, 'import'])->name('import.guest.data');
    Route::get('/process-guest-data', [GuestDataController::class, 'processGuestData'])->name('process.guest.data');
	
    //Route::get('backend/all-studios/{locationId}', [ContentEditingController::class, 'all_studios']);
    //Route::get('backend/all-studios/{locationId}', [ContentEditingController::class, 'upsert_events']);
    
    // Route::post('calendar-events', [GlobalController::class, 'calendar_events']);
	
    Route::post('calendar-sch-events', [GlobalController::class, 'calendar_sch_events']);
    Route::post('calendar-delete-sch-events', [GlobalController::class, 'calendar_delete_sch_events']);
	
	Route::get('backend/upcoming-guests/{locationId}/{guestId?}', [GuestController::class, 'upcoming_guests']);

    ///////////////////////////// Messages //////////////////////////////
    Route::get('discuss', [CommunicationController::class, 'index']);
    Route::post('messages', [CommunicationController::class, 'messages']);
    Route::post('send-txt', [CommunicationController::class, 'send_txt']);
    
    
});
